



'        Welcome to B.A.T. 10, the Boffoid Algorithmic Translator!
'
'           ***********     Press F5 to begin     ************
'
'     Or, choose the Exit option under the File menu to return to DOS.
'
'         Or, push PageDown to browse through the program listing.
'
' Or, just sit there and stare and the screen all day until atrophy develops.







' BAT-10 v2.0 by Geoff Draper - anno Domini 1993
' Last revised 19 Jan 1994
' Released to the public domain 2 Mar 2006

COMMON SHARED pi AS DOUBLE, e AS DOUBLE, loga AS STRING
DECLARE SUB logar ()
DECLARE SUB trig1 ()
DECLARE SUB trig2 ()
DECLARE SUB trig3 ()
DECLARE SUB stat ()
DECLARE SUB pigag ()
DECLARE SUB calc ()
DECLARE SUB complex ()
DECLARE SUB quad ()
DECLARE FUNCTION arccos# (a AS SINGLE, b AS SINGLE, C AS SINGLE)
DECLARE FUNCTION arcsin# (a AS SINGLE, aa AS DOUBLE, b AS SINGLE)
DECLARE FUNCTION factorial# (cp AS DOUBLE)
DECLARE SUB statsub (a AS INTEGER)
DECLARE SUB Buffer ()

RANDOMIZE TIMER
ON ERROR GOTO Handler
GOTO StartProgram
Handler: RESUME NEXT
StartProgram:
CLS
SCREEN 9
COLOR 15, 0
LOCATE 10, 18
PRINT "Math doesn't have to be great to be useful,"
PRINT TAB(18); "Nor does math have to be useful to be great."
LOCATE 14, 45
PRINT "--Some really noteworthy"
PRINT TAB(47); "but nevertheless dead"
PRINT TAB(47); "mathematician"
SLEEP 6

pi = 4 * ATN(1): e = EXP(1)
loga = "r3d4ru3dl4gdrud2r2erdr"
CLS
COLOR 11, 1
LOCATE 8, 34
PRINT CHR$(201); STRING$(11, 205); CHR$(187)
PRINT TAB(34); CHR$(186); " B.A.T. 10 "; CHR$(186)
PRINT TAB(34); CHR$(200); STRING$(11, 205); CHR$(188)
LOCATE 12, 32
PRINT "Version 1.414214"; CHR$(253)
a$ = "Press any of the well-polished keys on your keyboard to begin."
DO
        FOR I = 2 TO 15
        LOCATE 23, 10
        FOR ii = 1 TO LEN(a$)
        COLOR I
        IF INKEY$ <> "" THEN EXIT DO
        a2$ = a2$ + MID$(a$, ii, 1)
        NEXT ii
        PRINT a2$: a2$ = ""
        NEXT I
LOOP

BigOlLoop:
CLS
COLOR 15, 10
PRINT : PRINT " Greetings, Traveler.  Concentrate soulfully on the Mathematic realm which "
PRINT " besieges thee.  When thou hast obtained inner harmony and tranquility, select"
PRINT " with prudence the Operation which fits thy sagacious Task...": PRINT
PRINT " 1. Logarithms, Antilogarithms, Nth roots, and other nefarious deeds"
PRINT " 2. Trigonometry"
PRINT " 3. More Trigonometry"
PRINT " 4. Oh, boy! Even more Trigonometry"
PRINT " 5. Combinations, Permutations, & Factorials (nCr/nPr/!)"
PRINT " 6. Search for Pi"
PRINT " 7. Calculus"
PRINT " 8. Complex Numbers"
PRINT " 9. Quadratic Formula"
PRINT " 10. Exit program and spend quality time with family"
Buffer
PRINT : INPUT " What'll it be, Bwana"; Choice$
Choice% = VAL(Choice$)
IF Choice% < 1 OR Choice% > 10 THEN PRINT : PRINT " I am not amused.": SLEEP 2: GOTO BigOlLoop
IF Choice% = 10 THEN GOTO EndProgram
SELECT CASE Choice%
CASE 1
        CALL logar
CASE 2
        CALL trig1
CASE 3
        CALL trig2
CASE 4
        CALL trig3
CASE 5
        CALL stat
CASE 6
        CALL pigag
CASE 7
        CALL calc
CASE 8
        CALL complex
CASE 9
        CALL quad
END SELECT
GOTO BigOlLoop
EndProgram:
SCREEN 0
CLS
COLOR 7
LOCATE 24
PRINT "BAT-10:  The Boffoid Algorithmic Translator"
PRINT "version 2.0": PRINT
PRINT "by Geoff Draper": PRINT
PRINT "This program is not shareware, nor is it user-supported. Sending the author a"
PRINT "cheque for $15.00, plus $2.50 shipping and handling, is completely unnecessary."

'As of March 2006, this program is public domain, so I am commenting
'out the line below regarding program modification rights. --GMD

REM PRINT "However, the author retains exclusive rights for modification of said program."
PRINT "Feel free to distribute this program to your friends, your neighbors, your"
PRINT "milkman, your pets, and your great-aunt Bertha. See if they start to resent you.": PRINT
PRINT "The author would like to acknowledge the music of R.E.M. and Sting, which he"
PRINT "listened to incessantly during the creation of this program.": PRINT
PRINT "This program was written between June and August 1993 (a great way to spend"
PRINT "the summer, eh?) using Microsoft QBasic, and re-released as open source in"
PRINT "March 2006.": PRINT
PRINT "A special thanks to the twenty amino acids, without whom this program (and"
PRINT "life on earth as we know it) would have been impossible.": PRINT
PRINT "Version 1.0 of BAT-10, with significantly less abilities than version 2.0, was"
PRINT "originally created for the Commodore 64 personal computer.": PRINT
SYSTEM

DEFDBL E, P
FUNCTION arccos# (a AS SINGLE, b AS SINGLE, C AS SINGLE)
x# = (C ^ 2 + b ^ 2 - a ^ 2) / (2 * b * C)
arccos1# = (-ATN(x# / SQR(-x# * x# + 1)) + pi / 2) * 180 / pi
IF ABS(arccos1# - INT(arccos1# + .5)) < .0001 THEN arccos1# = INT(arccos1# + .5)
arccos = arccos1#
END FUNCTION

DEFSNG E, P
FUNCTION arcsin# (a AS SINGLE, aa AS DOUBLE, b AS SINGLE)
x# = b * SIN(aa) / a
arcsin1# = ATN(x# / SQR(-x# * x# + 1)) * 180 / pi
IF ABS(arcsin1# - INT(arcsin1# + .5)) < .0001 THEN arcsin1# = INT(arcsin1# + .5)
arcsin = arcsin1#
END FUNCTION

SUB Buffer
Buffy: IF INKEY$ <> "" THEN GOTO Buffy
END SUB

SUB calc
SCREEN 0
COLOR 15, 6
CLS
PRINT TAB(36); "CALCULUS": PRINT
PRINT " Howdy, people! I'll try not to be overly loquacious. We've got some good stuff"
PRINT " ready for you here in the calculator, er... Calculus corral.  Don't get all"
PRINT " bent bassackwards yet, but if you see some red flags waving in your face, be"
PRINT " sure you've got some arrows in your quiver to fall back on. Time may be a"
PRINT " problem. This program may be beneficial, but it is definitely not a panacea."
PRINT " Fore!": PRINT
PRINT "   NOTE:  THIS MODULE OF BAT-10 IS TEMPORARILY CLOSED DUE TO THE AUTHOR'S"
PRINT "   COMPLETE IGNORANCE OF THE MECHANISMS OF CALCULUS. SERVICE WILL CONTINUE"
PRINT "   JUST AS SOON AS THIS SITUATION IS REMEDIED. IN THE MEANTIME, GRAB YOUR"
PRINT "   GOLF CLUBS AND HEAD FOR THE GREEN!": PRINT
PRINT TAB(28); "Press any key to continue."
SLEEP
SCREEN 9
END SUB

SUB complex
BeginComplex:
CLS
COLOR 15, 3
PRINT TAB(33); "COMPLEX NUMBERS": PRINT
PRINT " Rarely does one stumble upon a Mathematical entity with as much enduring charm"
PRINT " as the complex number. Better known to the masses as imaginary numbers, these"
PRINT " little gems have intrigued scholars since their accidental discovery years ago"
PRINT " in a fetid petri dish. Complex numbers' domestic applications are many. Their"
PRINT " contributions to vectors, coordinate geometry, and delicious homemade pie"
PRINT " crust are all well documented.": PRINT
PRINT " Do you want to try:": PRINT
PRINT " 1. Ambition (Addition)"
PRINT " 2. Distraction (Subtraction)"
PRINT " 3. Uglification (Multiplication)"
PRINT " 4. Derision (Division)"
PRINT " 5. Return to main menu": PRINT
Buffer
DO
INPUT " What'll it be, slugger"; a$: a% = VAL(a$)
IF a% >= 1 AND a% <= 5 THEN EXIT DO
PRINT "  Not bloody likely."
LOOP
IF a% = 5 THEN GOTO EndComplex
op$ = "+"
IF a% = 2 THEN
op$ = "-"
ELSEIF a% = 3 THEN op$ = "x"
ELSEIF a% = 4 THEN op$ = CHR$(246)
END IF
CLS
LOCATE 2, 29
PRINT "( A1 , B1 ) "; op$; " ( A2 , B2 )": PRINT
INPUT " Enter A1: ", a1$: a1# = VAL(a1$)
INPUT " Enter B1: ", b1$: b1# = VAL(b1$)
INPUT " Enter A2: ", a2$: a2# = VAL(a2$)
INPUT " Enter B2: ", b2$: b2# = VAL(b2$)
PRINT
Divide: SELECT CASE a%
CASE 1
ans1 = a1# + a2#: ans2 = b1# + b2#
CASE 2
ans1 = a1# - a2#: ans2 = b1# - b2#
CASE 3
ans1 = a1# * a2# - b1# * b2#: ans2 = a1# * b2# + a2# * b1#
CASE 4
aa = a2# / (a2# ^ 2 + b2# ^ 2): bb = -b2# / (a2# ^ 2 + b2# ^ 2)
ans1 = a1# * aa - b1# * bb: ans2 = a1# * bb + aa * b1#
END SELECT
IF a% = 4 AND a2# = 0 AND b2# = 0 THEN PRINT " Trying to divide by zero, eh? I nobody's fool.": GOTO PressKee
PRINT " And the bone-chilling answer is: ("; CDBL(ans1); ","; CDBL(ans2); ")."
PressKee:
PRINT
PRINT TAB(27); "Press any key to continue."
SLEEP
GOTO BeginComplex
EndComplex:
END SUB

DEFDBL E, P
FUNCTION factorial# (cp AS DOUBLE)
fct# = 1
FOR I# = 1 TO cp
fct# = fct# * I#
NEXT
factorial# = fct#
END FUNCTION

DEFSNG E, P
SUB logar

Begin:
CLS
COLOR 8, 11
PRINT TAB(35); "LOGARITHMS"
PRINT : PRINT " Despite its really important-sounding name, a logarithm is simply the inverse"
PRINT " of an exponential function and can now be tamed without the sadomasochistic"
PRINT " domination games traditionally associated with this Mathematical phenomenon.": PRINT
PRINT " The exponentialogarithmic concept can be written three ways:": PRINT
PRINT "     a"; CHR$(252); " = x     "; CHR$(252); CHR$(251); "x = a     log x = n": PRINT
PSET (249, 121)
DRAW "x" + VARPTR$(loga)
PRINT " But first, what did you have in mind?"
PRINT : PRINT " 1. Natural Logarithms (base e)"
PRINT " 2. Common Logarithms (base 10)"
PRINT " 3. Generic Logarithms (any base)"
PRINT " 4. Return to Main Menu": PRINT
Buffer
chooseone: INPUT " Choose one: ", a$: a% = VAL(a$)
IF a% < 1 OR a% > 4 THEN PRINT "I can only accept 1, 2, 3, or 4 here.": GOTO chooseone
SELECT CASE a%
CASE 1   'Natural
        CLS
        PRINT " Natural logarithms are logarithms with a base of"; e
        PRINT " This number is better known to the civilized world as e. These logarithms are"
        PRINT " called natural because if you're looking for a good base for your logarithm,"
        PRINT " it's only natural to choose a number like"; e
        PRINT : PRINT "     e"; CHR$(252); " = x     "; CHR$(252); CHR$(251); "x = e     ln x = n"
Xorn:   PRINT : INPUT " Do you want me to solve for x or n"; a$
        IF a$ <> "x" AND a$ <> "n" AND a$ <> "X" AND a$ <> "N" THEN PRINT "Don't tread on me.": GOTO Xorn
        SELECT CASE a$
        CASE "x", "X"
nlimit:         PRINT : INPUT " n="; N$: N# = VAL(N$): IF N# > 88.02969 THEN PRINT "Try a smaller number.": GOTO nlimit
                PRINT : PRINT " x ="; e ^ N#
        CASE "n", "N"
xlimit:         PRINT : INPUT " x="; x$: x# = VAL(x$): IF x# <= 0 THEN PRINT "x must be positive": GOTO xlimit
                PRINT : PRINT " n ="; CDBL(LOG(x#))
        END SELECT
CASE 2   'Common
        CLS
        PRINT " Common logarithms are logarithms with a base of 10.  They are called common"
        PRINT " because you can find these logarithms anywhere: in the gutter, behind"
        PRINT " the bookcase, or inside your glove compartment.  These logarithms are a bit"
        PRINT " simpler and less intimidating than natural logarithms, and are a good topic"
        PRINT " for conversation on a first date.": PRINT
        PRINT "     10"; CHR$(252); " = x     "; CHR$(252); CHR$(251); "x = 10     log x = n"
Xorn2:  PRINT : INPUT " Do you want me to solve for x or n"; a$
        IF a$ <> "x" AND a$ <> "n" AND a$ <> "X" AND a$ <> "N" THEN PRINT "Don't tread on me.": GOTO Xorn2
        SELECT CASE a$
        CASE "x", "X"
nlim2:          PRINT : INPUT " n="; N$: N# = VAL(N$): IF N > 38.5 THEN PRINT "Try a smaller number.": GOTO nlim2
                PRINT : PRINT " x ="; CDBL(10 ^ N#)
        CASE "n", "N"
xlim2:          PRINT : INPUT " x="; x$: x# = VAL(x$): IF x# <= 0 THEN PRINT "x must be positive.": GOTO xlim2
                PRINT : PRINT " n ="; CDBL(LOG(x#) / LOG(10))
        END SELECT
CASE 3   'Logarithms of any base
        CLS
        PRINT " Consider this a Logarithm Construction Set.  Here you will supervise every"
        PRINT " step in the creation of your very own unique logarithm.  This is more chal-"
        PRINT " lenging than natural or common logarithms, which come with pre-fabricated"
        PRINT " bases.  You may even begin to feel some parental emotions about the logarithms"
        PRINT " you create here.  So, without further ado...": PRINT
        PRINT "     a"; CHR$(252); " = x     "; CHR$(252); CHR$(251); "x = a     log x = n"
        PSET (249, 93)
        DRAW "x" + VARPTR$(loga)
xorn3:  PRINT : INPUT " Do you want me to solve for x, n, or a"; a$
        IF a$ <> "x" AND a$ <> "n" AND a$ <> "a" AND a$ <> "X" AND a$ <> "N" AND a$ <> "A" THEN PRINT "That's not funny.": GOTO xorn3
        SELECT CASE a$
        CASE "x", "X"
xinp:           PRINT : INPUT " a="; a$: a# = VAL(a$): IF a# = 1 OR a# <= 0 THEN PRINT " That's not allowed.": GOTO xinp
                INPUT " n="; N$: N# = VAL(N$)
                x# = a# ^ N#
                IF x# > (3.4 ^ 38) OR x# < (10 ^ -44) THEN PRINT " Be reasonable.": GOTO xinp
                PRINT : PRINT " x ="; x#
        CASE "n", "N"
ninp:           PRINT : INPUT " a="; a$: a# = VAL(a$): IF a# = 1 OR a# <= 0 THEN PRINT " That's not allowed.": GOTO ninp
                INPUT " x="; x$: x# = VAL(x$)
                PRINT : PRINT " n ="; CDBL(LOG(x#) / LOG(a#))
        CASE "a", "A"
ainp:           PRINT : INPUT " n="; N$: N# = VAL(N$): IF N# = 0 THEN PRINT " For your convenience, n cannot be zero.": GOTO ainp
ainp2:          INPUT " x="; x$: x# = VAL(x$): IF x# <= 0 THEN PRINT " For your convenience, x must be positive.": GOTO ainp2
                PRINT : PRINT " a ="; CDBL(x# ^ (1 / N#))
        END SELECT
CASE 4
        GOTO EndSub
END SELECT
PRINT " Press any key to continue."
SLEEP
GOTO Begin
EndSub:
END SUB

SUB pigag
CLS
COLOR 15, 1
PRINT TAB(37); "PI QUEST": PRINT
PRINT " O, Pi... thou elusive number, thou feverish obsession of Archimedes!  The"
PRINT " mere thought of thee makes the heart pound within any good Mathematician's"
PRINT " chest. The very pronunciation of thy divine syllable causes the hungry man's"
PRINT " stomach to growl! We beseech thee, then, o eternal and unchanging Constant,"
PRINT " to make thyself known to us in thine utmost clarity.  Smile favorably on this"
PRINT " crude electronic ambassador.  May it be thine instrument."
PRINT
Buffer
PRINT TAB(25); "Humbly press any key to continue."
SLEEP
CLS
PRINT " Hold your breath; here goes nothing!!"
PRINT " Press ESC to stop the calculations and return to main menu.": PRINT
pig$ = MID$(STR$(pi), 2, 17)
I = 0
DO UNTIL I = 17
        I = I + 1
        PRINT MID$(pig$, I, 1);
        IF INKEY$ = CHR$(27) THEN pig$ = "zippy": EXIT DO
        tim = TIMER
timmy:  IF TIMER < tim + .25 THEN GOTO timmy
LOOP
IF pig$ = "zippy" THEN GOTO Endpigag
DO WHILE INKEY$ <> CHR$(27)
        PRINT MID$(STR$(INT(RND * 10)), 2, 1);
        tim = TIMER
timmi:  IF TIMER < tim + .25 THEN GOTO timmi
LOOP
Endpigag:
PRINT : PRINT
PRINT " Had enough, eh?  Oh, well... wipe your chin; you're drooling."
PRINT : PRINT "    Press any key."
SLEEP
END SUB

SUB quad
BeginQuad:
CLS
COLOR 15, 9
PRINT TAB(32); "QUADRATIC FORMULA": PRINT
PRINT " The Quadratic Formula is a formula used to solve quadratic equations."
PRINT " Quadratic equations are a peculiar Mathematical entity, for while they are easy"
PRINT " to create, they possess the unnerving ability to become literally conscious of"
PRINT " their own existance and may grow homocidal if threatened. For this reason,"
PRINT " we will limit our discussion to quadratic equations that can be solved under"
PRINT " the domain of real numbers. This type is less prone to become... shall we say,"
PRINT " uncooperative.": PRINT
PRINT " Quadratic Equation: ax"; CHR$(253); " + bx + c = 0": PRINT
PRINT " Quadratic Formula: x = -b "; CHR$(241); " "; CHR$(251); "(b"; CHR$(253); " - 4ac)"
LINE (191, 181)-(318, 181)
PRINT TAB(32); "2a": PRINT
Buffer
ia: INPUT " a="; a$: a! = VAL(a$)
IF a! = 0 THEN PRINT "  For your convenience, 'a' cannot equal zero.": GOTO ia
INPUT " b="; b$: b! = VAL(b$)
INPUT " c="; C$: C! = VAL(C$)
IF b ^ 2 - 4 * a * C < 0 THEN PRINT "  That would result in a non-real number. For your own safety, try again.": GOTO ia
x1# = (-b + SQR(b ^ 2 - 4 * a * C)) / (2 * a): x2# = (-b - SQR(b ^ 2 - 4 * a * C)) / (2 * a)
PRINT
PRINT " Illustrious solutions are: "; x1#; "and "; x2#
PRINT
PRINT " Push R to return to main menu; push anything else to continue."
DO
a$ = INKEY$
LOOP WHILE a$ = ""
IF a$ <> "r" AND a$ <> "R" THEN GOTO BeginQuad
END SUB

DEFDBL E, P
SUB stat
Startstat:
CLS
COLOR 15, 7
PRINT TAB(25); "POINTLESS STATISTICAL OPERATIONS"
PRINT : PRINT " Combinations and permutations are statistical exercises dealing with taking"
PRINT " certain numbers of imaginary objects certain amounts at a time.  They have"
PRINT " just about nil applications in the real world, a fact which only contributes"
PRINT " to their enormous popularity among youth.": PRINT
PRINT " What sounds good right about now?": PRINT
PRINT " 1. Combinations"
PRINT " 2. Permuatations"
PRINT " 3. Factorials"
PRINT " 4. Something really cute that I think you'll like"
PRINT " 5. Return to main menu"
Buffer
GetNum: PRINT : INPUT " What is YOUR choice"; a$: a% = VAL(a$)
IF a% < 1 OR a% > 5 THEN PRINT " You're not fooling anyone, you know.": GOTO GetNum
SELECT CASE a%
CASE 1
        CLS
        PRINT " Exactly what is a combination?  Well, it defies the purpose of this program to"
        PRINT " let you know what is really going on.  So I won't tell you.  What I will tell"
        PRINT " you is that it is an experience that will change you forever.  And if not, at"
        PRINT " least you will be able to brag to your jealous friends about it."
        PRINT : PRINT " A combination follows the this formula:": PRINT
        PRINT TAB(20); "n!"
        LINE (113, 111)-(198, 111)
        PRINT TAB(15); "(n - r)! r!": PRINT
        CALL statsub(a%)
CASE 2
        CLS
        PRINT " Contrary to popular belief, a permutation is not what happens to your new hair"
        PRINT " do on a bad day.  Permutations are not quite as complex as combinations, but"
        PRINT " that does not make them any less important or intriguing to work with.": PRINT
        PRINT " Permutations are divined by the following formula:": PRINT
        PRINT TAB(19); "n!"
        LINE (120, 97)-(182, 97)
        PRINT TAB(16); "(n - r)!": PRINT
        CALL statsub(a%)
CASE 3
        CLS
        PRINT " When I first started writing this program, I had no intention of including this"
        PRINT " factorial module in it.  But after programming in the combination and permu-"
        PRINT " tation services, I realized how fitting and proper it would be to offer fac-"
        PRINT " torials too.  So, added at the last minute and at great expense, here it is:": PRINT
Fact:   INPUT " Enter a positive integer between 1 and 160: ", N$: N# = INT(VAL(N$))
        IF N# < 1 OR N# > 160 THEN PRINT " Who are you trying to kid?": GOTO Fact
        cp# = N#: N# = factorial(cp#)
        PRINT : PRINT " And the answer is (pause for fanfare): "; INT(N#)
CASE 4
        CLS
        PRINT " This is really NEAT.  This is a little routine that employs either"
        PRINT " combinations or permutations (I forget which) but is impressive nonetheless."
        PRINT " You will enter a word, and I will spew out all the different ways that its"
        PRINT " letters can be arranged.  You're gonna love it.": PRINT
        INPUT "  Go ahead.  Enter a word: ", s$
        PRINT : PRINT " No problem...": PRINT
        N = LEN(s$): DIM C(N - 1)
110     I = N - 1: PRINT s$ + " ";
120     s$ = LEFT$(s$, I - 1) + RIGHT$(s$, N - I) + MID$(s$, I, 1)
        C(I) = C(I) + 1: IF C(I) <= N - I GOTO 110
        C(I) = 0: IF I > 1 THEN I = I - 1: GOTO 120
        PRINT
CASE 5
GOTO Endstat
END SELECT
PRINT : PRINT "     Neat, huh?  Press any key to continue."
SLEEP
GOTO Startstat
Endstat:
END SUB

SUB statsub (a%)
        PRINT " Due to computer limitations, n and r should be no larger than 160."
        PRINT
Entern: INPUT " Enter n: ", N$: N# = INT(VAL(N$))
        IF N# < 1 OR N# > 160 THEN PRINT " Not today.": GOTO Entern
Enterr: INPUT " Enter r: ", r$: r# = INT(VAL(r$))
        IF r# > N# OR r# < 1 THEN PRINT " Not today.": GOTO Enterr
        cp# = N# - r#: nminr# = factorial(cp#)
        cp# = r#: r# = factorial(cp#)
        cp# = N#: N# = factorial(cp#)
        IF a% = 1 THEN combin# = N# / (nminr# * r#) ELSE combin# = N# / nminr#
        PRINT : PRINT " And the answer is (pause for drumroll)... "; INT(combin#)
END SUB

DEFSNG E, P
SUB trig1
BeginTrig1:
CLS
COLOR 15, 12
PRINT TAB(34); "TRIGONOMETRY": PRINT
PRINT " In the wise words of the Poet, "; CHR$(34); "Trigonometry may not be a solution to world"
PRINT " hunger, but at least it's something to do in the meantime."; CHR$(34); "  Put bluntly,"
PRINT " trigonometry is the study of triangles.  In this module, you have the chance"
PRINT " to dabble in the basic precepts of trigonometry...": PRINT
PRINT " What would you like to do?"
PRINT : PRINT " 1. Play with degrees"
PRINT " 2. Print-out a conversion table between common trig fractions and their decimal"
PRINT "    equivalents"
PRINT " 3. Return to main menu"
Buffer
choose1: PRINT : INPUT "Choose One: ", a$: a% = VAL(a$)
SELECT CASE a%
CASE IS < 1, IS > 3
        PRINT " I'm not impressed.": GOTO choose1
CASE 1
        CLS
        PRINT " Howdy! Let me tell you how things run around here.  You will type in an angle"
        PRINT " measure in degrees and then I will deduce a whole lot of neat stuff about"
        PRINT " that angle.  If this sounds like fun, that's because it is.  Get psyched!"
Buffer
        PRINT : INPUT "Enter an angle measure in degrees: "; ang$: ang# = VAL(ang$)
        PRINT :
        PRINT " Angle is "; RTRIM$(STR$(ang#)); CHR$(248); "."
        rad# = ang# * pi / 180: PRINT " Otherwise known as "; rad#; "radians."
quadrt: IF ABS(ang#) > 360 THEN ang# = ang# - 360 * SGN(ang#): GOTO quadrt
        IF ang# < 0 THEN ang# = 360 + ang#
        PRINT " This angle lies ";
        IF ang# = 0 OR ang# = 180 OR ang# = 360 THEN
                PRINT "on the x-axis."
        ELSEIF ang# = 90 OR ang# = 270 THEN
                PRINT "on the y-axis."
        ELSEIF ang# > 0 AND ang# < 90 THEN
                PRINT "in the first quadrant."
        ELSEIF ang# > 90 AND ang# < 180 THEN
                PRINT "in the second quadrant."
        ELSEIF ang# > 180 AND ang# < 270 THEN
                PRINT "in the third quadrant."
        ELSEIF ang# > 270 AND ang# < 360 THEN
                PRINT "in the fourth quadrant."
        END IF
        rad# = ang# * pi / 180
        sine# = SIN(rad#): cosine# = COS(rad#)
        IF ABS(sine#) < 10 ^ -15 THEN sine# = 0
        IF ABS(cosine#) < 10 ^ -15 THEN cosine# = 0
        IF ABS(sine#) > .49999999999# AND ABS(sine#) < .50000000001# THEN sine# = .5 * SGN(sine#)
        IF ABS(cosine#) > .49999999999# AND ABS(cosine#) < .50000000001# THEN cosine# = .5 * SGN(cosine#)
        IF ABS(ABS(sine#) - ABS(cosine#)) < .00001 THEN cosine# = ABS(sine#) * SGN(cosine#)
        PRINT " The sine is "; sine#
        PRINT " The cosine is "; cosine#
        PRINT " The tangent is ";
        IF cosine# = 0 THEN PRINT "incalculable." ELSE PRINT sine# / cosine#
        PRINT " The cotangent is ";
        IF sine# = 0 THEN PRINT "too embarrassing to mention." ELSE PRINT cosine# / sine#
        PRINT " The secant is ";
        IF cosine# = 0 THEN PRINT "beyond my meager comprehension." ELSE PRINT 1 / cosine#
        PRINT " The cosecant is ";
        IF sine# = 0 THEN PRINT "undefined under these circumstances." ELSE PRINT 1 / sine#
        PRINT : PRINT " Whew! That was wild!"
CASE 2
        CLS
        PRINT " This activity requires a printer.  If you don't have a printer, or are not"
        PRINT " willing to use up one sheet of paper, then press Q.  If you do have a printer,"
        PRINT " then make sure it is turned ON and then press any key other than Q to go on."
Buffer
PressQ: a$ = INKEY$: IF a$ = "" THEN GOTO PressQ
        IF a$ = "q" OR a$ = "Q" THEN GOTO Obfuscate
        LPRINT " When you've done as much trig as I have, you notice certain ratios that"
        LPRINT " appear again and again.  They are commonly written as easily-recognizable"
        LPRINT " fractions. But, since the computer insists on writing them as obscure deci-"
        LPRINT " mals, you can use this handy chart to convert the computer's figures into"
        LPRINT " the clean-cut fractions you grew up with. Enjoy!"
        LPRINT : LPRINT " Square root of two ="; SQR(2#)
        LPRINT " Square root of two over two ="; SQR(2#) / 2
        LPRINT " Square root of three ="; SQR(3#)
        LPRINT " Square root of three over two ="; SQR(3#) / 2
        LPRINT " Square root of three over three ="; SQR(3#) / 3
        LPRINT " Two times the square root of three over three ="; 2 * SQR(3#) / 3
        LPRINT : LPRINT " Now, was that as good for you as it was for me?"
CASE 3
        GOTO EndTrig1
Obfuscate:
END SELECT
PRINT : PRINT " Press any key to continue."
SLEEP
GOTO BeginTrig1
EndTrig1:
END SUB

DEFDBL E, P
SUB trig2
Starttrig2:
CLS
COLOR 15, 5
PRINT TAB(32); "MORE TRIGONOMETRY": PRINT
PRINT " Now that you've had a taste of the top fluff of trigonometry, you are ready"
PRINT " for the deeper, meatier stuff.  We are going to solve triangles.  Not just"
PRINT " right triangles, either.  Thanks to advanced algorithms (the word `algorithm'"
PRINT " is not necessarily derived from the name of any particular Vice-President),"
PRINT " all you need to provide is three tidbits of information about your triangle."
PRINT " I'll do the rest.": PRINT
PRINT " Do you want to tell me:": PRINT
PRINT " 1. The lengths of all three sides (SSS)"
PRINT " 2. Two sides and their included angle (SAS)"
PRINT " 3. Two sides and an angle opposite one of them (SSA)"
PRINT " 4. Two angles and a side opposite one of them (AAS)"
PRINT " 5. Two angles and a side shared by both (ASA)"
PRINT " 6. Return to main menu": PRINT
Buffer
Choix: INPUT " Name your poison: ", a$: a% = VAL(a$)
IF a% < 1 OR a% > 6 THEN PRINT " Just type a number 1 though 6.": GOTO Choix
IF a% = 6 THEN GOTO EndTrig2
CLS
LINE (450, 37)-(375, 112): LINE (375, 112)-(547, 112): LINE (547, 112)-(450, 37)
LOCATE 5, 51: PRINT "c"
LOCATE 5, 63: PRINT "b"
LOCATE 8, 50: PRINT "B"
LOCATE 8, 66: PRINT "C"
LOCATE 4, 57: PRINT "A"
PSET (455, 115): DRAW "x" + VARPTR$(loga$)
LOCATE 3, 3: PRINT "(Triangle not necessarily drawn to scale)"
LOCATE 6, 10: PRINT "Figures shown in yellow"
LOCATE 7, 14: PRINT "are the unknowns"
COLOR 14
SELECT CASE a%
CASE 1
        LOCATE 8, 50: PRINT "B": LOCATE 8, 66: PRINT "C": LOCATE 4, 57: PRINT "A"
        COLOR 15
        LOCATE 11
        INPUT " Enter length of side a: ", sidea$: sidea! = ABS(VAL(sidea$))
        INPUT " Enter length of side b: ", sideb$: sideb! = ABS(VAL(sideb$))
        INPUT " Enter length of side c: ", sidec$: sidec! = ABS(VAL(sidec$))
        anga# = arccos(sidea, sideb, sidec)
        angb# = arccos(sideb, sidea, sidec)
        angc# = arccos(sidec, sidea, sideb)
        PRINT
        IF ABS(180 - anga# - angb# - angc#) > .0001 OR anga# = 0 OR angb# = 0 OR angc# = 0 THEN PRINT " It is beyond my capacity to solve that triangle.": GOTO PressKey
        PRINT " Angle A measures"; anga#; "degrees."
        PRINT " Angle B measures"; angb#; "degrees."
        PRINT " Angle C measures"; angc#; "degrees."
CASE 2
        LOCATE 8, 50: PRINT "B": LOCATE 4, 57: PRINT "A": LOCATE 5, 51: PRINT "c"
        COLOR 15
        LOCATE 11
        INPUT " Enter length of side a: ", sidea$: sidea! = ABS(VAL(sidea$))
        INPUT " Enter length of side b: ", sideb$: sideb! = ABS(VAL(sideb$))
        INPUT " Enter measure of angle C (in degrees): ", angc$: angc# = ABS(VAL(angc$)) * pi / 180
        sidec! = SQR(sidea ^ 2 + sideb ^ 2 - 2 * sidea * sideb * COS(angc#))
        anga# = arccos(sidea, sideb, sidec)
        angb# = arccos(sideb, sidea, sidec)
        PRINT
        IF ABS(180 - anga# - angb# - angc# * 180 / pi) > .0001 OR sidea = 0 OR sideb = 0 OR angc# = 0 THEN PRINT " I'm not programmed to adequately solve that triangle.": GOTO PressKey
        PRINT " Angle A measures"; anga#; "degrees."
        PRINT " Angle B measures"; angb#; "degrees."
        PRINT " Side c is"; sidec; "units long."
CASE 3
        LOCATE 8, 50: PRINT "B": LOCATE 8, 66: PRINT "C": LOCATE 5, 51: PRINT "c"
        COLOR 15
        LOCATE 11
        INPUT " Enter length of side a: ", sidea$: sidea! = ABS(VAL(sidea$))
        INPUT " Enter length of side b: ", sideb$: sideb! = ABS(VAL(sideb$))
        INPUT " Enter measure of angle A (in degrees): ", anga$: anga# = ABS(VAL(anga$))
        angb# = arcsin(sidea, anga# * pi / 180, sideb)
        angc# = 180 - angb# - anga#
        sidec! = sidea * SIN(angc# * pi / 180) / SIN(anga# * pi / 180)
        PRINT
        IF angb# = 0 OR sidea = 0 OR sideb = 0 OR anga# = 0 THEN PRINT " That triangle is a bit too weird for me.": GOTO PressKey
        PRINT " Angle B measures"; angb#; "degrees."
        PRINT " Angle C measures"; angc#; "degrees."
        PRINT " Side c is"; sidec; "units long."
        IF anga# < 90 THEN
                angb# = angb# + 90
                angc# = 180 - anga# - angb#
                sidec! = sidea * SIN(angc# * pi / 180) / SIN(anga# * pi / 180)
                IF sidec! <= 0 THEN GOTO Whoops
                PRINT " Alternatively,"
                PRINT " Angle B could measure"; angb#; "degrees."
                PRINT " Angle C could measure"; angc#; "degrees."
                PRINT " Side c could be"; sidec; "units long."
Whoops:   
        END IF
CASE 4
        LOCATE 8, 66: PRINT "C": LOCATE 5, 51: PRINT "c": LOCATE 5, 63: PRINT "b"
        COLOR 15
        LOCATE 11
        INPUT " Enter length of side a: ", sidea$: sidea! = ABS(VAL(sidea$))
        INPUT " Enter measure of angle A (in degrees): ", anga$: anga# = ABS(VAL(anga$))
        INPUT " Enter measure of angle B (in degrees): ", angb$: angb# = ABS(VAL(angb$))
        angc# = 180 - anga# - angb#
        anga# = anga# * pi / 180: angb# = angb# * pi / 180
        sideb! = sidea * SIN(angb#) / SIN(anga#)
        sidec! = sidea * SIN(angc# * pi / 180) / SIN(anga#)
        PRINT
        IF angc# <= 0 OR sideb = 0 OR sidec = 0 THEN PRINT " Triangles like that are no fun to solve.": GOTO PressKey
        PRINT " Side b is"; sideb; "units long."
        PRINT " Side c is"; sidec; "units long."
        PRINT " Angle C measures"; angc#; "degrees."
CASE 5
        LOCATE 5, 51: PRINT "c": LOCATE 5, 63: PRINT "b": LOCATE 4, 57: PRINT "A"
        COLOR 15
        LOCATE 11
        INPUT " Enter length of side a: ", sidea$: sidea! = ABS(VAL(sidea$))
        INPUT " Enter measure of angle B (in degrees): ", angb$: angb# = ABS(VAL(angb$))
        INPUT " Enter measure of angle C (in degrees): ", angc$: angc# = ABS(VAL(angc$))
        anga# = 180 - angb# - angc#
        angb# = angb# * pi / 180: angc# = angc# * pi / 180
        sideb! = sidea * SIN(angb#) / SIN(anga# * pi / 180)
        sidec! = sidea * SIN(angc#) / SIN(anga# * pi / 180)
        PRINT
        IF anga# <= 0 OR sideb = 0 OR sidec = 0 THEN PRINT " That triangle does not exist in this dimension.": GOTO PressKey
        PRINT " Angle A measures"; anga#; "degrees."
        PRINT " Side b is"; sideb; "units long."
        PRINT " Side c is"; sidec; "units long."
END SELECT
PressKey:
PRINT
PRINT "    Press any key to continue..."
SLEEP
GOTO Starttrig2
EndTrig2:
END SUB

DEFSNG E, P
SUB trig3
StartTrig3:
CLS
COLOR 15, 13
PRINT TAB(20); "TRIGONOMETRY:  NOW, THE REALLY ARCANE STUFF": PRINT
PRINT " You've spent sleepless nights pondering the realms of Trigonometry, and have"
PRINT " found it tantalizing. Still, your life is missing something. You want more,"
PRINT " and you want it NOW. This is a perfectly normal reaction. Here, you will be"
PRINT " granted the opportunity to observe, first hand, one of Trigonomety's most"
PRINT " rewarding processes: the conversion between Cartesian and Polar coordinates."
PRINT : PRINT " Shall I convert:": PRINT
PRINT " 1. Cartesian to Polar form"
PRINT " 2. Polar to Cartesian form"
PRINT " 3. Huh? Return to main menu": PRINT
Buffer
pc: INPUT " My electrodes anxiously await your response: ", a$: a% = VAL(a$)
IF a% < 1 OR a% > 3 THEN PRINT "  I don't think so. Try again.": GOTO pc
IF a% = 3 THEN GOTO EndTrig3
CLS
SELECT CASE a%
CASE 1
        PRINT " An excellent choice! Cartesian coordinates are represented as (x,y) but"
        PRINT " stalwart trig buffs insist on the Polar form, shown as (r,"; CHR$(233); "). Both are fun for"
        PRINT " rowdy late-night math get-togethers with friends. For this exercise, you will"
        PRINT " enter x and y, and I will compute the equivalent r and "; CHR$(233); "."
        INPUT " Give me an 'x': ", x$: x! = VAL(x$)
        INPUT " ...... and 'y': ", y$: y! = VAL(y$)
        r! = SQR(x ^ 2 + y ^ 2)
        temp1 = x / r
        theta! = (-ATN((temp1) / SQR(-(temp1) * (temp1) + 1)) + pi / 2) * 180 / pi
        IF ABS(theta - INT(theta + .5)) < .0001 THEN theta = INT(theta + .5)
        IF theta < 0 THEN theta = 360 + theta
        theta2 = theta + 180 + 360 * (theta >= 180)
        PRINT : PRINT " Hence,"
        PRINT " r = "; r: PRINT " "; CHR$(233); " = "; theta; "degrees."
        PRINT : PRINT " Alternatively,"
        PRINT " r = "; -r: PRINT " "; CHR$(233); " = "; theta2; "degrees."
CASE 2
        PRINT " A noble decision! You have decided to convert Polar coordinates, shown as"
        PRINT " (r,"; CHR$(233); "), to Cartesian coordinates, shown as (x,y).  Which form is better? That"
        PRINT " question is wrestled daily by zealous tax-funded philosophers. They should"
        PRINT " have a conclusive answer by the turn of the century, if all goes well. In the"
        PRINT " meantime, just cross your fingers and wait.": PRINT
        INPUT " Enter r: ", r$: r! = VAL(r$)
        PRINT " Enter "; CHR$(233); : INPUT " (in degrees): ", theta$: theta! = VAL(theta$) * pi / 180
        PRINT : PRINT " Therefore,"
        PRINT " x = "; r * COS(theta)
        PRINT " y = "; r * SIN(theta)
END SELECT
PRINT : PRINT TAB(27); "Press any key to continue."
SLEEP
GOTO StartTrig3
EndTrig3:
END SUB

