import sys
import random

WHERE = 0
DESCRIPTION = 1
MAXCARRY = 2


map="""
+-------+--------+-------+
| stage / pantry / kitch |
|   1   ?   2        3   |
|       /        /       |
+--/ /--+--------+--/ /--+
|a      / rain   /      p|
|u  4       5        6  a|
|d      /        /      r|
+--/ /--+--------+--/ /--+
|       /        |       |
|   7       8    |   9   |
| foyer /  dark  |office |
+-------+--------+-------+
"""
    
allverbs = ['TAKE', 'GET', 'GRAB', 'PICK', 'DROP', 
                    'GIVE', 'LEAVE', 'DELIVER', 'OPEN', 'UNLOCK', 
                    'LIST', 'HELP', 'GO', 'RELOOK', 'CONSULT', 
                    'CLOSE', 'EAT', 'TASTE']

allnouns = {'DOOR': [None, None],
                    'UMBRELLAOPEN': [None, "There is an open UMBRELLA here."],
                    'UMBRELLACLOSED': ['DARK', "There is a closed UMBRELLA in the corner."],
                    'CAKE': ['SEATING', "Ah, here is the CAKE which you are to deliver to the Party Room."], 
                    'KEY': ['OFFICE', "There is an old brass KEY on the floor."], 
                    'MAP': ['PANTRY', "Here's a MAP of this crazy place."], 
                    'GLOBE': ['STAGE', "There is a GLOBE in the center of the room and it is softly glowing."], 
                    'WRAPPER': [None, "There is an old gum WRAPPER in this room."]
                        }

if random.random() > 0.5:
    allnouns['WRAPPER'] = 'PARTY'
else:
    allnouns['WRAPPER'] = 'KITCHEN'
    
    
rooms = {'STAGE':  "You are now on the Stage. The Seating Room is to the South. There is a door to the east.",
                    'PANTRY':  "You are in the Pantry. There is a door to the west and an open passageway to the east.",
                    'KITCHEN':  "This is the Kitchen but nothing is happening in here right now.",
                    'SEATING':  "You are in the Seating Room of an auditorium. You can see the Stage to the north, a doorway to the south, and a doorway to the east. You notice that it's raining in the room to the east.",
                    'RAIN':  "The ceiling of this room really needs fixing. Rain is falling through the ceiling and running through tiny holes in the floor.",
                    'PARTY':  "Welcome to the Party Room. There are doorways to the north and west. The east wall has a giant picture of an elephant. The south wall has a small curtain made out of bright green beads.",
                    'FOYER':  "You are in a room called the Foyer. There is a small doorway to the east and a large doorway to the north.",
                    'DARK':  "This room is so dark that it is called the Dark Room. You can see light coming from the west doorway.",
                    'OFFICE':  "You are now in the Office."
                    }

                                    # [north, south, east, west]
doors = {'STAGE':  [None, 'SEATING', 'PANTRY*', None],    #1
                    'PANTRY': [None, None, 'KITCHEN', 'STAGE*'], #2
                    'KITCHEN': [None, 'PARTY', None, 'PANTRY'], #3
                    'SEATING': ['STAGE', 'FOYER', 'RAIN*', None], #4
                    'RAIN': [None, None, 'PARTY', 'SEATING'],  #5
                    'PARTY': ['KITCHEN', 'OFFICE*', None, 'RAIN*'],  #6
                    'FOYER': ['SEATING', None, 'DARK*', None], #7
                    'DARK': [None, None, None, 'FOYER*'],  #8
                    'OFFICE': ['PARTY*', None, None, None], #9
                    }

directions = ['N', 'S', 'E', 'W']

#-----------------------------------------------------------------

def defaultresponse():
    print "The %s is hard to %s." % (noun, verb)

#BEGIN
currentroom = 'FOYER'
carried = 0
winner = False
while not winner:
    
    print "\n"
    print rooms[currentroom]
    
    if currentroom == 'DARK' and not (allnouns['GLOBE'][WHERE] == 'DARK' or allnouns['GLOBE'][WHERE] == 'HANDS'):
        print "It's too dark to see anything else in here."
        
    else:
        for thisnoun in allnouns.keys():
            if allnouns[thisnoun][WHERE] == currentroom:
                print allnouns[thisnoun][DESCRIPTION]

    
    userinput = ''
    print "\nWhat do you intend to do now?"
    userinput = raw_input()
    words = userinput.upper().split()
    
    try:
        verb, noun = words[0], words[-1]
    except IndexError:
        verb = 'L'
        noun = 'L'
    #print "verb:%s  noun:%s" % (verb, noun)
    if noun == 'UMBRELLA':
        if allnouns['UMBRELLAOPEN'][WHERE] == 'HANDS'or allnouns['UMBRELLAOPEN'][WHERE] == currentroom:
            noun = 'UMBRELLAOPEN'
        elif allnouns['UMBRELLACLOSED'][WHERE] == 'HANDS' or allnouns['UMBRELLACLOSED'][WHERE] == currentroom:
            noun = 'UMBRELLACLOSED'

    if verb in directions:
        whichway = directions.index(verb)
        
        if doors[currentroom][whichway] != None and not doors[currentroom][whichway].endswith('*'):            # standard doorway
            currentroom = doors[currentroom][whichway]

        elif doors[currentroom][whichway] != None:            #special doorway
            
            if (currentroom == 'STAGE' or currentroom == 'PANTRY') and allnouns['KEY'][WHERE] != 'HANDS':
                print "You need the KEY to get through the locked DOOR."
            
            elif currentroom == 'SEATING' and allnouns['CAKE'][WHERE] == 'HANDS':
                print "The UMBRELLA can protect you from the falling rain but nothing can protect the CAKE from the water that spatters up from the floor. You must find some other way to deliver the CAKE to the party room."
            
            elif currentroom == 'SEATING' and allnouns['UMBRELLAOPEN'][WHERE] != 'HANDS':
                print "No one can enter the Rain Room without an open UMBRELLA."
            
            elif (currentroom == 'PARTY' or currentroom == 'OFFICE') and allnouns['UMBRELLAOPEN'][WHERE] == 'HANDS':
                print "You cannot take an open UMBRELLA through that small passageway."
            
            else: #we passed all the gotchas
                currentroom = doors[currentroom][whichway][:-1] #room name with * stripped off
                
        else:                                                                                 #a wall
            print "You cannot walk through walls."

    elif verb == 'GET':
        
        if allnouns[noun][WHERE] == 'HANDS':
            print "You still have it."
        
        elif allnouns[noun][WHERE] != currentroom:
            print "There's no", noun, "here."

        elif carried < MAXCARRY:
            allnouns[noun][WHERE] = 'HANDS'
            carried += 1
            print "You have it now."
            
        else:
            print "You can only carry", MAXCARRY, "objects."
            print "Type << INVENTORY >> to see what you can drop."

    elif verb == 'DROP':
        
        if allnouns[noun][WHERE] != 'HANDS':
            print "You cannot DROP what you do not have."
        
        else:
            allnouns[noun][WHERE] = currentroom
            carried -= 1

        if allnouns['CAKE'][WHERE] == 'PARTY':
            winner = True
            print "Y o u   w o n !  Congratulations."

    elif verb == 'EAT':
        
        if noun == 'CAKE':
            print "You are supposed to deliver the CAKE -- not EAT it."
        
        else:
            defaultresponse()
    
    elif verb == 'CLOSE':
        if noun == 'DOOR':
            print "The DOOR automatically CLOSEs and relocks itself."
        
        elif noun.startswith('UMBRELLA'):
            if noun == 'UMBRELLACLOSED' and allnouns['UMBRELLACLOSED'][WHERE] != None:
                print "The UMBRELLA is still CLOSED."
                
            elif noun == 'UMBRELLAOPEN' and  allnouns['UMBRELLAOPEN'][WHERE] == currentroom:
                allnouns['UMBRELLAOPEN'][WHERE] = None
                allnouns['UMBRELLACLOSED'][WHERE] = currentroom
                print "Ok; done."
                
            elif noun == 'UMBRELLAOPEN' and  allnouns['UMBRELLAOPEN'][WHERE] == 'HANDS':
                allnouns['UMBRELLAOPEN'][WHERE] = None
                allnouns['UMBRELLACLOSED'][WHERE] = 'HANDS'
                print "Ok; done."
            
            else:
                print "You cannot close it unless you are in the same room as it is."
        
        else:
            defaultresponse()
    
    elif verb == 'CONSULT':
        
        if allnouns[noun][WHERE] != 'HANDS':
            print "You don't have the", noun, "in your hands."
        
        elif noun == 'WRAPPER':
            print "The WRAPPER does not have anything important written on it. Nice try."
        
        elif noun == 'GLOBE':
            print "The GLOBE just softly glows and glows."
        
        elif noun == 'MAP':
            print map
            
        else:
            defaultresponse()

    elif verb == 'UNLOCK':
        if noun == 'DOOR':
            
            if currentroom != 'PANTRY' and currentroom != 'STAGE':
                print "There is no door here to be unlocked."
            
            else:
                if allnouns['KEY'][WHERE] != 'HANDS':
                    print"You need to be holding the KEY in order to UNLOCK the door."
                
                else:
                    print "You UNLOCKed the door, passed through it, and it shut behind you."
                    if currentroom == 'PANTRY':
                        currentroom = 'STAGE'
                    else:
                        currentroom = 'PANTRY'
        else:
            defaultresponse()
            
    elif verb == 'OPEN':
        
        if noun == 'DOOR':
            print "You should UNLOCK the locked door instead."
        
        elif noun.startswith('UMBRELLA'):
            if noun == 'UMBRELLAOPEN' and allnouns['UMBRELLAOPEN'][WHERE] != None:
                print "The UMBRELLA is still OPEN."
                
            elif noun == 'UMBRELLACLOSED':
                
                if allnouns['UMBRELLACLOSED'][WHERE] == currentroom:
                    allnouns['UMBRELLACLOSED'][WHERE] = None
                    allnouns['UMBRELLAOPEN'][WHERE] = currentroom
                
                elif allnouns['UMBRELLACLOSED'][WHERE] == 'HANDS':
                    allnouns['UMBRELLACLOSED'][WHERE] = None
                    allnouns['UMBRELLAOPEN'][WHERE] = 'HANDS'

                print "Ok; done."
            
            else:
                print "You cannot close it unless you are in the same room as it is."

    elif verb == 'INVENTORY':
        
        if carried == 0:
            print "Your hands are empty."
        elif carried == 1:
            print "One hand is empty and the other has the "
        elif carried == 2:
            print "Both hands have something; here's what you have:"
        
        for thisnoun in allnouns.keys():
            if allnouns[thisnoun][WHERE] == 'HANDS':
                print "   ", thisnoun
