/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.ImageIcon;

public class Duck
extends Sprite {
    private ImageIcon[] sitting_image;
    private ImageIcon[] flying_image;
    private final int flying_frames = 8;
    private float yardage;
    private boolean interception;
    private float radians;
    private float radial_increment;
    private float y_boost;
    private int punt_length;
    private int flyingX;
    private int target_yardage;
    private int num_frames_for_intercepter_to_run_before_grabbing_duck;
    private int step_val;
    private float yardage_step_val;
    private int num_frames_to_fly_before_intercepter_appears;

    public Duck(int n) {
        this.x = 900;
        this.y = -5;
        this.flyingX = this.x;
        this.step_val = n;
        this.yardage_step_val = (float)this.step_val / 100.0f;
        this.interception = false;
        this.radians = 0.0f;
        this.sitting_image = new ImageIcon[2];
        this.sitting_image[0] = new ImageIcon("data/images/right_duck.gif");
        this.sitting_image[1] = new ImageIcon("data/images/left_duck.gif");
        this.flying_image = new ImageIcon[8];
        int n2 = 0;
        while (n2 < 8) {
            this.flying_image[n2] = new ImageIcon("data/images/flying_" + String.valueOf(n2) + ".gif");
            ++n2;
        }
        Math.random();
    }

    public void setYardage(int n) {
        this.yardage = n;
    }

    public int getYardage() {
        return (int)this.yardage;
    }

    public float getRealYardage() {
        return this.yardage;
    }

    public int getX() {
        return this.flyingX;
    }

    public int getPuntLength() {
        return this.punt_length;
    }

    public boolean isAlmostReadyToIntercept() {
        return this.interception && --this.num_frames_to_fly_before_intercepter_appears == 0;
    }

    public boolean isReadyToIntercept() {
        return --this.num_frames_for_intercepter_to_run_before_grabbing_duck == 0;
    }

    public boolean willBeIntercepted() {
        return this.interception;
    }

    public void moveRelativeToPlayer() {
        this.x -= this.step_val;
        this.flyingX = this.x;
    }

    public void setupPunt(int n, int n2, int n3, int n4) {
        float f = 30.0f;
        float f2 = Math.abs(f + (float)((n - n2 / 2) * (n - n2 / 2)) / (-4.0f * f));
        float f3 = (float)Math.random();
        float f4 = (float)Math.random();
        this.num_frames_for_intercepter_to_run_before_grabbing_duck = 0;
        float f5 = 0.0f;
        this.interception = false;
        if (n3 > 0) {
            this.punt_length = n3;
        } else {
            this.punt_length = 2 + (int)(f2 * f3);
            if ((double)f4 > 0.7 && (double)this.yardage > 30.0 && (double)this.punt_length > 10.0) {
                this.interception = true;
            }
        }
        this.target_yardage = Math.max(0, this.getYardage() - this.punt_length);
        this.y_boost = 100.0f + (float)(n2 - n) * (float)(0.5 + Math.random());
        if (this.interception) {
            this.num_frames_for_intercepter_to_run_before_grabbing_duck = (n4 - this.x) / this.step_val;
            float f6 = 60.0f;
            float f7 = f6 / this.y_boost;
            f5 = (float)(Math.PI - Math.asin(f7));
        }
        this.radians = 0.0f;
        this.radial_increment = (float)(Math.PI / (double)this.punt_length / (100.0 / (double)this.step_val));
        if (this.interception) {
            int n5 = (int)(f5 / this.radial_increment);
            this.num_frames_to_fly_before_intercepter_appears = n5 - this.num_frames_for_intercepter_to_run_before_grabbing_duck;
            if (this.num_frames_to_fly_before_intercepter_appears < 1) {
                this.interception = false;
            }
        }
    }

    public boolean animate() {
        this.radians += this.radial_increment;
        this.y = (int)(Math.sin(this.radians) * (double)this.y_boost);
        this.flyingX -= this.step_val;
        this.yardage -= this.yardage_step_val;
        if (this.frameMod++ % 4 == 0) {
            this.current_image = this.flying_image[(int)(Math.random() * 8.0)];
        }
        return this.getYardage() > this.target_yardage;
    }

    public void returnToHomePosition(int n, int n2) {
        this.x = 100 + n2 / 2 + (int)(Math.random() * 400.0);
        this.y = -5;
        this.flyingX = this.x;
        this.frameMod = 0;
        this.interception = false;
        this.current_image = this.sitting_image[n];
    }

    public void padForBeginners(int n) {
        this.x += n;
        this.flyingX = this.x;
    }

    public static void say(String string) {
        System.out.println(string);
    }
}

