/******************************************
DUCK PUNT
Copyright (C) 2005 Geoffrey M. Draper

This file is part of Duck Punt.
Duck Punt is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************/

import javax.swing.*;
import java.applet.*;
import java.net.*;

public class Player extends Sprite
{
	private int score;
	private ImageIcon running_sequence[];
	private ImageIcon standing_image;
	private ImageIcon kicking_image;
	private ImageIcon intercepting_sequence[];
	private ImageIcon fall_back;
	private ImageIcon fall_front;
	private String team_name;
	private int current_status;
	private int running_frame;
	private AudioClip fight_song;

	public static final int STANDING = 0;
	public static final int RUNNING = 1;
	public static final int DUCK_FLYING = 2;
	public static final int DUCK_LANDED = 3;
	public static final int TOUCHDOWN = 4;
	public static final int SPRING_FORWARD = 5;
	public static final int FALL_BACK = 6;
	public static final int RUNNING_IN_PLACE = 7;
	public static final int BEFORE_INTERCEPTION = 8;
	public static final int AFTER_INTERCEPTION = 9;

	public Player(int playernum, String name)
	{
		final int num_frames = 4;
		score=0;
		team_name = name;
		current_status = STANDING;
		running_frame = 0;
		running_sequence = new ImageIcon[num_frames];
		intercepting_sequence = new ImageIcon[num_frames];
		
		//load graphics
		standing_image = new ImageIcon("data/images/standing" + String.valueOf(playernum) + ".gif");
		for (int i=0; i<num_frames; i++)
		{
			running_sequence[i] = new ImageIcon("data/images/running" + String.valueOf(playernum)
									+ "_" + String.valueOf(i) + ".gif");
			intercepting_sequence[i] = new ImageIcon("data/images/interception" + String.valueOf(playernum)
									+ "_" + String.valueOf(i) + ".gif");
		}
		kicking_image = new ImageIcon("data/images/kicking" + String.valueOf(playernum) + ".gif");
		fall_front = new ImageIcon("data/images/fall_front" + String.valueOf(playernum) + ".gif");
		fall_back = new ImageIcon("data/images/fall_back" + String.valueOf(playernum) + ".gif");
		current_image = standing_image;		
		
		//load fight songs
		try {
			URL url = new URL("file:" + System.getProperty("user.dir") + "/data/audio/fight_song" + String.valueOf(playernum) + ".wav");
			fight_song = Applet.newAudioClip(url);
		} catch (MalformedURLException e) {
			System.err.println(e.getMessage());
		}

	}

	public void setDefaults(int mode, int screen_width)
	{
		score=0;
		returnToHomePosition(mode, screen_width);
	}

	public void returnToHomePosition(int mode, int screen_width)
	{
		frameMod = 0;
		if (mode == DuckPunt.MATH_MODE) {
			current_status = RUNNING_IN_PLACE;
		} else {
			current_status = STANDING;
		}
		current_image = standing_image;
		running_frame = 0;
		x=(int)(screen_width/2.0);
		y=-3;
	}
	
	public void prepareToIntercept(int screen_width)
	{
		frameMod = 0;
		running_frame = 0;
		current_image = running_sequence[running_frame];
		x=screen_width;
		y=-3;
	}

	public void advanceFrame(boolean interception_mode)
	{
		if (frameMod++ % 3 == 0)
		{
			current_image = running_sequence[running_frame % 4];
			running_frame++;
		}
		if (interception_mode)
		{
			x-=25;
		}
	}

	public void advanceFrame_carryingDuck()
	{
		if (frameMod++ % 3 == 0)
		{
			current_image = intercepting_sequence[running_frame % 4];
			running_frame++;
		}
		x-=25;
	}

	public int getScore()
	{
		return score;
	}

	public void incrementScore(int change)
	{
		score += change;
	}

	public String getName()
	{
		return team_name;
	}

	public void setStatus(int status)
	{
		current_status = status;
	}

	public int getStatus()
	{
		return current_status;
	}

	public void kick()
	{
		current_image = kicking_image;
	}

	public void spring_forward()
	{
		current_status = Player.SPRING_FORWARD;
		current_image = fall_front;
		x += 100;
		y = -10;
	}

	public void fall_back()
	{
		current_status = Player.FALL_BACK;
		current_image = fall_back;
		y = -10;
	}

	public void fadeAway(int x_decrement)
	{
		x -= x_decrement;
	}
	
	public void playSong()
	{
		if (SoundEffects.enabled()) {
			fight_song.loop();
		}
	}
	
	public void stopSong()
	{
		fight_song.stop();
	}

}
