/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import sun.plugin.security.CertificateStore;
import sun.plugin.security.DeniedCertificateStore;
import sun.plugin.security.HttpsRootCACertStore;
import sun.plugin.security.PluginHttpsCertStore;
import sun.plugin.security.RootCACertificateStore;
import sun.plugin.security.SessionCertificateStore;
import sun.plugin.security.TrustDeciderDialog;
import sun.plugin.util.PluginSysAction;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.Trace;

public final class X509PluginTrustManager
implements X509TrustManager {
    private X509TrustManager trustManager = null;
    private static CertificateStore rootStore;
    private static CertificateStore httpsRootStore;
    private static CertificateStore permanentStore;
    private static CertificateStore sessionStore;
    private static CertificateStore deniedStore;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !X509PluginTrustManager.class.desiredAssertionStatus();
        rootStore = null;
        httpsRootStore = null;
        permanentStore = null;
        sessionStore = null;
        deniedStore = null;
        X509PluginTrustManager.reset();
    }

    public X509PluginTrustManager() throws KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, CertificateException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.trustManager = (X509TrustManager)trustManagerArray[0];
    }

    public static void reset() {
        rootStore = RootCACertificateStore.getInstance();
        httpsRootStore = new HttpsRootCACertStore();
        permanentStore = new PluginHttpsCertStore();
        sessionStore = new SessionCertificateStore();
        deniedStore = new DeniedCertificateStore();
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    public synchronized void checkClientTrusted(final X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        if (!$assertionsDisabled && this.trustManager == null) {
            throw new AssertionError();
        }
        int n = 1;
        try {
            rootStore.load();
            httpsRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkClientTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!rootStore.verify(x509CertificateArray[i]) && !httpsRootStore.verify(x509CertificateArray[i])) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    try {
                        final boolean bl3 = bl;
                        final boolean bl4 = bl2;
                        n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return PluginSysUtil.execute(new PluginSysAction(this){
                                    private final /* synthetic */ 1 this$1;

                                    public Object execute() throws Exception {
                                        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(1.access$000(this.this$1), 0, 1.access$000(this.this$1).length, 1.access$100(this.this$1), 1.access$200(this.this$1));
                                        trustDeciderDialog.setHttpsDialog(true);
                                        return new Integer(trustDeciderDialog.DoModal());
                                    }
                                    {
                                        this.this$1 = var1_1;
                                    }
                                });
                            }

                            static /* synthetic */ boolean access$100(1 var0) {
                                return var0.bl3;
                            }

                            static /* synthetic */ boolean access$200(1 var0) {
                                return var0.bl4;
                            }

                            static /* synthetic */ X509Certificate[] access$000(1 var0) {
                                return var0.x509CertificateArray;
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreclientcert");
                    n = 0;
                }
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Plugin couldn't trust Client");
        }
    }

    public synchronized void checkServerTrusted(final X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        boolean bl = false;
        boolean bl2 = false;
        if (!$assertionsDisabled && this.trustManager == null) {
            throw new AssertionError();
        }
        int n = 1;
        try {
            rootStore.load();
            httpsRootStore.load();
            permanentStore.load();
            sessionStore.load();
            deniedStore.load();
            if (deniedStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("Certificate has been denied");
            }
            try {
                this.trustManager.checkServerTrusted(x509CertificateArray, string);
                return;
            }
            catch (CertificateException certificateException) {
                if (sessionStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (permanentStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    if (!rootStore.verify(x509CertificateArray[i]) && !httpsRootStore.verify(x509CertificateArray[i])) {
                        bl = true;
                    }
                    try {
                        x509CertificateArray[i].checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl2 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl2 = true;
                    }
                }
                if (!Trace.isAutomationEnabled()) {
                    try {
                        final boolean bl3 = bl;
                        final boolean bl4 = bl2;
                        n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return PluginSysUtil.execute(new PluginSysAction(this){
                                    private final /* synthetic */ 3 this$1;

                                    public Object execute() throws Exception {
                                        TrustDeciderDialog trustDeciderDialog = new TrustDeciderDialog(3.access$300(this.this$1), 0, 3.access$300(this.this$1).length, 3.access$400(this.this$1), 3.access$500(this.this$1));
                                        trustDeciderDialog.setHttpsDialog(true);
                                        return new Integer(trustDeciderDialog.DoModal());
                                    }
                                    {
                                        this.this$1 = var1_1;
                                    }
                                });
                            }

                            static /* synthetic */ boolean access$400(3 var0) {
                                return var0.bl3;
                            }

                            static /* synthetic */ boolean access$500(3 var0) {
                                return var0.bl4;
                            }

                            static /* synthetic */ X509Certificate[] access$300(3 var0) {
                                return var0.x509CertificateArray;
                            }
                        });
                    }
                    catch (Exception exception) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                } else {
                    Trace.msgSecurityPrintln("x509trustmgr.automation.ignoreservercert");
                    n = 0;
                }
                if (n == 0) {
                    sessionStore.add(x509CertificateArray[0]);
                    sessionStore.save();
                } else if (n == 2) {
                    permanentStore.add(x509CertificateArray[0]);
                    permanentStore.save();
                } else {
                    deniedStore.add(x509CertificateArray[0]);
                    deniedStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (n != 0 && n != 2) {
            throw new CertificateException("Plugin couldn't trust Server");
        }
    }
}

