/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.UIManager;

public class DuckPunt
extends JPanel
implements MouseListener,
KeyListener {
    Timer timer;
    Player[] player;
    Duck duck;
    int clock;
    private int step_val;
    int yardage_when_kicked = 0;
    Color bluePlayerColor = new Color(62, 101, 178);
    Color redPlayerColor = new Color(198, 5, 60);
    static final int delay = 100;
    static final int GAME_LENGTH = 60;
    public int current_player;
    public int window_width;
    public int window_height;
    public int game_mode;
    public MathProblem math;
    private long timestampOfLastKeyPress;
    private static final long KEY_REPEAT_THRESHOLD = 10L;
    public final int grass_depth = 75;
    public static final int pixelsToYard = 100;
    public static final int MATH_MODE = 0;
    public static final int SIMPLE_MODE = 1;

    public DuckPunt() {
        SplashScreen splashScreen = new SplashScreen();
        this.math = new MathProblem();
        this.timer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DuckPunt.this.duck.getX() - DuckPunt.this.player[DuckPunt.this.current_player].getX();
                switch (DuckPunt.this.player[DuckPunt.this.current_player].getStatus()) {
                    case 1: {
                        DuckPunt.this.duck.moveRelativeToPlayer();
                        DuckPunt.this.player[DuckPunt.this.current_player].advanceFrame(DuckPunt.this.duck.willBeIntercepted());
                        if (DuckPunt.this.game_mode == 0) {
                            if (DuckPunt.this.math.getRelativeAnswer() < 0 && n < 300) {
                                DuckPunt.this.player[DuckPunt.this.current_player].kick();
                                DuckPunt.this.makePlayerFallOnBack();
                                break;
                            }
                            if (DuckPunt.this.math.getRelativeAnswer() == 0 && n < 100) {
                                DuckPunt.this.player[DuckPunt.this.current_player].kick();
                                DuckPunt.this.setupPunt(n, 200);
                            }
                        }
                        if (n >= -50 || DuckPunt.this.game_mode != 1 && (DuckPunt.this.game_mode != 0 || DuckPunt.this.math.getRelativeAnswer() <= 0)) break;
                        SoundEffects.play(SoundEffects.FALL_SOUND);
                        DuckPunt.this.player[DuckPunt.this.current_player].spring_forward();
                        break;
                    }
                    case 7: {
                        DuckPunt.this.player[DuckPunt.this.current_player].advanceFrame(DuckPunt.this.duck.willBeIntercepted());
                        break;
                    }
                    case 9: {
                        DuckPunt.this.player[(DuckPunt.this.current_player + 1) % 2].advanceFrame_carryingDuck();
                        if (DuckPunt.this.player[(DuckPunt.this.current_player + 1) % 2].getX() >= -100) break;
                        DuckPunt.this.duck.setYardage(100 - DuckPunt.this.duck.getYardage());
                        DuckPunt.this.switchPlayers();
                        DuckPunt.this.returnToHomePosition();
                        DuckPunt.this.decrementClockAndRepaint();
                        break;
                    }
                    case 8: {
                        DuckPunt.this.player[(DuckPunt.this.current_player + 1) % 2].advanceFrame(true);
                        if (DuckPunt.this.duck.isReadyToIntercept()) {
                            SoundEffects.play(SoundEffects.WHISTLE_SOUND);
                            DuckPunt.this.player[DuckPunt.this.current_player].setStatus(9);
                            break;
                        }
                    }
                    case 2: {
                        DuckPunt.this.player[DuckPunt.this.current_player].fadeAway(DuckPunt.this.step_val);
                        if (DuckPunt.this.duck.isAlmostReadyToIntercept()) {
                            SoundEffects.play(SoundEffects.CHEER_SOUND);
                            DuckPunt.this.player[DuckPunt.this.current_player].setStatus(8);
                        }
                        if (DuckPunt.this.duck.animate()) break;
                        DuckPunt.this.player[DuckPunt.this.current_player].setStatus(3);
                        DuckPunt.this.timer.stop();
                    }
                }
                DuckPunt.this.repaint();
            }
        });
        this.timer.setInitialDelay(0);
        this.timer.setCoalesce(true);
        this.addMouseListener(this);
        this.initializeVariables(splashScreen);
    }

    private void initializeVariables(SplashScreen splashScreen) {
        this.window_width = 799;
        this.window_height = 500;
        Dimension dimension = new Dimension(this.window_width, this.window_height);
        this.setPreferredSize(dimension);
        this.timestampOfLastKeyPress = 0L;
        this.step_val = 25;
        this.player = new Player[2];
        this.player[0] = new Player(0, "ROJO");
        this.player[1] = new Player(1, "AZUL");
        this.duck = new Duck(this.step_val);
        SoundEffects.init();
        splashScreen.closeAfterAppropriateTimeout(3000L);
        this.setDefaults(0);
        this.duck.padForBeginners(500);
    }

    private void setDefaults(int n) {
        this.game_mode = 1;
        this.timer.setDelay(100);
        this.duck.setYardage(90);
        this.clock = 60;
        this.current_player = n;
        Object[] objectArray = new Object[]{"Math Mode", "Regular Mode"};
        int n2 = JOptionPane.showOptionDialog(this, "You can choose either \"Math Mode\" or \"Regular Mode\"", "Welcome to DUCK PUNT", 0, -1, null, objectArray, objectArray[1]);
        if (n2 == 0) {
            this.game_mode = 0;
            this.timer.start();
        }
        this.player[0].setDefaults(this.game_mode, this.window_width);
        this.player[1].setDefaults(this.game_mode, this.window_width);
        this.duck.returnToHomePosition(this.current_player, this.window_width);
        this.player[this.current_player].playSong();
    }

    public void paintComponent(Graphics graphics) {
        this.window_width = this.getWidth();
        this.window_height = this.getHeight();
        graphics.setColor(new Color(185, 220, 247));
        graphics.fillRect(0, 0, this.window_width, this.window_height - 75);
        graphics.setColor(new Color(10, 162, 114));
        graphics.fillRect(0, this.window_height - 75, this.window_width, this.window_height);
        this.displayGridYardage(graphics, this.window_height - 75);
        graphics.setFont(new Font("SansSerif", 1, 20));
        graphics.setColor(Color.black);
        String string = "TIME: " + String.valueOf(this.clock);
        graphics.drawString(string, (this.window_width - graphics.getFontMetrics().stringWidth(string)) / 2, 20);
        graphics.setFont(new Font("SansSerif", 1, 15));
        graphics.setColor(Color.black);
        string = "YARDS TO GOAL: " + String.valueOf(this.duck.getYardage());
        graphics.drawString(string, (this.window_width - graphics.getFontMetrics().stringWidth(string)) / 2, 40);
        if (this.clock > 0) {
            this.player[this.current_player].drawMe(this, graphics);
            if (this.player[this.current_player].getStatus() != 9) {
                this.duck.drawMe(this, graphics);
            }
            if (this.player[this.current_player].getStatus() == 8 || this.player[this.current_player].getStatus() == 9) {
                this.player[(this.current_player + 1) % 2].drawMe(this, graphics);
            }
            this.displayTextMessage(graphics);
        }
        graphics.setFont(new Font("SansSerif", 1, 30));
        graphics.setColor(this.redPlayerColor);
        string = this.player[0].getName() + ": " + String.valueOf(this.player[0].getScore());
        graphics.drawString(string, 10, 30);
        graphics.setColor(this.bluePlayerColor);
        string = this.player[1].getName() + ": " + String.valueOf(this.player[1].getScore());
        graphics.drawString(string, this.window_width - 10 - graphics.getFontMetrics().stringWidth(string), 30);
    }

    private void displayTextMessage(Graphics graphics) {
        String string = "";
        String string2 = "";
        String string3 = "SansSerif";
        if (this.game_mode == 0) {
            string3 = "Monospaced";
        }
        Font font = new Font(string3, 1, 30);
        Font font2 = new Font(string3, 0, 15);
        if (this.current_player == 0) {
            graphics.setColor(this.redPlayerColor);
        } else {
            graphics.setColor(this.bluePlayerColor);
        }
        switch (this.player[this.current_player].getStatus()) {
            case 0: {
                if (this.game_mode != 1) break;
                string = "CLICK TO RUN";
                string2 = "CLICK TO PUNT";
                break;
            }
            case 1: 
            case 7: {
                if (this.game_mode == 0) {
                    string = this.math.getProblemText();
                    break;
                }
                string = "CLICK TO RUN";
                string2 = "CLICK TO PUNT";
                Font font3 = font;
                font = font2;
                font2 = font3;
                break;
            }
            case 3: {
                if (this.duck.getYardage() <= 0) {
                    string = "TOUCHDOWN!";
                    this.player[this.current_player].incrementScore(6);
                    this.player[this.current_player].setStatus(4);
                    SoundEffects.play(SoundEffects.CHEER_SOUND);
                } else {
                    string = String.valueOf(this.duck.getPuntLength()) + " YARD PUNT!";
                }
                string2 = "CLICK TO CONTINUE";
                break;
            }
            case 5: 
            case 6: {
                string = this.game_mode == 0 ? "Sorry, the correct answer is:" : "WHOOPS!";
                this.timer.stop();
                string2 = "CLICK TO CONTINUE";
                break;
            }
            case 8: 
            case 9: {
                string = "INTERCEPTION!";
                break;
            }
            default: {
                string = "";
                string2 = "";
            }
        }
        graphics.setFont(font);
        int n = (this.window_width - graphics.getFontMetrics().stringWidth(string)) / 2;
        int n2 = this.window_height / 3;
        graphics.drawString(string, n, n2);
        if (this.game_mode == 0) {
            switch (this.player[this.current_player].getStatus()) {
                case 1: 
                case 7: {
                    n = (this.window_width + graphics.getFontMetrics().stringWidth(string)) / 2;
                    graphics.setColor(Color.white);
                    string = this.math.getUserResponseText();
                    graphics.drawString(string, n, n2);
                    break;
                }
                case 5: 
                case 6: {
                    string = this.math.getCompleteSolution();
                    n = (this.window_width - graphics.getFontMetrics().stringWidth(string)) / 2;
                    n2 = (int)((double)n2 + (double)graphics.getFontMetrics().getHeight() / 1.5);
                    graphics.drawString(string, n, n2);
                }
            }
        }
        double d = graphics.getFontMetrics().getHeight();
        double d2 = font.getSize() == 30 ? 2.0 : 0.66;
        graphics.setFont(font2);
        n = (this.window_width - graphics.getFontMetrics().stringWidth(string2)) / 2;
        graphics.drawString(string2, n, n2 += (int)(d / d2));
    }

    private void displayGridYardage(Graphics graphics, int n) {
        graphics.setColor(Color.white);
        graphics.setFont(new Font("SansSerif", 1, 30));
        int n2 = this.player[this.current_player].getStatus() == 2 || this.player[this.current_player].getStatus() == 9 || this.player[this.current_player].getStatus() == 8 || this.player[this.current_player].getStatus() == 3 ? (this.current_player == 0 ? 100 - this.yardage_when_kicked : this.yardage_when_kicked) : (this.current_player == 0 ? 100 - this.duck.getYardage() : this.duck.getYardage());
        int n3 = this.current_player == 0 ? this.duck.getX() - n2 * 100 : this.window_width - this.duck.getX() - n2 * 100;
        int n4 = 0;
        while (n4 <= 100) {
            int n5 = n4 < 50 ? n4 : 100 - n4;
            if (n5 % 5 == 0) {
                graphics.fillRect(n3 - 4, n, 8, 12);
            }
            if (n5 % 10 == 0) {
                String string = String.valueOf(n5);
                graphics.drawString(string, n3 - graphics.getFontMetrics().stringWidth(string) / 2, n + 40);
            }
            n3 += 100;
            ++n4;
        }
    }

    public void makePlayerFallOnBack() {
        SoundEffects.play(SoundEffects.SLIP_SOUND);
        this.update(this.getGraphics());
        DuckPunt.pause(1500L);
        SoundEffects.play(SoundEffects.FALL_SOUND);
        this.timer.stop();
        this.player[this.current_player].fall_back();
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.clock > 0) {
            switch (this.player[this.current_player].getStatus()) {
                case 0: {
                    this.player[this.current_player].setStatus(1);
                    this.timer.setDelay(100);
                    this.timer.start();
                    break;
                }
                case 1: {
                    if (this.game_mode != 1) break;
                    this.player[this.current_player].kick();
                    int n = this.duck.getX() - this.player[this.current_player].getX() + 50;
                    if (n > 200) {
                        this.makePlayerFallOnBack();
                        break;
                    }
                    this.setupPunt(n, 200);
                    break;
                }
                case 4: {
                    this.switchPlayers();
                    this.duck.setYardage(90);
                }
                case 3: {
                    this.returnToHomePosition();
                    this.decrementClockAndRepaint();
                    break;
                }
                case 5: 
                case 6: {
                    this.duck.setYardage(100 - this.duck.getYardage());
                    this.switchPlayers();
                    this.returnToHomePosition();
                    this.decrementClockAndRepaint();
                    break;
                }
            }
        }
    }

    public void switchPlayers() {
        this.player[this.current_player].stopSong();
        this.current_player = (this.current_player + 1) % 2;
        this.player[this.current_player].playSong();
    }

    public void decrementClockAndRepaint() {
        --this.clock;
        this.repaint();
        this.checkForEndGame();
    }

    public void returnToHomePosition() {
        this.player[this.current_player].returnToHomePosition(this.game_mode, this.window_width);
        this.duck.returnToHomePosition(this.current_player, this.window_width);
        if (this.game_mode == 0) {
            this.math.makeNewProblem();
            this.timer.setDelay(100);
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    public void setupPunt(int n, int n2) {
        SoundEffects.play(SoundEffects.KICK_SOUND);
        this.update(this.getGraphics());
        this.player[this.current_player].setStatus(2);
        if (this.game_mode == 0) {
            this.duck.setupPunt(n, n2, this.math.getAnswer(), this.window_width);
        } else {
            this.duck.setupPunt(n, n2, -1, this.window_width);
            if (this.duck.willBeIntercepted()) {
                this.player[(this.current_player + 1) % 2].prepareToIntercept(this.window_width);
            }
        }
        this.yardage_when_kicked = this.duck.getYardage();
        this.timer.setDelay(50);
    }

    public void checkForEndGame() {
        if (this.clock <= 0) {
            int n;
            int n2 = 1;
            this.player[this.current_player].stopSong();
            SoundEffects.play(SoundEffects.CHEER_SOUND);
            this.timer.stop();
            String string = "IT'S A DRAW!";
            if (this.player[0].getScore() > this.player[1].getScore()) {
                string = this.player[0].getName() + " WINS!!";
            }
            if (this.player[1].getScore() > this.player[0].getScore()) {
                string = this.player[1].getName() + " WINS!!";
                n2 = 0;
            }
            if ((n = JOptionPane.showOptionDialog(this, string = string + "  PLAY AGAIN?", "GAME OVER", 0, -1, null, null, null)) == 0) {
                this.setDefaults(n2);
                this.repaint();
            } else {
                System.exit(0);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        long l = System.currentTimeMillis();
        long l2 = l - this.timestampOfLastKeyPress;
        this.timestampOfLastKeyPress = l;
        if (l2 < 50L) {
            return;
        }
        if (keyEvent.getKeyCode() == 27) {
            System.exit(0);
        }
        if (keyEvent.getKeyCode() == 113) {
            SoundEffects.toggleSound();
            if (SoundEffects.enabled()) {
                this.player[this.current_player].playSong();
            } else {
                this.player[this.current_player].stopSong();
            }
            return;
        }
        if (this.clock > 0) {
            block0 : switch (this.game_mode) {
                case 1: {
                    this.mousePressed(new MouseEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), 0, 0, 0, false));
                    break;
                }
                case 0: {
                    switch (this.player[this.current_player].getStatus()) {
                        case 7: {
                            boolean bl = this.math.handleKeyStrokes(keyEvent);
                            if (!bl) break block0;
                            this.player[this.current_player].setStatus(1);
                            break;
                        }
                        default: {
                            this.mousePressed(new MouseEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), 0, 0, 0, false));
                            break;
                        }
                    }
                    break;
                }
                default: {
                    System.out.println("keyPressed event received; unknown game_mode.");
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void pause(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("pause(): exception caught");
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("DUCK PUNT");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ImageIcon imageIcon = new ImageIcon("data/images/duck_small_icon.gif");
        ((Frame)jFrame).setIconImage(imageIcon.getImage());
        DuckPunt duckPunt = new DuckPunt();
        jFrame.getContentPane().add((Component)duckPunt, "Center");
        jFrame.addKeyListener(duckPunt);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }
}

