/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyEvent;

public class MathProblem {
    private String problem;
    private int answer;
    private String charTyped1;
    private String charTyped2;
    private int relative_answer;

    public MathProblem() {
        this.makeNewProblem();
    }

    public String getProblemText() {
        return this.problem;
    }

    public String getCompleteSolution() {
        return this.problem + String.valueOf(this.answer);
    }

    public int getAnswer() {
        return this.answer;
    }

    public void makeNewProblem() {
        String string = "+";
        int n = 1 + (int)(Math.random() * 15.0);
        int n2 = (int)(Math.random() * 15.0);
        this.answer = n + n2;
        this.charTyped1 = "?";
        this.charTyped2 = this.getNumDigits() == 2 ? "?" : " ";
        this.problem = String.valueOf(n) + " " + string + " " + String.valueOf(n2) + " = ";
    }

    public String getUserResponseText() {
        String string = this.charTyped1 + this.charTyped2;
        return string;
    }

    public boolean handleKeyStrokes(KeyEvent keyEvent) {
        boolean bl = false;
        char c = keyEvent.getKeyChar();
        if (Character.isDigit(c)) {
            if (this.charTyped1 == "?") {
                this.charTyped1 = new Character(c).toString();
                if (this.getNumDigits() == 1) {
                    bl = true;
                }
            } else {
                this.charTyped2 = new Character(c).toString();
                bl = true;
            }
        }
        if (bl) {
            this.evaluateResponse();
        }
        return bl;
    }

    public int getNumDigits() {
        if (this.answer < 10) {
            return 1;
        }
        return 2;
    }

    private void evaluateResponse() {
        int n = 0;
        String string = this.charTyped1;
        if (this.getNumDigits() == 2) {
            string = string + this.charTyped2;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("invalid user input");
        }
        this.relative_answer = n - this.answer;
    }

    public int getRelativeAnswer() {
        return this.relative_answer;
    }
}

