/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.CosNaming;

import com.sun.corba.se.internal.orbutil.CorbaResourceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

final class BootstrapServiceProperties {
    private File propFile;
    private long fileModified;
    private Properties savedProps;
    private Properties allProps;

    protected void check() {
        if (this.propFile == null) {
            return;
        }
        long l2 = this.propFile.lastModified();
        if (l2 > this.fileModified) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.propFile);
                this.savedProps.clear();
                this.savedProps.load(fileInputStream);
                fileInputStream.close();
                this.fileModified = l2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.filenotfound", this.propFile.getAbsolutePath()));
            }
            catch (IOException iOException) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.exception", this.propFile.getAbsolutePath(), iOException.toString()));
            }
        }
    }

    public synchronized String[] keys() {
        this.check();
        String[] stringArray = null;
        int n2 = this.allProps.size() + this.savedProps.size();
        if (n2 > 0) {
            stringArray = new String[n2];
            Enumeration enumeration = this.allProps.propertyNames();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n3] = (String)enumeration.nextElement();
                ++n3;
            }
        }
        return stringArray;
    }

    public synchronized String get(String string) {
        this.check();
        return this.allProps.getProperty(string);
    }

    public BootstrapServiceProperties(File file, Properties properties) {
        this.propFile = file;
        this.savedProps = properties;
        this.allProps = new Properties(this.savedProps);
    }

    public synchronized String put(String string, String string2, boolean bl2) {
        if (!bl2) {
            return (String)this.allProps.put(string, string2);
        }
        String string3 = (String)this.savedProps.put(string, string2);
        if (this.propFile != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.propFile);
                this.savedProps.save(fileOutputStream, null);
                fileOutputStream.close();
                this.fileModified = this.propFile.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.filenotfound", this.propFile.getAbsolutePath()));
            }
            catch (IOException iOException) {
                System.err.println(CorbaResourceUtil.getText("bootstrap.exception", this.propFile.getAbsolutePath(), iOException.toString()));
            }
        }
        return string3;
    }
}

