/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.BlueprintEngine;
import com.sun.java.swing.plaf.gtk.BlueprintGraphics;
import com.sun.java.swing.plaf.gtk.CircularIdentityList;
import com.sun.java.swing.plaf.gtk.DefaultSynthStyle;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;

class BlueprintStyle
extends GTKStyle
implements GTKConstants {
    private static final GTKEngine BLUEPRINT_ENGINE = new BlueprintEngine();
    private static final BlueprintGraphics BLUEPRINT_GRAPHICS = new BlueprintGraphics();
    private Info[] info;
    private boolean iconColorize;
    private String[] iconAncestorTypes;
    private Color colorizeColor;

    public BlueprintStyle(DefaultSynthStyle defaultSynthStyle) {
        super(defaultSynthStyle);
        if (defaultSynthStyle instanceof BlueprintStyle) {
            BlueprintStyle blueprintStyle = (BlueprintStyle)defaultSynthStyle;
            this.info = blueprintStyle.info;
            this.iconColorize = blueprintStyle.iconColorize;
            this.iconAncestorTypes = blueprintStyle.iconAncestorTypes;
            this.colorizeColor = blueprintStyle.colorizeColor;
        }
    }

    public Object clone() {
        BlueprintStyle blueprintStyle = (BlueprintStyle)super.clone();
        blueprintStyle.info = this.info;
        blueprintStyle.iconAncestorTypes = this.iconAncestorTypes;
        blueprintStyle.colorizeColor = this.colorizeColor;
        return blueprintStyle;
    }

    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (stringBuffer.length() > 0) {
            stringBuffer.append('\n');
        }
        stringBuffer.append("*** Blueprint Engine Info ***\n");
        stringBuffer.append("icon_colorize = " + this.iconColorize + '\n');
        stringBuffer.append("icon_colorize_ancestor_type = ");
        if (this.iconAncestorTypes == null) {
            stringBuffer.append("null\n");
        } else {
            stringBuffer.append('{');
            for (n2 = 0; n2 < this.iconAncestorTypes.length; ++n2) {
                stringBuffer.append(this.iconAncestorTypes[n2] + ", ");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("}\n");
        }
        stringBuffer.append("colorize_color = ");
        stringBuffer.append(BlueprintStyle.getColorStringWithAlpha(this.colorizeColor));
        stringBuffer.append('\n');
        if (this.info != null) {
            for (n2 = 0; n2 < this.info.length; ++n2) {
                stringBuffer.append(this.info[n2].toString()).append('\n');
            }
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private int getMaxMatchCount(int n2, int n3, int n4, int n5, int n6, String string) {
        int n7 = 0;
        if (string != null) {
            ++n7;
        }
        if (n2 != -100) {
            ++n7;
        }
        if (n3 != -100) {
            ++n7;
        }
        if (n4 != -100) {
            ++n7;
        }
        if (n5 != -100) {
            ++n7;
        }
        if (n6 != -100) {
            ++n7;
        }
        return n7;
    }

    public DefaultSynthStyle addTo(DefaultSynthStyle defaultSynthStyle) {
        if (!(defaultSynthStyle instanceof BlueprintStyle)) {
            defaultSynthStyle = new BlueprintStyle(defaultSynthStyle);
        }
        BlueprintStyle blueprintStyle = (BlueprintStyle)super.addTo(defaultSynthStyle);
        if (this.info != null) {
            if (blueprintStyle.info == null) {
                blueprintStyle.info = this.info;
            } else {
                Info[] infoArray = new Info[blueprintStyle.info.length + this.info.length];
                System.arraycopy(this.info, 0, infoArray, 0, this.info.length);
                System.arraycopy(blueprintStyle.info, 0, infoArray, this.info.length, blueprintStyle.info.length);
                blueprintStyle.info = infoArray;
            }
        }
        if (this.iconColorize) {
            blueprintStyle.iconColorize = true;
            blueprintStyle.colorizeColor = this.colorizeColor;
        }
        blueprintStyle.iconAncestorTypes = this.iconAncestorTypes;
        return blueprintStyle;
    }

    public GTKEngine getEngine(SynthContext synthContext) {
        return BLUEPRINT_ENGINE;
    }

    public SynthGraphics getSynthGraphics(SynthContext synthContext) {
        return BLUEPRINT_GRAPHICS;
    }

    private static String getColorStringWithAlpha(Color color) {
        if (color == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(color.getRed()).append(", ");
        stringBuffer.append(color.getGreen()).append(", ");
        stringBuffer.append(color.getBlue()).append(", ");
        stringBuffer.append(color.getAlpha()).append("}");
        return stringBuffer.toString();
    }

    public Info getInfo(String string, String string2, int n2, int n3, int n4, int n5, int n6, String string3) {
        if (this.info != null) {
            int n7 = this.info.length;
            for (int i2 = 0; i2 < n7; ++i2) {
                if (this.info[i2].getFunction() != string || this.info[i2].getMatchCount(string2, n2, n3, n4, n5, n6, string3) == -1) continue;
                return this.info[i2];
            }
        }
        return null;
    }

    public BlueprintStyle(DefaultSynthStyle.StateInfo[] stateInfoArray, CircularIdentityList circularIdentityList, Font font, int n2, int n3, GTKStyle.GTKStockIconInfo[] gTKStockIconInfoArray, Info[] infoArray, boolean bl2, String[] stringArray, Color color) {
        super(stateInfoArray, circularIdentityList, font, n2, n3, gTKStockIconInfoArray);
        this.info = infoArray;
        this.iconColorize = bl2;
        this.iconAncestorTypes = stringArray;
        this.colorizeColor = color;
    }

    public static class Info {
        private String function = null;
        private String detail = null;
        int gapSide = -100;
        int orientation = -100;
        int componentState = -100;
        int shadow = -100;
        int arrowDirection = -100;
        ArrayList parentTypeList = null;
        boolean useAsBkgMask = false;
        Object image = null;
        Insets fileInsets = null;
        boolean stretch = false;
        boolean recolorable = false;
        Color colorizeColor = null;
        Object overlayImage = null;
        Insets overlayInsets = null;
        boolean overlayStretch = false;
        boolean overlayRecolorable = false;
        Color overlayColorizeColor = null;
        Object gapStartImage = null;
        Insets gapStartInsets = null;
        Object gapImage = null;
        Insets gapInsets = null;
        Object gapEndImage = null;
        Insets gapEndInsets = null;

        public int getArrowDirection() {
            return this.arrowDirection;
        }

        public int getComponentState() {
            return this.componentState;
        }

        public int getGapSide() {
            return this.gapSide;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public int getShadow() {
            return this.shadow;
        }

        public boolean getOverlayRecolorable() {
            return this.overlayRecolorable;
        }

        public boolean getOverlayStretch() {
            return this.overlayStretch;
        }

        public boolean getStretch() {
            return this.stretch;
        }

        public boolean isBkgMask() {
            return this.useAsBkgMask;
        }

        public boolean isRecolorable() {
            return this.recolorable;
        }

        boolean matches(Info info) {
            return info.function == this.function && info.detail == this.detail && info.componentState == this.componentState && info.shadow == this.shadow && info.gapSide == this.gapSide && info.arrowDirection == this.arrowDirection && info.orientation == this.orientation;
        }

        public Color getColorizeColor() {
            return this.colorizeColor;
        }

        public Color getOverlayColorizeColor() {
            return this.overlayColorizeColor;
        }

        public Image getGapEndImage() {
            this.gapEndImage = this.getImage(this.gapEndImage);
            return (Image)this.gapEndImage;
        }

        public Image getGapImage() {
            this.gapImage = this.getImage(this.gapImage);
            return (Image)this.gapImage;
        }

        public Image getGapStartImage() {
            this.gapStartImage = this.getImage(this.gapStartImage);
            return (Image)this.gapStartImage;
        }

        public Image getImage() {
            this.image = this.getImage(this.image);
            return (Image)this.image;
        }

        public Image getOverlayImage() {
            this.overlayImage = this.getImage(this.overlayImage);
            return (Image)this.overlayImage;
        }

        public Insets getGapEndInsets() {
            return this.gapEndInsets;
        }

        public Insets getGapInsets() {
            return this.gapInsets;
        }

        public Insets getGapStartInsets() {
            return this.gapStartInsets;
        }

        public Insets getImageInsets() {
            return this.fileInsets;
        }

        public Insets getOverlayInsets() {
            return this.overlayInsets;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("IMAGE:\n");
            if (this.function != null) {
                stringBuffer.append("    function=").append(this.function).append('\n');
            }
            if (this.detail != null) {
                stringBuffer.append("    detail=").append(this.detail).append('\n');
            }
            if (this.gapSide != -100) {
                stringBuffer.append("    gapSide=");
                stringBuffer.append(Info.getSideName(this.gapSide)).append('\n');
            }
            if (this.orientation != -100) {
                stringBuffer.append("    orientation=");
                stringBuffer.append(Info.getOrientName(this.orientation)).append('\n');
            }
            if (this.componentState != -100) {
                stringBuffer.append("    componentState=");
                stringBuffer.append(GTKStyle.getStateName(this.componentState, "UNDEFINED")).append('\n');
            }
            if (this.shadow != -100) {
                stringBuffer.append("    shadow=");
                stringBuffer.append(Info.getShadowName(this.shadow)).append('\n');
            }
            if (this.arrowDirection != -100) {
                stringBuffer.append("    arrowDirection=");
                stringBuffer.append(Info.getArrowDirectionName(this.arrowDirection)).append('\n');
            }
            if (this.parentTypeList != null) {
                stringBuffer.append("    parent_type={");
                Iterator iterator = this.parentTypeList.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next()).append(", ");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1).deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.append("}\n");
            }
            if (this.useAsBkgMask) {
                stringBuffer.append("    use_as_bkg_mask=").append(this.useAsBkgMask).append('\n');
            }
            if (this.image != null) {
                stringBuffer.append("    image=").append(this.image).append('\n');
            }
            if (this.fileInsets != null) {
                stringBuffer.append("    fileInsets=").append(this.fileInsets).append('\n');
            }
            if (this.stretch) {
                stringBuffer.append("    stretch=").append(this.stretch).append('\n');
            }
            if (this.recolorable) {
                stringBuffer.append("    recolorable=").append(this.recolorable).append('\n');
            }
            if (this.colorizeColor != null) {
                stringBuffer.append("    colorize_color=");
                stringBuffer.append(BlueprintStyle.getColorStringWithAlpha(this.colorizeColor)).append('\n');
            }
            if (this.overlayImage != null) {
                stringBuffer.append("    overlayImage=").append(this.overlayImage).append('\n');
            }
            if (this.overlayInsets != null) {
                stringBuffer.append("    overlayInsets=").append(this.overlayInsets).append('\n');
            }
            if (this.overlayStretch) {
                stringBuffer.append("    overlayStretch=").append(this.overlayStretch).append('\n');
            }
            if (this.overlayRecolorable) {
                stringBuffer.append("    overlay_recolorable=").append(this.overlayRecolorable).append('\n');
            }
            if (this.overlayColorizeColor != null) {
                stringBuffer.append("    overlay_colorize_color=");
                stringBuffer.append(BlueprintStyle.getColorStringWithAlpha(this.overlayColorizeColor)).append('\n');
            }
            if (this.gapStartImage != null) {
                stringBuffer.append("    gapStartImage=").append(this.gapStartImage).append('\n');
            }
            if (this.gapStartInsets != null) {
                stringBuffer.append("    gapStartInsets=").append(this.gapStartInsets).append('\n');
            }
            if (this.gapImage != null) {
                stringBuffer.append("    gapImage=").append(this.gapImage).append('\n');
            }
            if (this.gapInsets != null) {
                stringBuffer.append("    gapInsets=").append(this.gapInsets).append('\n');
            }
            if (this.gapEndImage != null) {
                stringBuffer.append("    gapEndImage=").append(this.gapEndImage).append('\n');
            }
            if (this.gapEndInsets != null) {
                stringBuffer.append("    gapEndInsets=").append(this.gapEndInsets).append('\n');
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            return stringBuffer.toString();
        }

        private static String getArrowDirectionName(int n2) {
            switch (n2) {
                case 100: {
                    return "ARROW_UP";
                }
                case 101: {
                    return "ARROW_DOWN";
                }
                case 102: {
                    return "ARROW_LEFT";
                }
                case 103: {
                    return "ARROW_RIGHT";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getOrientName(int n2) {
            switch (n2) {
                case 0: {
                    return "HORIZONTAL";
                }
                case 1: {
                    return "VERTICAL";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getShadowName(int n2) {
            switch (n2) {
                case 0: {
                    return "SHADOW_IN";
                }
                case 1: {
                    return "SHADOW_OUT";
                }
                case 2: {
                    return "SHADOW_ETCHED_IN";
                }
                case 3: {
                    return "SHADOW_ETCHED_OUT";
                }
                case 4: {
                    return "SHADOW_NONE";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        private static String getSideName(int n2) {
            switch (n2) {
                case 2: {
                    return "TOP";
                }
                case 3: {
                    return "BOTTOM";
                }
                case 0: {
                    return "LEFT";
                }
                case 1: {
                    return "RIGHT";
                }
                case -100: {
                    return "UNDEFINED";
                }
            }
            return "UNKNOWN";
        }

        public void setDetail(String string) {
            this.detail = string.intern();
        }

        public void setFunction(String string) {
            this.function = string.intern();
        }

        private Image getImage(Object object) {
            if (object == null || object instanceof Image) {
                return (Image)object;
            }
            ImageIcon imageIcon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(this, object){
                private final /* synthetic */ Object val$o;
                private final /* synthetic */ Info this$0;

                public Object run() {
                    return new ImageIcon((String)this.val$o);
                }
                {
                    this.this$0 = info;
                    this.val$o = object;
                }
            });
            if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                return imageIcon.getImage();
            }
            return null;
        }

        int getMatchCount(String string, int n2, int n3, int n4, int n5, int n6, String string2) {
            int n7 = 0;
            if (this.componentState != -100) {
                if (n2 != -100 && this.componentState != n2) {
                    return -1;
                }
                ++n7;
            }
            if (this.shadow != -100) {
                if (n3 != -100 && this.shadow != n3) {
                    return -1;
                }
                ++n7;
            }
            if (this.arrowDirection != -100) {
                if (n6 != -100 && this.arrowDirection != n6) {
                    return -1;
                }
                ++n7;
            }
            if (this.orientation != -100) {
                if (n4 != -100 && this.orientation != n4) {
                    return -1;
                }
                ++n7;
            }
            if (this.gapSide != -100) {
                if (n5 != -100 && this.gapSide != n5) {
                    return -1;
                }
                ++n7;
            }
            if (this.detail != null) {
                if (this.detail != string) {
                    return -1;
                }
                ++n7;
            }
            if (this.parentTypeList != null) {
                boolean bl2 = false;
                Iterator iterator = this.parentTypeList.iterator();
                while (iterator.hasNext() && !bl2) {
                    String string3 = (String)iterator.next();
                    if (string3 != string2) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    return -1;
                }
                ++n7;
            }
            return n7;
        }
    }
}

