/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.security.action.GetPropertyAction;

class XPStyle {
    private static XPStyle xp;
    private static Boolean themeActive;
    private HashMap map = new HashMap();
    private String styleFile;
    private String themeFile;

    static {
        themeActive = null;
        XPStyle.invalidateStyle();
    }

    private XPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.styleFile = (String)toolkit.getDesktopProperty("win.xpstyle.dllName");
        if (this.styleFile != null) {
            String string = (String)toolkit.getDesktopProperty("win.xpstyle.sizeName");
            String string2 = (String)toolkit.getDesktopProperty("win.xpstyle.colorName");
            if (string != null && string2 != null) {
                String[] stringArray = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "SIZENAMES"));
                String[] stringArray2 = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "COLORNAMES"));
                String[] stringArray3 = this.splitTextResource(XPStyle.getTextResourceByInt(this.styleFile, 1, "FILERESNAMES"));
                if (stringArray != null && stringArray2 != null && stringArray3 != null) {
                    String string3;
                    this.themeFile = null;
                    block0: for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                        for (int i3 = 0; i3 < stringArray.length; ++i3) {
                            if (!string.equals(stringArray[i3]) || !string2.equals(stringArray2[i2]) || i2 * stringArray.length + i3 >= stringArray3.length) continue;
                            this.themeFile = stringArray3[i2 * stringArray.length + i3];
                            continue block0;
                        }
                    }
                    if (this.themeFile != null && (string3 = XPStyle.getTextResourceByName(this.styleFile, this.themeFile, "TEXTFILE")) != null) {
                        this.merge(string3);
                    }
                }
            }
        }
    }

    private void abandonXP() {
        if (AccessController.doPrivileged(new GetPropertyAction("swing.debug")) != null) {
            System.err.println("An error occured in XPStyle while reading resource " + this.themeFile + " in " + this.styleFile);
            new Exception().printStackTrace();
        }
        xp = null;
    }

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    private void toLowerCase(char[] cArray, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            cArray[i2] = Character.toLowerCase(cArray[i2]);
        }
    }

    static synchronized XPStyle getXP() {
        if (themeActive == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(new GetPropertyAction("swing.noxp")) == null) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    private void merge(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = "";
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken().trim();
            char[] cArray = string3.toCharArray();
            int n2 = cArray.length;
            if (n2 <= 1) continue;
            if (cArray[0] == '[') {
                cArray[n2 - 1] = 46;
                this.toLowerCase(cArray, 1, n2 - 1);
                string2 = new String(cArray, 1, n2 - 1);
                continue;
            }
            int n3 = string3.indexOf(61);
            if (n3 < 0) continue;
            while (n3 > 0 && (cArray[n3 - 1] == ' ' || cArray[n3 - 1] == '\t')) {
                --n3;
            }
            this.toLowerCase(cArray, 0, n3);
            String string4 = string2 + new String(cArray, 0, n3);
            while (n3 < n2 && (cArray[n3] == ' ' || cArray[n3] == '\t' || cArray[n3] == '=')) {
                ++n3;
            }
            String string5 = new String(cArray, n3, n2 - n3);
            if ((n3 = string5.indexOf(59)) >= 0) {
                string5 = string5.substring(0, n3);
            }
            this.map.put(string4, string5.trim());
        }
    }

    int getInt(String string, int n2) {
        return this.parseInt(this.getString(string), n2);
    }

    private int parseInt(String string, int n2) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.abandonXP();
            }
        }
        return n2;
    }

    private boolean getBoolean(String string, boolean bl2) {
        String string2 = this.getString(string);
        return string2 == null ? bl2 : "true".equalsIgnoreCase(string2);
    }

    synchronized Skin getSkin(String string) {
        Skin skin = (Skin)this.map.get("Skin " + string);
        if (skin == null) {
            skin = new Skin(string);
            this.map.put("Skin " + string, skin);
        }
        return skin;
    }

    synchronized Dimension getDimension(String string) {
        String string2;
        Dimension dimension = (Dimension)this.map.get("Dimension " + string);
        if (dimension == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            dimension = new Dimension(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Dimension " + string, dimension);
        }
        return dimension;
    }

    private synchronized Image getImage(String string, boolean bl2) {
        Image image = null;
        String string2 = this.getString(string);
        if (string2 != null && (image = (Image)this.map.get("Image " + string2)) == null) {
            int n2;
            String string3 = string2;
            while ((n2 = string3.indexOf("\\")) >= 0 || (n2 = string3.indexOf(".")) >= 0) {
                string3 = string3.substring(0, n2) + "_" + string3.substring(n2 + 1);
            }
            int[] nArray = XPStyle.getBitmapResource(this.styleFile, string3 = string3.toUpperCase());
            if (nArray != null) {
                int n3 = nArray[nArray.length - 2];
                int n4 = bl2 ? nArray[nArray.length - 1] : 1;
                int n5 = (nArray.length - 2) / n3;
                GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n3, n5, n4);
                bufferedImage.setRGB(0, 0, n3, n5, nArray, 0, n3);
                image = bufferedImage;
                this.map.put("Image " + string2, image);
            }
        }
        return image;
    }

    synchronized Insets getMargin(String string) {
        String string2;
        Insets insets = (Insets)this.map.get("Margin " + string);
        if (insets == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            insets = new Insets(0, 0, 0, 0);
            insets.left = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.right = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.top = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.bottom = this.parseInt(stringTokenizer.nextToken(), 0);
            this.map.put("Margin " + string, insets);
        }
        return insets;
    }

    synchronized Point getPoint(String string) {
        String string2;
        Point point = (Point)this.map.get("Point " + string);
        if (point == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            point = new Point(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Point " + string, point);
        }
        return point;
    }

    synchronized String getString(String string) {
        return (String)this.map.get(string);
    }

    private String[] splitTextResource(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private static native int[] getBitmapResource(String var0, String var1);

    synchronized Border getBorder(String string) {
        Border border = (Border)this.map.get("Border " + string);
        if (border == null) {
            Insets insets;
            String string2 = this.getString(string + ".bgtype");
            if ("borderfill".equalsIgnoreCase(string2)) {
                int n2 = this.getInt(string + ".bordersize", 1);
                Color color = this.getColor(string + ".bordercolor", Color.black);
                border = new XPFillBorder(color, n2);
            } else if ("imagefile".equalsIgnoreCase(string2) && (insets = this.getMargin(string + ".sizingmargins")) != null) {
                border = new XPEmptyBorder(insets);
            }
            if (border != null) {
                this.map.put("Border " + string, border);
            }
        }
        return border;
    }

    synchronized Color getColor(String string, Color color) {
        String string2;
        Color color2 = (Color)this.map.get("Color " + string);
        if (color2 == null && (string2 = this.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            int n2 = this.parseInt(stringTokenizer.nextToken(), 0);
            int n3 = this.parseInt(stringTokenizer.nextToken(), 0);
            int n4 = this.parseInt(stringTokenizer.nextToken(), 0);
            if (n2 >= 0 && n3 >= 0 && n4 >= 0) {
                color2 = new Color(n2, n3, n4);
                this.map.put("Color " + string, color2);
            }
        }
        return color2 != null ? color2 : color;
    }

    private static native String getTextResourceByInt(String var0, int var1, String var2);

    private static native String getTextResourceByName(String var0, String var1, String var2);

    static class GlyphButton
    extends JButton {
        private Skin skin;
        private Image glyphImage;
        private boolean vertical;

        public boolean isFocusTraversable() {
            return false;
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        protected void paintBorder(Graphics graphics) {
        }

        public void paintComponent(Graphics graphics) {
            int n2 = 0;
            if (!this.isEnabled()) {
                n2 = 3;
            } else if (this.getModel().isPressed()) {
                n2 = 2;
            } else if (this.getModel().isRollover()) {
                n2 = 1;
            }
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, n2);
        }

        public GlyphButton(String string) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(string);
            this.glyphImage = xPStyle.getImage(string + ".glyphimagefile", xPStyle.getBoolean(string + ".glyphtransparent", true));
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }
    }

    class Skin {
        private Image image;
        private Insets contentMargin;
        private int w;
        private int h;
        private Image scaledImage;
        private Image glyphImage;
        private int frameCount;
        private Insets paintMargin;
        private boolean tile;
        private boolean sourceShrink;
        private boolean verticalFrames;

        int getHeight() {
            return this.h;
        }

        int getWidth() {
            return this.w;
        }

        void paintSkin(Graphics graphics, int n2, int n3, int n4) {
            this.paintSkin(graphics, n2, n3, this.w, this.h, n4);
        }

        void paintSkin(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
            int n7;
            if (!(this.image == null && this.scaledImage == null && this.glyphImage == null || n6 >= 0 && n6 < this.frameCount)) {
                XPStyle.this.abandonXP();
            }
            if (this.image != null) {
                n7 = 0;
                if (this.h - (this.paintMargin != null ? this.paintMargin.top + this.paintMargin.bottom : 0) > n5 && this.tile && !this.sourceShrink) {
                    n7 = this.h - n5;
                }
                this.paint9(graphics, this.image, n2, n3, n4, n5, this.verticalFrames ? 0 : n6 * this.w, (this.verticalFrames ? n6 * this.h : 0) + n7, this.w, this.h, this.paintMargin, this.tile, this.sourceShrink);
            }
            if (this.scaledImage != null) {
                Image image = this.scaledImage;
                int n8 = image.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                int n9 = image.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
                int n10 = this.verticalFrames ? 0 : n6 * n8;
                int n11 = this.verticalFrames ? n6 * n9 : 0;
                graphics.drawImage(image, n2 += (this.w - n8) / 2, n3 += (this.h - n9) / 2, n2 + n8, n3 + n9, n10, n11, n10 + n8, n11 + n9, null);
            } else if (this.glyphImage != null) {
                n7 = this.glyphImage.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                int n12 = this.glyphImage.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
                if ((n2 += (n4 - n7) / 2) >= 0 && (n3 += (n5 - n12) / 2) >= 0) {
                    int n13 = 0;
                    int n14 = 0;
                    if (this.verticalFrames) {
                        n14 = n6 * n12;
                    } else {
                        n13 = n6 * n7;
                    }
                    graphics.drawImage(this.glyphImage, n2, n3, n2 + n7, n3 + n12, n13, n14, n13 + n7, n14 + n12, null);
                }
            }
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (this.scaledImage != null) {
                return this.scaledImage;
            }
            return null;
        }

        Insets getContentMargin() {
            return this.contentMargin;
        }

        private void paintTile(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
            if (n4 <= 0 || n5 <= 0 || n8 <= 0 || n9 <= 0) {
                return;
            }
            if (bl2 && (n8 > n4 || n9 > n5)) {
                if (n8 > n4 && n9 > n5) {
                    graphics.drawImage(image, n2, n3, n2 + n4, n3 + n5, n6, n7, n6 + n8, n7 + n9, null);
                } else if (n9 > n5) {
                    int n10;
                    BufferedImage bufferedImage = new BufferedImage(n8, n5, 2);
                    Graphics graphics2 = bufferedImage.getGraphics();
                    graphics2.drawImage(image, 0, 0, n8, n5, n6, n7, n6 + n8, n7 + n9, null);
                    for (int i2 = n2; i2 < n2 + n4; i2 += n10) {
                        n10 = Math.min(n8, n2 + n4 - i2);
                        graphics.drawImage(bufferedImage, i2, n3, i2 + n10, n3 + n5, 0, 0, n10, n5, null);
                    }
                    graphics2.dispose();
                } else {
                    BufferedImage bufferedImage = new BufferedImage(n4, n9, 2);
                    Graphics graphics3 = bufferedImage.getGraphics();
                    graphics3.drawImage(image, 0, 0, n4, n9, n6, n7, n6 + n8, n7 + n9, null);
                    for (int i3 = n3; i3 < n3 + n5; i3 += n9) {
                        n9 = Math.min(n9, n3 + n5 - i3);
                        graphics.drawImage(bufferedImage, n2, i3, n2 + n4, i3 + n9, 0, 0, n4, n9, null);
                    }
                    graphics3.dispose();
                }
            } else {
                for (int i4 = n3; i4 < n3 + n5; i4 += n9) {
                    int n11;
                    n9 = Math.min(n9, n3 + n5 - i4);
                    for (int i5 = n2; i5 < n2 + n4; i5 += n11) {
                        n11 = Math.min(n8, n2 + n4 - i5);
                        graphics.drawImage(image, i5, i4, i5 + n11, i4 + n9, n6, n7, n6 + n11, n7 + n9, null);
                    }
                }
            }
        }

        void paintSkin(Graphics graphics, Rectangle rectangle, int n2) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        }

        private Skin(String string) {
            XPStyle xPStyle2 = XPStyle.getXP();
            this.image = xPStyle2.getImage(string + ".imagefile", xPStyle2.getBoolean(string + ".transparent", true));
            int n2 = 0;
            while (xPStyle2.getString(string + ".imagefile" + (n2 + 1)) != null) {
                ++n2;
            }
            if (n2 > 0) {
                int n3 = n2 / 2 + 1;
                if ("dpi".equalsIgnoreCase(XPStyle.this.getString(string + ".imageselecttype"))) {
                    int n4 = Toolkit.getDefaultToolkit().getScreenResolution();
                    n3 = 1;
                    for (int i2 = n2; i2 >= 1; --i2) {
                        int n5 = xPStyle2.getInt(string + ".mindpi" + i2, -1);
                        if (n5 <= 0 || n4 < n5) continue;
                        n3 = i2;
                        break;
                    }
                }
                this.scaledImage = xPStyle2.getImage(string + ".imagefile" + n3, xPStyle2.getBoolean(string + ".transparent", false) || xPStyle2.getBoolean(string + ".glyphtransparent", false));
            }
            this.frameCount = XPStyle.this.getInt(string + ".imagecount", 1);
            this.paintMargin = XPStyle.this.getMargin(string + ".sizingmargins");
            this.contentMargin = XPStyle.this.getMargin(string + ".contentmargins");
            this.tile = "tile".equalsIgnoreCase(XPStyle.this.getString(string + ".sizingtype"));
            this.sourceShrink = XPStyle.this.getBoolean(string + ".sourceshrink", false);
            this.verticalFrames = "vertical".equalsIgnoreCase(XPStyle.this.getString(string + ".imagelayout"));
            this.glyphImage = xPStyle2.getImage(string + ".glyphimagefile", xPStyle2.getBoolean(string + ".glyphtransparent", false));
            Image image = this.image;
            if (image == null && this.scaledImage != null) {
                image = this.scaledImage;
            }
            if (image != null) {
                if (this.frameCount < 1) {
                    XPStyle.this.abandonXP();
                }
                this.w = image.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
                this.h = image.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
            }
        }

        private void paint9(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Insets insets, boolean bl2, boolean bl3) {
            int n10;
            int n11;
            int n12;
            int n13;
            if (insets != null) {
                n13 = insets.top;
                n12 = insets.bottom;
                n11 = insets.left;
                n10 = insets.right;
            } else {
                n10 = 0;
                n11 = 0;
                n12 = 0;
                n13 = 0;
            }
            if (bl2) {
                this.paintTile(graphics, image, n2 + n11, n3 + n13, n4 - n11 - n10, n5 - n13 - n12, n6 + n11, n7 + n13, n8 - n11 - n10, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2, n3 + n13, n11, n5 - n13 - n12, n6, n7 + n13, n11, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2 + n4 - n10, n3 + n13, n10, n5 - n13 - n12, n6 + n8 - n10, n7 + n13, n10, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2 + n11, n3, n4 - n11 - n10, n13, n6 + n11, n7, n8 - n11 - n10, n13, bl3);
                this.paintTile(graphics, image, n2 + n11, n3 + n5 - n12, n4 - n11 - n10, n12, n6 + n11, n7 + n9 - n12, n8 - n11 - n10, n12, bl3);
            } else {
                graphics.drawImage(image, n2 + n11, n3 + n13, n2 + n4 - n10, n3 + n5 - n12, n6 + n11, n7 + n13, n6 + n8 - n10, n7 + n9 - n12, null);
                graphics.drawImage(image, n2, n3 + n13, n2 + n11, n3 + n5 - n12, n6, n7 + n13, n6 + n11, n7 + n9 - n12, null);
                graphics.drawImage(image, n2 + n4 - n10, n3 + n13, n2 + n4, n3 + n5 - n12, n6 + n8 - n10, n7 + n13, n6 + n8, n7 + n9 - n12, null);
                graphics.drawImage(image, n2 + n11, n3, n2 + n4 - n10, n3 + n13, n6 + n11, n7, n6 + n8 - n10, n7 + n13, null);
                graphics.drawImage(image, n2 + n11, n3 + n5 - n12, n2 + n4 - n10, n3 + n5, n6 + n11, n7 + n9 - n12, n6 + n8 - n10, n7 + n9, null);
            }
            graphics.drawImage(image, n2, n3, n2 + n11, n3 + n13, n6, n7, n6 + n11, n7 + n13, null);
            graphics.drawImage(image, n2 + n4 - n10, n3, n2 + n4, n3 + n13, n6 + n8 - n10, n7, n6 + n8, n7 + n13, null);
            graphics.drawImage(image, n2, n3 + n5 - n12, n2 + n11, n3 + n5, n6, n7 + n9 - n12, n6 + n11, n7 + n9, null);
            graphics.drawImage(image, n2 + n4 - n10, n3 + n5 - n12, n2 + n4, n3 + n5, n6 + n8 - n10, n7 + n9 - n12, n6 + n8, n7 + n9, null);
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, this.getBorderInsets());
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n2) {
            super(color, n2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }
}

