/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    private static final MutableBoolean found = new MutableBoolean();
    private boolean implicitDownCycleTraversal = true;

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    public void setImplicitDownCycleTraversal(boolean bl2) {
        this.implicitDownCycleTraversal = bl2;
    }

    protected boolean accept(Component component) {
        if (!(component.isVisible() && component.isDisplayable() && component.isFocusable() && component.isEnabled())) {
            return false;
        }
        if (!(component instanceof Window)) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (!container.isEnabled() && !container.isLightweight()) {
                    return false;
                }
                if (container instanceof Window) break;
            }
        }
        return true;
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getFirstComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            if (this.accept(container)) {
                return container;
            }
            for (int i2 = 0; i2 < container.ncomponents; ++i2) {
                Component component = container.component[i2];
                if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                    Component component2 = this.getFirstComponent((Container)component);
                    if (component2 == null) continue;
                    return component2;
                }
                if (!this.accept(component)) continue;
                return component;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getLastComponent(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible() || !container.isDisplayable()) {
                return null;
            }
            for (int i2 = container.ncomponents - 1; i2 >= 0; --i2) {
                Component component = container.component[i2];
                if (component instanceof Container && !((Container)component).isFocusCycleRoot()) {
                    Component component2 = this.getLastComponent((Container)component);
                    if (component2 == null) continue;
                    return component2;
                }
                if (!this.accept(component)) continue;
                return component;
            }
            if (this.accept(container)) {
                return container;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentAfter(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component component2 = this.getComponentAfter(container, component, found);
            if (component2 != null) {
                return component2;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                return this.getFirstComponent(container);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponentBefore(Container container, Component component) {
        if (container == null || component == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            ContainerOrderFocusTraversalPolicy.found.value = false;
            Component component2 = this.getComponentBefore(container, component, found);
            if (component2 != null) {
                return component2;
            }
            if (ContainerOrderFocusTraversalPolicy.found.value) {
                return this.getLastComponent(container);
            }
            return null;
        }
    }

    private Component getComponentAfter(Container container, Component component, MutableBoolean mutableBoolean) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        if (mutableBoolean.value) {
            if (this.accept(container)) {
                return container;
            }
        } else if (container == component) {
            mutableBoolean.value = true;
        }
        for (int i2 = 0; i2 < container.ncomponents; ++i2) {
            Component component2;
            Component component3;
            Component component4 = container.component[i2];
            if (component4 instanceof Container && !((Container)component4).isFocusCycleRoot()) {
                component3 = this.getComponentAfter((Container)component4, component, mutableBoolean);
                if (component3 != null) {
                    return component3;
                }
            } else if (mutableBoolean.value) {
                if (this.accept(component4)) {
                    return component4;
                }
            } else if (component4 == component) {
                mutableBoolean.value = true;
            }
            if (!mutableBoolean.value || !this.getImplicitDownCycleTraversal() || !(component4 instanceof Container) || !((Container)component4).isFocusCycleRoot() || (component2 = ((Container)(component3 = (Container)component4)).getFocusTraversalPolicy().getDefaultComponent((Container)component3)) == null) continue;
            return component2;
        }
        return null;
    }

    private Component getComponentBefore(Container container, Component component, MutableBoolean mutableBoolean) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return null;
        }
        for (int i2 = container.ncomponents - 1; i2 >= 0; --i2) {
            Component component2 = container.component[i2];
            if (component2 == component) {
                mutableBoolean.value = true;
                continue;
            }
            if (component2 instanceof Container && !((Container)component2).isFocusCycleRoot()) {
                Component component3 = this.getComponentBefore((Container)component2, component, mutableBoolean);
                if (component3 == null) continue;
                return component3;
            }
            if (!mutableBoolean.value || !this.accept(component2)) continue;
            return component2;
        }
        if (mutableBoolean.value) {
            if (this.accept(container)) {
                return container;
            }
        } else if (container == component) {
            mutableBoolean.value = true;
        }
        return null;
    }

    private static class MutableBoolean {
        boolean value = false;

        private MutableBoolean() {
        }
    }
}

