/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class DropTargetContext
implements Serializable {
    private static final long serialVersionUID = -634158968993743371L;
    private DropTarget dropTarget;
    private transient DropTargetContextPeer dropTargetContextPeer;
    private transient Transferable transferable;

    protected int getTargetActions() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        return dropTargetContextPeer != null ? dropTargetContextPeer.getTargetActions() : this.dropTarget.getDefaultActions();
    }

    protected void rejectDrag() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.rejectDrag();
        }
    }

    protected void rejectDrop() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.rejectDrop();
        }
    }

    public void removeNotify() {
        this.dropTargetContextPeer = null;
        this.transferable = null;
    }

    protected void acceptDrag(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.acceptDrag(n2);
        }
    }

    protected void acceptDrop(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.acceptDrop(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTargetActions(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            DropTargetContextPeer dropTargetContextPeer2 = dropTargetContextPeer;
            synchronized (dropTargetContextPeer2) {
                dropTargetContextPeer.setTargetActions(n2);
                this.getDropTarget().doSetDefaultActions(n2);
            }
        } else {
            this.getDropTarget().doSetDefaultActions(n2);
        }
    }

    public void dropComplete(boolean bl2) throws InvalidDnDOperationException {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.dropComplete(bl2);
        }
    }

    public Component getComponent() {
        return this.dropTarget.getComponent();
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        return dropTargetContextPeer != null ? dropTargetContextPeer.getTransferDataFlavors() : new DataFlavor[]{};
    }

    protected boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getCurrentDataFlavorsAsList().contains(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transferable getTransferable() throws InvalidDnDOperationException {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer == null) {
            throw new InvalidDnDOperationException();
        }
        if (this.transferable == null) {
            Transferable transferable = dropTargetContextPeer.getTransferable();
            boolean bl2 = dropTargetContextPeer.isTransferableJVMLocal();
            DropTargetContext dropTargetContext = this;
            synchronized (dropTargetContext) {
                if (this.transferable == null) {
                    this.transferable = this.createTransferableProxy(transferable, bl2);
                }
            }
        }
        return this.transferable;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    DropTargetContext(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    DropTargetContextPeer getDropTargetContextPeer() {
        return this.dropTargetContextPeer;
    }

    public void addNotify(DropTargetContextPeer dropTargetContextPeer) {
        this.dropTargetContextPeer = dropTargetContextPeer;
    }

    protected List getCurrentDataFlavorsAsList() {
        return Arrays.asList(this.getCurrentDataFlavors());
    }

    protected Transferable createTransferableProxy(Transferable transferable, boolean bl2) {
        return new TransferableProxy(transferable, bl2);
    }

    protected class TransferableProxy
    implements Transferable {
        protected Transferable transferable;
        protected boolean isLocal;
        private sun.awt.datatransfer.TransferableProxy proxy;

        public DataFlavor[] getTransferDataFlavors() {
            return this.proxy.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.proxy.isDataFlavorSupported(dataFlavor);
        }

        TransferableProxy(Transferable transferable, boolean bl2) {
            this.proxy = new sun.awt.datatransfer.TransferableProxy(transferable, bl2);
            this.transferable = transferable;
            this.isLocal = bl2;
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.proxy.getTransferData(dataFlavor);
        }
    }
}

