/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.NameGenerator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;

public class Statement {
    private static Object[] emptyArray = new Object[0];
    private static HashMap methodCache = null;
    static ExceptionListener defaultExceptionListener = new ExceptionListener(){

        public void exceptionThrown(Exception exception) {
            System.err.println(exception);
            System.err.println("Continuing ...");
        }
    };
    Object target;
    String methodName;
    Object[] arguments;

    public void execute() throws Exception {
        this.invoke();
    }

    private static boolean isCaching() {
        return methodCache != null;
    }

    static void setCaching(boolean bl2) {
        methodCache = bl2 ? new HashMap() : null;
    }

    public Object getTarget() {
        return this.target;
    }

    Object invoke() throws Exception {
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        if (object == Class.class && string == "forName") {
            return Statement.classForName((String)objectArray[0]);
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2] == null ? null : objectArray[i2].getClass();
        }
        AccessibleObject accessibleObject = null;
        if (object instanceof Class) {
            if (string == "new") {
                string = "newInstance";
            }
            if (string == "newInstance" && ((Class)object).isArray()) {
                Object object2 = Array.newInstance(((Class)object).getComponentType(), objectArray.length);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    Array.set(object2, i3, objectArray[i3]);
                }
                return object2;
            }
            if (string == "newInstance" && objectArray.length != 0) {
                if (object == Character.class && objectArray.length == 1 && classArray[0] == String.class) {
                    return new Character(((String)objectArray[0]).charAt(0));
                }
                Constructor[] constructorArray = ((Class)object).getConstructors();
                for (int i4 = 0; i4 < constructorArray.length; ++i4) {
                    Constructor constructor = constructorArray[i4];
                    if (!Statement.matchArguments(classArray, constructor.getParameterTypes())) continue;
                    accessibleObject = constructor;
                }
            }
            if (accessibleObject == null) {
                accessibleObject = Statement.getMethod((Class)object, string, classArray);
            }
            if (accessibleObject == null) {
                accessibleObject = Statement.getMethod(Class.class, string, classArray);
            }
        } else {
            if (object.getClass().isArray() && (string == "set" || string == "get")) {
                int n2 = (Integer)objectArray[0];
                if (string == "get") {
                    return Array.get(object, n2);
                }
                Array.set(object, n2, objectArray[1]);
                return null;
            }
            accessibleObject = Statement.getMethod(object.getClass(), string, classArray);
        }
        if (accessibleObject != null) {
            try {
                if (accessibleObject instanceof Method) {
                    return accessibleObject.invoke(object, objectArray);
                }
                return ((Constructor)accessibleObject).newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessException(this.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        throw new NoSuchMethodException(this.toString());
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        StringBuffer stringBuffer = new StringBuffer(this.instanceName(object) + "." + string + "(");
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.instanceName(objectArray[i2]));
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(");");
        return stringBuffer.toString();
    }

    static Class primitiveTypeFor(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    static Class typeToClass(Class clazz) {
        return clazz.isPrimitive() ? Statement.typeNameToClass(clazz.getName()) : clazz;
    }

    private static boolean matchArguments(Class[] classArray, Class[] classArray2) {
        boolean bl2 = classArray.length == classArray2.length;
        for (int i2 = 0; i2 < classArray.length && bl2; ++i2) {
            Class clazz = classArray2[i2];
            if (clazz.isPrimitive()) {
                clazz = Statement.typeToClass(clazz);
            }
            if (classArray[i2] == null || clazz.isAssignableFrom(classArray[i2])) continue;
            bl2 = false;
        }
        return bl2;
    }

    private static boolean matchExplicitArguments(Class[] classArray, Class[] classArray2) {
        boolean bl2 = classArray.length == classArray2.length;
        for (int i2 = 0; i2 < classArray.length && bl2; ++i2) {
            Class clazz = classArray2[i2];
            if (clazz.isPrimitive()) {
                clazz = Statement.typeToClass(clazz);
            }
            if (classArray[i2] == clazz) continue;
            bl2 = false;
        }
        return bl2;
    }

    static Class classForName(String string) throws ClassNotFoundException {
        Class clazz = Statement.typeNameToPrimitiveClass(string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.loadClass(string);
    }

    static Class typeNameToClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.class;
        }
        if (string == "byte") {
            return Byte.class;
        }
        if (string == "char") {
            return Character.class;
        }
        if (string == "short") {
            return Short.class;
        }
        if (string == "int") {
            return Integer.class;
        }
        if (string == "long") {
            return Long.class;
        }
        if (string == "float") {
            return Float.class;
        }
        if (string == "double") {
            return Double.class;
        }
        if (string == "void") {
            return Void.class;
        }
        return null;
    }

    private static Class typeNameToPrimitiveClass(String string) {
        if ((string = string.intern()) == "boolean") {
            return Boolean.TYPE;
        }
        if (string == "byte") {
            return Byte.TYPE;
        }
        if (string == "char") {
            return Character.TYPE;
        }
        if (string == "short") {
            return Short.TYPE;
        }
        if (string == "int") {
            return Integer.TYPE;
        }
        if (string == "long") {
            return Long.TYPE;
        }
        if (string == "float") {
            return Float.TYPE;
        }
        if (string == "double") {
            return Double.TYPE;
        }
        if (string == "void") {
            return Void.TYPE;
        }
        return null;
    }

    String instanceName(Object object) {
        return object != null && object.getClass() == String.class ? "\"" + (String)object + "\"" : NameGenerator.instanceName(object);
    }

    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray == null ? emptyArray : objectArray;
    }

    private static Method findMethod(Class clazz, String string, Class[] classArray) {
        Method method = Statement.findPublicMethod(clazz, string, classArray);
        if (method != null && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            return method;
        }
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray2 = clazz2.getInterfaces();
            for (int i2 = 0; i2 < classArray2.length; ++i2) {
                method = Statement.findPublicMethod(classArray2[i2], string, classArray);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    private static Method findPublicMethod(Class clazz, String string, Class[] classArray) {
        Method method;
        if (classArray.length == 0) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        Method[] methodArray = clazz.getMethods();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            method = methodArray[i2];
            if (!method.getName().equals(string) || !Statement.matchArguments(classArray, method.getParameterTypes())) continue;
            arrayList.add(method);
        }
        if (arrayList.size() > 0) {
            if (arrayList.size() == 1) {
                return (Method)arrayList.get(0);
            }
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                method = (Method)listIterator.next();
                if (!Statement.matchExplicitArguments(classArray, method.getParameterTypes())) continue;
                return method;
            }
            return (Method)arrayList.get(0);
        }
        return null;
    }

    static Method getMethod(Class clazz, String string, Class[] classArray) {
        if (!Statement.isCaching()) {
            return Statement.findMethod(clazz, string, classArray);
        }
        Signature signature = new Signature(clazz, string, classArray);
        Method method = (Method)methodCache.get(signature);
        if (method != null) {
            return method;
        }
        method = Statement.findMethod(clazz, string, classArray);
        if (method != null) {
            methodCache.put(signature, method);
        }
        return method;
    }

    private static class Signature {
        Class targetClass;
        String methodName;
        Class[] argClasses;

        public int hashCode() {
            return this.targetClass.hashCode() * 35 + this.methodName.hashCode();
        }

        public boolean equals(Object object) {
            Signature signature = (Signature)object;
            if (this.targetClass != signature.targetClass) {
                return false;
            }
            if (!this.methodName.equals(signature.methodName)) {
                return false;
            }
            if (this.argClasses.length != signature.argClasses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.argClasses.length; ++i2) {
                if (this.argClasses[i2] == signature.argClasses[i2]) continue;
                return false;
            }
            return true;
        }

        public Signature(Class clazz, String string, Class[] classArray) {
            this.targetClass = clazz;
            this.methodName = string;
            this.argClasses = classArray;
        }
    }
}

