/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectShortBufferRU;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferU
extends ShortBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public long address() {
        return this.address;
    }

    public short get() {
        return unsafe.getShort(this.ix(this.nextGetIndex()));
    }

    static {
        $assertionsDisabled = !DirectShortBufferU.class.desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 1);
    }

    public short get(int n2) {
        return unsafe.getShort(this.ix(this.checkIndex(n2)));
    }

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ShortBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 1);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public ShortBuffer duplicate() {
        return new DirectShortBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ShortBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 1;
        return new DirectShortBufferU(this, -1, 0, n4, n4, n5);
    }

    public ShortBuffer put(int n2, short s2) {
        unsafe.putShort(this.ix(this.checkIndex(n2)), s2);
        return this;
    }

    public ShortBuffer put(short s2) {
        unsafe.putShort(this.ix(this.nextPutIndex()), s2);
        return this;
    }

    public ShortBuffer get(short[] sArray, int n2, int n3) {
        if (n3 << 1 > 6) {
            int n4;
            DirectShortBufferU.checkBounds(n2, n3, sArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToShortArray(this.ix(n5), sArray, n2 << 1, n3 << 1);
            } else {
                Bits.copyToByteArray(this.ix(n5), sArray, n2 << 1, n3 << 1);
            }
            this.position(n5 + n3);
        } else {
            super.get(sArray, n2, n3);
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n2, int n3) {
        if (n3 << 1 > 6) {
            int n4;
            DirectShortBufferU.checkBounds(n2, n3, sArray.length);
            int n5 = this.position();
            int n6 = this.limit();
            if (!$assertionsDisabled && n5 > n6) {
                throw new AssertionError();
            }
            int n7 = n4 = n5 <= n6 ? n6 - n5 : 0;
            if (n3 > n4) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromShortArray(sArray, n2 << 1, this.ix(n5), n3 << 1);
            } else {
                Bits.copyFromByteArray(sArray, n2 << 1, this.ix(n5), n3 << 1);
            }
            this.position(n5 + n3);
        } else {
            super.put(sArray, n2, n3);
        }
        return this;
    }

    public Cleaner cleaner() {
        return null;
    }

    DirectShortBufferU(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.viewedBuffer = directBuffer;
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof DirectShortBufferU) {
            int n2;
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectShortBufferU directShortBufferU = (DirectShortBufferU)shortBuffer;
            int n3 = directShortBufferU.position();
            int n4 = directShortBufferU.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directShortBufferU.ix(n3), this.ix(n6), n5 << 1);
            directShortBufferU.position(n3 + n5);
            this.position(n6 + n5);
        } else if (!shortBuffer.isDirect()) {
            int n9 = shortBuffer.position();
            int n10 = shortBuffer.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n9 <= n10 ? n10 - n9 : 0;
            this.put(shortBuffer.hb, shortBuffer.offset + n9, n11);
            shortBuffer.position(n9 + n11);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }
}

