/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapShortBuffer;
import java.nio.ReadOnlyBufferException;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    final short[] hb;
    final int offset;
    boolean isReadOnly;

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + this.get(i2);
        }
        return n2;
    }

    public abstract short get();

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public abstract boolean isDirect();

    public final short[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public abstract short get(int var1);

    ShortBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    ShortBuffer(int n2, int n3, int n4, int n5, short[] sArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = sArray;
        this.offset = n6;
    }

    public int compareTo(Object object) {
        ShortBuffer shortBuffer = (ShortBuffer)object;
        int n2 = this.position() + Math.min(this.remaining(), shortBuffer.remaining());
        int n3 = this.position();
        int n4 = shortBuffer.position();
        while (n3 < n2) {
            short s2;
            short s3 = this.get(n3);
            if (s3 != (s2 = shortBuffer.get(n4)) && (s3 == s3 || s2 == s2)) {
                if (s3 < s2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - shortBuffer.remaining();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer shortBuffer = (ShortBuffer)object;
        if (this.remaining() != shortBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = shortBuffer.limit() - 1;
        while (n3 >= n2) {
            short s2;
            short s3 = this.get(n3);
            if (s3 != (s2 = shortBuffer.get(n4)) && (s3 == s3 || s2 == s2)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public abstract ByteOrder order();

    public abstract ShortBuffer asReadOnlyBuffer();

    public abstract ShortBuffer compact();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer slice();

    public static ShortBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapShortBuffer(n2, n2);
    }

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer put(short var1);

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public static ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public ShortBuffer get(short[] sArray, int n2, int n3) {
        ShortBuffer.checkBounds(n2, n3, sArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            sArray[i2] = this.get();
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n2, int n3) {
        ShortBuffer.checkBounds(n2, n3, sArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.put(sArray[i2]);
        }
        return this;
    }

    public static ShortBuffer wrap(short[] sArray, int n2, int n3) {
        try {
            return new HeapShortBuffer(sArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = shortBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(shortBuffer.get());
        }
        return this;
    }
}

