/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.SubjectDomainCombiner;
import sun.security.util.ResourcesMgr;
import sun.security.util.SecurityConstants;

public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    Set principals;
    transient Set pubCredentials;
    transient Set privCredentials;
    private boolean readOnly = false;
    private static final int PRINCIPAL_SET = 1;
    private static final int PUB_CREDENTIAL_SET = 2;
    private static final int PRIV_CREDENTIAL_SET = 3;
    static /* synthetic */ Class class$javax$security$auth$Subject;
    static /* synthetic */ Class class$java$util$LinkedList;

    public int hashCode() {
        int n2 = 0;
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = this.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Principal principal = (Principal)iterator.next();
            n2 ^= ((Object)principal).hashCode();
        }
        while (iterator2.hasNext()) {
            n2 ^= this.getCredHashCode(iterator2.next());
        }
        return n2;
    }

    public Subject() {
        this.principals = new SecureSet(this, 1);
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void sort(int[] nArray) {
        int n2 = 0;
        boolean bl2 = true;
        int n3 = nArray.length - 1;
        while (bl2) {
            bl2 = false;
            for (n2 = 0; n2 < n3; ++n2) {
                if (nArray[n2] >= nArray[n2 + 1]) continue;
                bl2 = true;
                int n4 = nArray[n2];
                nArray[n2] = nArray[n2 + 1];
                nArray[n2 + 1] = n4;
            }
            --n3;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pubCredentials = new SecureSet(this, 2);
        this.privCredentials = new SecureSet(this, 3);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private int getCredHashCode(Object object) {
        try {
            return object.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            return object.getClass().toString().hashCode();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Subject) {
            Subject subject = (Subject)object;
            return ((Object)this.getPrincipals()).equals(subject.getPrincipals()) && ((Object)this.getPublicCredentials()).equals(subject.getPublicCredentials()) && ((Object)this.getPrivateCredentials()).equals(subject.getPrivateCredentials());
        }
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    String toString(boolean bl2) {
        Object object;
        String string = new String(ResourcesMgr.getString("Subject:\n"));
        String string2 = new String();
        Iterator iterator = this.getPrincipals().iterator();
        Iterator iterator2 = this.getPublicCredentials().iterator();
        Iterator iterator3 = null;
        if (bl2) {
            try {
                iterator3 = this.getPrivateCredentials().iterator();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        while (iterator.hasNext()) {
            object = (Principal)iterator.next();
            string2 = string2 + ResourcesMgr.getString("\tPrincipal: ") + object.toString() + ResourcesMgr.getString("\n");
        }
        while (iterator2.hasNext()) {
            object = iterator2.next();
            string2 = string2 + ResourcesMgr.getString("\tPublic Credential: ") + object.toString() + ResourcesMgr.getString("\n");
        }
        if (iterator3 == null) {
            string2 = string2 + ResourcesMgr.getString("\tPrivate Credentials inaccessible\n");
        } else {
            while (iterator3.hasNext()) {
                try {
                    object = iterator3.next();
                    string2 = string2 + ResourcesMgr.getString("\tPrivate Credential: ") + object.toString() + ResourcesMgr.getString("\n");
                }
                catch (SecurityException securityException) {
                    string2 = string2 + ResourcesMgr.getString("\tPrivate Credential inaccessible\n");
                    break;
                }
            }
        }
        return string + string2;
    }

    public Set getPrincipals() {
        return this.principals;
    }

    public Set getPrivateCredentials() {
        return this.privCredentials;
    }

    public Set getPublicCredentials() {
        return this.pubCredentials;
    }

    public Set getPrincipals(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(1, clazz);
    }

    public Set getPrivateCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(3, clazz);
    }

    public Set getPublicCredentials(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null Class provided"));
        }
        return new ClassSet(2, clazz);
    }

    public static Subject getSubject(final AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthPermission("getSubject"));
        }
        if (accessControlContext == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null AccessControlContext provided"));
        }
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
                if (!(domainCombiner instanceof SubjectDomainCombiner)) {
                    return null;
                }
                SubjectDomainCombiner subjectDomainCombiner = (SubjectDomainCombiner)domainCombiner;
                return subjectDomainCombiner.getSubject();
            }
        });
    }

    public static Object doAs(Subject subject, PrivilegedAction privilegedAction) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PERMISSION);
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext));
    }

    public static Object doAs(Subject subject, PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PERMISSION);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext));
    }

    private static AccessControlContext createContext(final Subject subject, final AccessControlContext accessControlContext) {
        return (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (subject == null) {
                    return new AccessControlContext(accessControlContext, null);
                }
                return new AccessControlContext(accessControlContext, (DomainCombiner)new SubjectDomainCombiner(subject));
            }
        });
    }

    public Subject(boolean bl2, Set set, Set set2, Set set3) {
        if (set == null || set2 == null || set3 == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null input(s)"));
        }
        this.principals = new SecureSet(this, 1, set);
        this.pubCredentials = new SecureSet(this, 2, set2);
        this.privCredentials = new SecureSet(this, 3, set3);
        this.readOnly = bl2;
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PRIVILEGED_PERMISSION);
        }
        if (privilegedAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedAction, Subject.createContext(subject, accessControlContext2));
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.DO_AS_PRIVILEGED_PERMISSION);
        }
        if (privilegedExceptionAction == null) {
            throw new NullPointerException(ResourcesMgr.getString("invalid null action provided"));
        }
        AccessControlContext accessControlContext2 = accessControlContext == null ? new AccessControlContext(new ProtectionDomain[0]) : accessControlContext;
        return AccessController.doPrivileged(privilegedExceptionAction, Subject.createContext(subject, accessControlContext2));
    }

    private class ClassSet
    extends AbstractSet {
        private int which;
        private Set set;
        private Class c;

        public synchronized int size() {
            return this.set.size();
        }

        public synchronized boolean add(Object object) {
            if (!object.getClass().isAssignableFrom(this.c)) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("attempting to add an object which is not an instance of class"));
                Object[] objectArray = new Object[]{this.c.toString()};
                throw new SecurityException(messageFormat.format(objectArray));
            }
            return this.set.add(object);
        }

        public Iterator iterator() {
            return this.set.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassSet(int n2, Class clazz) {
            ClassSet classSet = this;
            synchronized (classSet) {
                this.which = n2;
                this.c = clazz;
                Iterator iterator = null;
                switch (n2) {
                    case 1: {
                        iterator = Subject.this.principals.iterator();
                        break;
                    }
                    case 2: {
                        iterator = Subject.this.pubCredentials.iterator();
                        break;
                    }
                    default: {
                        iterator = Subject.this.privCredentials.iterator();
                    }
                }
                Iterator iterator2 = iterator;
                SecurityManager securityManager = System.getSecurityManager();
                this.set = new HashSet();
                while (iterator2.hasNext()) {
                    Object object = AccessController.doPrivileged(new PrivilegedAction(this, iterator2){
                        private final /* synthetic */ Iterator val$iterator_copy;
                        private final /* synthetic */ ClassSet this$1;

                        public Object run() {
                            return this.val$iterator_copy.next();
                        }
                        {
                            this.this$1 = classSet;
                            this.val$iterator_copy = iterator;
                        }
                    });
                    if (!clazz.isAssignableFrom(object.getClass())) continue;
                    if (n2 != 3) {
                        this.set.add(object);
                        continue;
                    }
                    if (securityManager != null) {
                        if (Subject.this.getPrincipals() == null || Subject.this.getPrincipals().size() == 0) {
                            securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), new HashSet()));
                        } else {
                            securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(object.getClass().getName(), Subject.this.getPrincipals()), "read"));
                        }
                    }
                    this.set.add(object);
                }
            }
        }
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("this$0", class$javax$security$auth$Subject == null ? (class$javax$security$auth$Subject = Subject.class$("javax.security.auth.Subject")) : class$javax$security$auth$Subject), new ObjectStreamField("elements", class$java$util$LinkedList == null ? (class$java$util$LinkedList = Subject.class$("java.util.LinkedList")) : class$java$util$LinkedList), new ObjectStreamField("which", Integer.TYPE)};
        Subject subject;
        LinkedList elements;
        private int which;

        public synchronized int size() {
            return this.elements.size();
        }

        public void clear() {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;

                    public Object run() {
                        return this.val$e.next();
                    }
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }
                });
                iterator.remove();
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.subject = (Subject)getField.get("this$0", null);
            this.elements = (LinkedList)getField.get("elements", null);
            this.which = getField.get("which", 0);
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            Object object;
            if (this.which == 3) {
                object = this.iterator();
                while (object.hasNext()) {
                    object.next();
                }
            }
            object = objectOutputStream.putFields();
            ((ObjectOutputStream.PutField)object).put("this$0", this.subject);
            ((ObjectOutputStream.PutField)object).put("elements", this.elements);
            ((ObjectOutputStream.PutField)object).put("which", this.which);
            objectOutputStream.writeFields();
        }

        public synchronized boolean add(Object object) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                switch (this.which) {
                    case 1: {
                        securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                        break;
                    }
                    case 2: {
                        securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                        break;
                    }
                    default: {
                        securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    }
                }
            }
            switch (this.which) {
                case 1: {
                    if (object instanceof Principal) break;
                    throw new SecurityException(ResourcesMgr.getString("attempting to add an object which is not an instance of java.security.Principal to a Subject's Principal Set"));
                }
            }
            if (!this.elements.contains(object)) {
                return this.elements.add(object);
            }
            return false;
        }

        public synchronized boolean contains(Object object) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && this.which == 3) {
                if (this.subject.getPrincipals() == null || this.subject.getPrincipals().size() == 0) {
                    securityManager.checkPermission(new PrivateCredentialPermission(object.getClass().getName(), new HashSet()));
                } else {
                    securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(object.getClass().getName(), this.subject.getPrincipals()), "read"));
                }
            }
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;

                    public Object run() {
                        return this.val$e.next();
                    }
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }
                });
                if (!(object2 == null ? object == null : object2.equals(object))) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean remove(Object object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object object2 = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;

                    public Object run() {
                        return this.val$e.next();
                    }
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }
                });
                if (object2 == null) {
                    if (object != null) continue;
                    iterator.remove();
                    return true;
                }
                if (!object2.equals(object)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection collection) {
            boolean bl2 = false;
            Iterator iterator = this.iterator();
            block0: while (iterator.hasNext()) {
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;

                    public Object run() {
                        return this.val$e.next();
                    }
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object object2 = iterator2.next();
                    if (object == null) {
                        if (object2 != null) continue;
                        iterator.remove();
                        bl2 = true;
                        continue block0;
                    }
                    if (!object.equals(object2)) continue;
                    iterator.remove();
                    bl2 = true;
                    continue block0;
                }
            }
            return bl2;
        }

        public boolean retainAll(Collection collection) {
            boolean bl2 = false;
            boolean bl3 = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                bl3 = false;
                Object object = this.which != 3 ? iterator.next() : AccessController.doPrivileged(new PrivilegedAction(this, iterator){
                    private final /* synthetic */ Iterator val$e;
                    private final /* synthetic */ SecureSet this$0;

                    public Object run() {
                        return this.val$e.next();
                    }
                    {
                        this.this$0 = secureSet;
                        this.val$e = iterator;
                    }
                });
                Iterator iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    Object object2 = iterator2.next();
                    if (object == null) {
                        if (object2 != null) continue;
                        bl3 = true;
                        break;
                    }
                    if (!object.equals(object2)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                iterator.remove();
                bl3 = false;
                bl2 = true;
            }
            return bl2;
        }

        public Iterator iterator() {
            LinkedList linkedList = this.elements;
            return new Iterator(this, linkedList){
                ListIterator i;
                private final /* synthetic */ LinkedList val$list;
                private final /* synthetic */ SecureSet this$0;

                public synchronized void remove() {
                    if (this.this$0.subject.isReadOnly()) {
                        throw new IllegalStateException(ResourcesMgr.getString("Subject is read-only"));
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        switch (SecureSet.access$000(this.this$0)) {
                            case 1: {
                                securityManager.checkPermission(new AuthPermission("modifyPrincipals"));
                                break;
                            }
                            case 2: {
                                securityManager.checkPermission(new AuthPermission("modifyPublicCredentials"));
                                break;
                            }
                            default: {
                                securityManager.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                            }
                        }
                    }
                    this.i.remove();
                }

                public synchronized boolean hasNext() {
                    return this.i.hasNext();
                }

                public synchronized Object next() {
                    if (SecureSet.access$000(this.this$0) != 3) {
                        return this.i.next();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        try {
                            if (this.this$0.subject.getPrincipals() == null || this.this$0.subject.getPrincipals().size() == 0) {
                                securityManager.checkPermission(new PrivateCredentialPermission(this.val$list.get(this.i.nextIndex()).getClass().getName(), new HashSet()));
                            } else {
                                securityManager.checkPermission(new PrivateCredentialPermission(PrivateCredentialPermission.buildTarget(this.val$list.get(this.i.nextIndex()).getClass().getName(), this.this$0.subject.getPrincipals()), "read"));
                            }
                        }
                        catch (SecurityException securityException) {
                            this.i.next();
                            throw securityException;
                        }
                    }
                    return this.i.next();
                }
                {
                    this.this$0 = secureSet;
                    this.val$list = linkedList;
                    this.i = this.val$list.listIterator(0);
                }
            };
        }

        SecureSet(Subject subject, int n2) {
            this.subject = subject;
            this.which = n2;
            this.elements = new LinkedList();
        }

        static /* synthetic */ int access$000(SecureSet secureSet) {
            return secureSet.which;
        }

        SecureSet(Subject subject, int n2, Set set) {
            this.subject = subject;
            this.which = n2;
            this.elements = new LinkedList(set);
        }
    }
}

