/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Spring;

public class SpringLayout
implements LayoutManager2 {
    private Map componentConstraints = new HashMap();
    private Spring cyclicReference = Spring.constant(Integer.MIN_VALUE);
    private Set cyclicSprings;
    private Set acyclicSprings;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";

    private void resetCyclicStatuses() {
        this.cyclicSprings = new HashSet();
        this.acyclicSprings = new HashSet();
    }

    public void removeLayoutComponent(Component component) {
        this.componentConstraints.remove(component);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        this.setParent(container);
        int n2 = container.getComponentCount();
        this.getConstraints(container).reset();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getConstraints(container.getComponent(i2)).reset();
        }
        Insets insets = container.getInsets();
        Constraints constraints = this.getConstraints(container);
        this.abandonCycles(constraints.getX()).setValue(0);
        this.abandonCycles(constraints.getY()).setValue(0);
        this.abandonCycles(constraints.getWidth()).setValue(container.getWidth() - insets.left - insets.right);
        this.abandonCycles(constraints.getHeight()).setValue(container.getHeight() - insets.top - insets.bottom);
        for (int i3 = 0; i3 < n2; ++i3) {
            Component component = container.getComponent(i3);
            Constraints constraints2 = this.getConstraints(component);
            int n3 = this.abandonCycles(constraints2.getX()).getValue();
            int n4 = this.abandonCycles(constraints2.getY()).getValue();
            int n5 = this.abandonCycles(constraints2.getWidth()).getValue();
            int n6 = this.abandonCycles(constraints2.getHeight()).getValue();
            component.setBounds(insets.left + n3, insets.top + n4, n5, n6);
        }
    }

    private void setParent(Container container) {
        this.resetCyclicStatuses();
        Constraints constraints = this.getConstraints(container);
        constraints.setX(Spring.constant(0));
        constraints.setY(Spring.constant(0));
        constraints.setWidth(null);
        constraints.setHeight(null);
        if (constraints.getEast() == null) {
            constraints.setEast(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
        if (constraints.getSouth() == null) {
            constraints.setSouth(Spring.constant(0, 0, Integer.MAX_VALUE));
        }
    }

    boolean isCyclic(Spring spring) {
        if (spring == null) {
            return false;
        }
        if (this.cyclicSprings.contains(spring)) {
            return true;
        }
        if (this.acyclicSprings.contains(spring)) {
            return false;
        }
        this.cyclicSprings.add(spring);
        boolean bl2 = spring.isCyclic(this);
        if (!bl2) {
            this.acyclicSprings.add(spring);
            this.cyclicSprings.remove(spring);
        } else {
            System.err.println(spring + " is cyclic. ");
        }
        return bl2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    private static Dimension addInsets(int n2, int n3, Container container) {
        Insets insets = container.getInsets();
        return new Dimension(n2 + insets.left + insets.right, n3 + insets.top + insets.bottom);
    }

    public Dimension maximumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMaximumValue(), this.abandonCycles(constraints.getHeight()).getMaximumValue(), container);
    }

    public Dimension minimumLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getMinimumValue(), this.abandonCycles(constraints.getHeight()).getMinimumValue(), container);
    }

    public Dimension preferredLayoutSize(Container container) {
        this.setParent(container);
        Constraints constraints = this.getConstraints(container);
        return SpringLayout.addInsets(this.abandonCycles(constraints.getWidth()).getPreferredValue(), this.abandonCycles(constraints.getHeight()).getPreferredValue(), container);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof Constraints) {
            this.putConstraints(component, (Constraints)object);
        }
    }

    private Spring abandonCycles(Spring spring) {
        return this.isCyclic(spring) ? this.cyclicReference : spring;
    }

    public Constraints getConstraints(Component component) {
        Constraints constraints = (Constraints)this.componentConstraints.get(component);
        if (constraints == null) {
            Object object;
            if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(SpringLayout.class)) instanceof Constraints) {
                return this.applyDefaults(component, (Constraints)object);
            }
            constraints = new Constraints();
            this.putConstraints(component, constraints);
        }
        return constraints;
    }

    private void putConstraints(Component component, Constraints constraints) {
        this.componentConstraints.put(component, this.applyDefaults(component, constraints));
    }

    public Spring getConstraint(String string, Component component) {
        string = string.intern();
        return new SpringProxy(string, component, this);
    }

    private void putConstraint(String string, Component component, Spring spring) {
        if (spring != null) {
            this.getConstraints(component).setConstraint(string, spring);
        }
    }

    private Constraints applyDefaults(Component component, Constraints constraints) {
        if (constraints == null) {
            constraints = new Constraints();
        }
        if (constraints.getWidth() == null) {
            constraints.setWidth(new WidthSpring(component));
        }
        if (constraints.getHeight() == null) {
            constraints.setHeight(new HeightSpring(component));
        }
        if (constraints.getX() == null) {
            constraints.setX(Spring.constant(0));
        }
        if (constraints.getY() == null) {
            constraints.setY(Spring.constant(0));
        }
        return constraints;
    }

    public void putConstraint(String string, Component component, int n2, String string2, Component component2) {
        this.putConstraint(string, component, Spring.constant(n2), string2, component2);
    }

    public void putConstraint(String string, Component component, Spring spring, String string2, Component component2) {
        this.putConstraint(string, component, Spring.sum(spring, this.getConstraint(string2, component2)));
    }

    public static class Constraints {
        private Spring x;
        private Spring y;
        private Spring width;
        private Spring height;
        private Spring east;
        private Spring south;
        private Spring verticalDerived = null;
        private Spring horizontalDerived = null;

        public Constraints() {
            this(null, null, null, null);
        }

        void reset() {
            if (this.x != null) {
                this.x.setValue(Integer.MIN_VALUE);
            }
            if (this.y != null) {
                this.y.setValue(Integer.MIN_VALUE);
            }
            if (this.width != null) {
                this.width.setValue(Integer.MIN_VALUE);
            }
            if (this.height != null) {
                this.height.setValue(Integer.MIN_VALUE);
            }
            if (this.east != null) {
                this.east.setValue(Integer.MIN_VALUE);
            }
            if (this.south != null) {
                this.south.setValue(Integer.MIN_VALUE);
            }
            if (this.horizontalDerived != null) {
                this.horizontalDerived.setValue(Integer.MIN_VALUE);
            }
            if (this.verticalDerived != null) {
                this.verticalDerived.setValue(Integer.MIN_VALUE);
            }
        }

        private boolean overConstrainedHorizontally() {
            return this.x != null && this.width != null && this.east != null;
        }

        private boolean overConstrainedVertically() {
            return this.y != null && this.height != null && this.south != null;
        }

        private Spring getEast() {
            if (this.east != null) {
                return this.east;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.sum(this.x, this.width);
            }
            return this.horizontalDerived;
        }

        public Spring getHeight() {
            if (this.height != null) {
                return this.height;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.y);
            }
            return this.verticalDerived;
        }

        private Spring getSouth() {
            if (this.south != null) {
                return this.south;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.sum(this.y, this.height);
            }
            return this.verticalDerived;
        }

        public Spring getWidth() {
            if (this.width != null) {
                return this.width;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.x);
            }
            return this.horizontalDerived;
        }

        public Spring getX() {
            if (this.x != null) {
                return this.x;
            }
            if (this.horizontalDerived == null) {
                this.horizontalDerived = this.difference(this.east, this.width);
            }
            return this.horizontalDerived;
        }

        public Spring getY() {
            if (this.y != null) {
                return this.y;
            }
            if (this.verticalDerived == null) {
                this.verticalDerived = this.difference(this.south, this.height);
            }
            return this.verticalDerived;
        }

        private void setEast(Spring spring) {
            this.east = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.x = null;
            }
        }

        public void setHeight(Spring spring) {
            this.height = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.south = null;
            }
        }

        private void setSouth(Spring spring) {
            this.south = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.y = null;
            }
        }

        public void setWidth(Spring spring) {
            this.width = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.east = null;
            }
        }

        public void setX(Spring spring) {
            this.x = spring;
            this.horizontalDerived = null;
            if (this.overConstrainedHorizontally()) {
                this.width = null;
            }
        }

        public void setY(Spring spring) {
            this.y = spring;
            this.verticalDerived = null;
            if (this.overConstrainedVertically()) {
                this.height = null;
            }
        }

        public Spring getConstraint(String string) {
            return (string = string.intern()) == SpringLayout.WEST ? this.getX() : (string == SpringLayout.NORTH ? this.getY() : (string == SpringLayout.EAST ? this.getEast() : (string == SpringLayout.SOUTH ? this.getSouth() : null)));
        }

        public void setConstraint(String string, Spring spring) {
            if ((string = string.intern()) == SpringLayout.WEST) {
                this.setX(spring);
            } else if (string == SpringLayout.NORTH) {
                this.setY(spring);
            } else if (string == SpringLayout.EAST) {
                this.setEast(spring);
            } else if (string == SpringLayout.SOUTH) {
                this.setSouth(spring);
            }
        }

        public Constraints(Spring spring, Spring spring2) {
            this(spring, spring2, null, null);
        }

        private Spring difference(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.difference(spring, spring2);
        }

        private Spring sum(Spring spring, Spring spring2) {
            return spring == null || spring2 == null ? null : Spring.sum(spring, spring2);
        }

        public Constraints(Spring spring, Spring spring2, Spring spring3, Spring spring4) {
            this.x = spring;
            this.y = spring2;
            this.width = spring3;
            this.height = spring4;
        }
    }

    private static class HeightSpring
    extends Spring.AbstractSpring {
        private Component c;

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().height);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().height;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().height;
        }

        public HeightSpring(Component component) {
            this.c = component;
        }
    }

    private static class SpringProxy
    extends Spring {
        private String edgeName;
        private Component c;
        private SpringLayout l;

        public int getMaximumValue() {
            return this.getConstraint().getMaximumValue();
        }

        public int getMinimumValue() {
            return this.getConstraint().getMinimumValue();
        }

        public int getPreferredValue() {
            return this.getConstraint().getPreferredValue();
        }

        public int getValue() {
            return this.getConstraint().getValue();
        }

        public void setValue(int n2) {
            this.getConstraint().setValue(n2);
        }

        public String toString() {
            return "SpringProxy for " + this.edgeName + " edge of " + this.c.getName() + ".";
        }

        private Spring getConstraint() {
            return this.l.getConstraints(this.c).getConstraint(this.edgeName);
        }

        boolean isCyclic(SpringLayout springLayout) {
            return springLayout.isCyclic(this.getConstraint());
        }

        public SpringProxy(String string, Component component, SpringLayout springLayout) {
            this.edgeName = string;
            this.c = component;
            this.l = springLayout;
        }
    }

    private static class WidthSpring
    extends Spring.AbstractSpring {
        private Component c;

        public int getMaximumValue() {
            return Math.min(Short.MAX_VALUE, this.c.getMaximumSize().width);
        }

        public int getMinimumValue() {
            return this.c.getMinimumSize().width;
        }

        public int getPreferredValue() {
            return this.c.getPreferredSize().width;
        }

        public WidthSpring(Component component) {
            this.c = component;
        }
    }
}

