/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                MetalFileChooserUI.this.applyEdit();
            }
        }
    };
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    static final int space = 10;

    private int getEditIndex() {
        return this.lastIndex;
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser jFileChooser = this.getFileChooser();
            String string = jFileChooser.getName(this.editFile);
            String string2 = this.editFile.getName();
            String string3 = this.editCell.getText().trim();
            if (!string3.equals(string)) {
                FileSystemView fileSystemView;
                File file;
                int n2;
                String string4 = string3;
                int n3 = string2.length();
                if (n3 > (n2 = string.length()) && string2.charAt(n2) == '.') {
                    string4 = string3 + string2.substring(n2);
                }
                if (!(file = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), string4)).exists() && this.getModel().renameFile(this.editFile, file) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file)) {
                    if (jFileChooser.isMultiSelectionEnabled()) {
                        jFileChooser.setSelectedFiles(new File[]{file});
                    } else {
                        jFileChooser.setSelectedFile(file);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    private void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] objectArray = this.getFileChooser().getSelectedFiles();
            Object[] objectArray2 = this.list.getSelectedValues();
            if (ShellFolder.disableFileChooserSpeedFix()) {
                int n2;
                boolean bl2;
                int n3;
                for (n3 = 0; n3 < objectArray2.length; ++n3) {
                    bl2 = false;
                    for (n2 = 0; n2 < objectArray.length; ++n2) {
                        if (!((File)objectArray[n2]).equals(objectArray2[n3])) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2 || (n2 = this.getModel().indexOf(objectArray2[n3])) < 0) continue;
                    this.listSelectionModel.removeSelectionInterval(n2, n2);
                }
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    bl2 = false;
                    for (n2 = 0; n2 < objectArray2.length; ++n2) {
                        if (!((File)objectArray[n3]).equals(objectArray2[n2])) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2 || (n2 = this.getModel().indexOf(objectArray[n3])) < 0) continue;
                    this.listSelectionModel.addSelectionInterval(n2, n2);
                }
            } else {
                this.listSelectionModel.setValueIsAdjusting(true);
                try {
                    int n4;
                    Arrays.sort(objectArray);
                    Arrays.sort(objectArray2);
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < objectArray.length && n6 < objectArray2.length) {
                        int n7;
                        n4 = ((File)objectArray[n5]).compareTo(objectArray2[n6]);
                        if (n4 < 0) {
                            n7 = this.getModel().indexOf(objectArray[n5]);
                            this.listSelectionModel.addSelectionInterval(n7, n7);
                            ++n5;
                            continue;
                        }
                        if (n4 > 0) {
                            n7 = this.getModel().indexOf(objectArray2[n6]);
                            this.listSelectionModel.removeSelectionInterval(n7, n7);
                            ++n6;
                            continue;
                        }
                        ++n5;
                        ++n6;
                    }
                    while (n5 < objectArray.length) {
                        n4 = this.getModel().indexOf(objectArray[n5]);
                        this.listSelectionModel.addSelectionInterval(n4, n4);
                        ++n5;
                    }
                    while (n6 < objectArray2.length) {
                        n4 = this.getModel().indexOf(objectArray2[n6]);
                        this.listSelectionModel.removeSelectionInterval(n4, n4);
                        ++n6;
                    }
                }
                finally {
                    this.listSelectionModel.setValueIsAdjusting(false);
                }
            }
        } else {
            int n8;
            JFileChooser jFileChooser = this.getFileChooser();
            File file = null;
            file = this.isDirectorySelected() ? this.getDirectory() : jFileChooser.getSelectedFile();
            if (file != null && (n8 = this.getModel().indexOf(file)) >= 0) {
                this.listSelectionModel.setSelectionInterval(n8, n8);
                this.ensureIndexIsVisible(n8);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private void updateUseShellFolder() {
        JFileChooser jFileChooser = this.getFileChooser();
        Boolean bl2 = (Boolean)jFileChooser.getClientProperty("FileChooser.useShellFolder");
        if (bl2 != null) {
            this.useShellFolder = bl2;
        } else {
            File[] fileArray;
            this.useShellFolder = false;
            File[] fileArray2 = jFileChooser.getFileSystemView().getRoots();
            if (fileArray2 != null && fileArray2.length == 1 && (fileArray = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && fileArray.length > 0 && fileArray2[0] == fileArray[0]) {
                this.useShellFolder = true;
            }
        }
    }

    private void editFileName(int n2) {
        this.ensureIndexIsVisible(n2);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(n2);
            Rectangle rectangle = this.list.getCellBounds(n2, n2);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            } else {
                this.editCell.setBounds(rectangle.x, rectangle.y, rectangle.width - this.editX, rectangle.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(n2, 0);
        }
    }

    private void ensureIndexIsVisible(int n2) {
        if (n2 >= 0) {
            this.list.ensureIndexIsVisible(n2);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(n2, 0, true));
            }
        }
    }

    private void fixNameColumnWidth(int n2) {
        TableColumn tableColumn = this.detailsTable.getColumnModel().getColumn(0);
        int n3 = this.detailsTable.getPreferredSize().width;
        if (n3 < n2) {
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + n2 - n3);
        }
    }

    private void setEditIndex(int n2) {
        this.lastIndex = n2;
    }

    protected void setDirectorySelected(boolean bl2) {
        super.setDirectorySelected(bl2);
        JFileChooser jFileChooser = this.getFileChooser();
        if (bl2) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(jFileChooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAccessoryPanel() != null) {
            JComponent jComponent;
            if (propertyChangeEvent.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)propertyChangeEvent.getOldValue());
            }
            if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)jComponent, "Center");
            }
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
    }

    private void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    private void doDialogTypeChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        if (jFileChooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File file = jFileChooser.getCurrentDirectory();
        if (file != null) {
            this.directoryComboBoxModel.addItem(file);
            this.getNewFolderAction().setEnabled(file.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fileSystemView.isRoot(file));
            if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
                if (fileSystemView.isFileSystem(file)) {
                    this.setFileName(file.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getCurrentDirectory();
        if (file != null && jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled() && jFileChooser.getFileSystemView().isFileSystem(file)) {
            this.setFileName(file.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doFilterChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File file = (File)propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (file != null && (jFileChooser.isFileSelectionEnabled() && !file.isDirectory() || file.isDirectory() && jFileChooser.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(file));
            this.setFileSelected();
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent propertyChangeEvent) {
        this.applyEdit();
        File[] fileArray = (File[])propertyChangeEvent.getNewValue();
        JFileChooser jFileChooser = this.getFileChooser();
        if (fileArray != null && fileArray.length > 0 && (fileArray.length > 1 || jFileChooser.isDirectorySelectionEnabled() || !fileArray[0].isDirectory())) {
            this.setFileName(this.fileNameString(fileArray));
            this.setFileSelected();
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(string);
        }
    }

    protected ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(){

            public boolean isEnabled() {
                return MetalFileChooserUI.this.getFileChooser().isEnabled();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (MetalFileChooserUI.this.editFile != null) {
                    MetalFileChooserUI.this.cancelEdit();
                } else {
                    MetalFileChooserUI.this.getFileChooser().cancelSelection();
                }
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public MetalFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installComponents(JFileChooser jFileChooser) {
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        jFileChooser.setBorder(new EmptyBorder(12, 12, 11, 11));
        jFileChooser.setLayout(new BorderLayout(0, 11));
        JPanel jPanel = new JPanel(new BorderLayout(11, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel.add((Component)jPanel2, "After");
        jFileChooser.add((Component)jPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        jPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.getAccessibleContext().setAccessibleDescription(this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(jFileChooser);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(jFileChooser));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        jPanel.add((Component)this.directoryComboBox, "Center");
        JButton jButton = new JButton(this.getChangeToParentDirectoryAction());
        jButton.setText(null);
        jButton.setIcon(this.upFolderIcon);
        jButton.setToolTipText(this.upFolderToolTipText);
        jButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(hstrut5));
        File file = fileSystemView.getHomeDirectory();
        String string = this.homeFolderToolTipText;
        if (fileSystemView.isRoot(file)) {
            string = this.getFileView(jFileChooser).getName(file);
        }
        JButton jButton2 = new JButton(this.homeFolderIcon);
        jButton2.setToolTipText(string);
        jButton2.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jButton2.addActionListener(this.getGoHomeAction());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        jButton2 = new JButton(this.getNewFolderAction());
        jButton2.setText(null);
        jButton2.setIcon(this.newFolderIcon);
        jButton2.setToolTipText(this.newFolderToolTipText);
        jButton2.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        jButton2.setAlignmentX(0.0f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setMargin(shrinkwrap);
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(hstrut5));
        ButtonGroup buttonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;

            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JPanel jPanel = MetalFileChooserUI.this.currentViewPanel;
                if (jToggleButton == MetalFileChooserUI.this.detailsViewButton) {
                    if (MetalFileChooserUI.this.detailsViewPanel == null) {
                        MetalFileChooserUI.this.detailsViewPanel = MetalFileChooserUI.this.createDetailsView(this.fc);
                        MetalFileChooserUI.this.detailsViewPanel.setPreferredSize(LIST_PREF_SIZE);
                    }
                    MetalFileChooserUI.this.currentViewPanel = MetalFileChooserUI.this.detailsViewPanel;
                } else {
                    MetalFileChooserUI.this.currentViewPanel = MetalFileChooserUI.this.listViewPanel;
                }
                if (MetalFileChooserUI.this.currentViewPanel != jPanel) {
                    MetalFileChooserUI.this.centerPanel.remove(jPanel);
                    MetalFileChooserUI.this.centerPanel.add((Component)MetalFileChooserUI.this.currentViewPanel, "Center");
                    MetalFileChooserUI.this.centerPanel.revalidate();
                    MetalFileChooserUI.this.centerPanel.repaint();
                }
            }

            ViewButtonListener(JFileChooser jFileChooser) {
                this.fc = jFileChooser;
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(jFileChooser);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.listViewButton);
        buttonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        jPanel2.add(this.detailsViewButton);
        buttonGroup.add(this.detailsViewButton);
        this.updateUseShellFolder();
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(jFileChooser);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent jComponent = jFileChooser.getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add(jComponent);
        }
        jFileChooser.add((Component)this.centerPanel, "Center");
        JPanel jPanel3 = this.getBottomPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jFileChooser.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createRigidArea(vstrut5));
        AlignedLabel alignedLabel = new AlignedLabel(this.fileNameLabelText);
        alignedLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        jPanel4.add(alignedLabel);
        this.fileNameTextField = new JTextField(35){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        jPanel4.add(this.fileNameTextField);
        alignedLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (!MetalFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    MetalFileChooserUI.this.listSelectionModel.clearSelection();
                }
            }
        });
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(jFileChooser.getSelectedFile()));
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 2));
        jPanel3.add(jPanel5);
        AlignedLabel alignedLabel2 = new AlignedLabel(this.filesOfTypeLabelText);
        alignedLabel2.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        jPanel5.add(alignedLabel2);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        jFileChooser.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        this.filterComboBox.getAccessibleContext().setAccessibleDescription(this.filesOfTypeLabelText);
        alignedLabel2.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        jPanel5.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (jFileChooser.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        MetalFileChooserUI.groupLabels(new AlignedLabel[]{alignedLabel, alignedLabel2});
    }

    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected void installStrings(JFileChooser jFileChooser) {
        super.installStrings(jFileChooser);
        Locale locale = jFileChooser.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", locale);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", locale);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", locale);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", locale);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", locale);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", locale);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", locale);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", locale);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", locale);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", locale);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", locale);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", locale);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", locale);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", locale);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", locale);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", locale);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", locale);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", locale);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", locale);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
        this.getModel().validateFileCache();
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JFileChooser jFileChooser = this.getFileChooser();
        File file = jFileChooser.getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.fileNameString(file));
        }
    }

    private static void groupLabels(AlignedLabel[] alignedLabelArray) {
        for (int i2 = 0; i2 < alignedLabelArray.length; ++i2) {
            AlignedLabel.access$4002(alignedLabelArray[i2], alignedLabelArray);
        }
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n2 = MetalFileChooserUI.PREF_SIZE.width;
        Dimension dimension = jComponent.getLayout().preferredLayoutSize(jComponent);
        if (dimension != null) {
            return new Dimension(dimension.width < n2 ? n2 : dimension.width, dimension.height < MetalFileChooserUI.PREF_SIZE.height ? MetalFileChooserUI.PREF_SIZE.height : dimension.height);
        }
        return new Dimension(n2, MetalFileChooserUI.PREF_SIZE.height);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("SelectedFileChangedProperty")) {
                    MetalFileChooserUI.this.doSelectedFileChanged(propertyChangeEvent);
                } else if (string.equals("SelectedFilesChangedProperty")) {
                    MetalFileChooserUI.this.doSelectedFilesChanged(propertyChangeEvent);
                } else if (string.equals("directoryChanged")) {
                    MetalFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("fileFilterChanged")) {
                    MetalFileChooserUI.this.doFilterChanged(propertyChangeEvent);
                } else if (string.equals("fileSelectionChanged")) {
                    MetalFileChooserUI.this.doFileSelectionModeChanged(propertyChangeEvent);
                } else if (string.equals("MultiSelectionEnabledChangedProperty")) {
                    MetalFileChooserUI.this.doMultiSelectionChanged(propertyChangeEvent);
                } else if (string.equals("AccessoryChangedProperty")) {
                    MetalFileChooserUI.this.doAccessoryChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonTextChangedProperty") || string.equals("ApproveButtonToolTipTextChangedProperty")) {
                    MetalFileChooserUI.this.doApproveButtonTextChanged(propertyChangeEvent);
                } else if (string.equals("DialogTypeChangedProperty")) {
                    MetalFileChooserUI.this.doDialogTypeChanged(propertyChangeEvent);
                } else if (string.equals("ApproveButtonMnemonicChangedProperty")) {
                    MetalFileChooserUI.this.doApproveButtonMnemonicChanged(propertyChangeEvent);
                } else if (string.equals("ControlButtonsAreShownChangedProperty")) {
                    MetalFileChooserUI.this.doControlButtonsChanged(propertyChangeEvent);
                } else if (string.equals("CancelSelection")) {
                    MetalFileChooserUI.this.applyEdit();
                } else if (string.equals("componentOrientation")) {
                    ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                    JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                    if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                        jFileChooser.applyComponentOrientation(componentOrientation);
                    }
                    if (MetalFileChooserUI.this.detailsTable != null) {
                        MetalFileChooserUI.this.detailsTable.setComponentOrientation(componentOrientation);
                        MetalFileChooserUI.this.detailsTable.getParent().getParent().setComponentOrientation(componentOrientation);
                    }
                } else if (string == "FileChooser.useShellFolder") {
                    MetalFileChooserUI.this.updateUseShellFolder();
                    MetalFileChooserUI.this.doDirectoryChanged(propertyChangeEvent);
                } else if (string.equals("ancestor") && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() != null) {
                    MetalFileChooserUI.this.fileNameTextField.selectAll();
                    MetalFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
        this.ensureIndexIsVisible(this.getModel().indexOf(file));
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser jFileChooser = this.getFileChooser();
        if (jFileChooser.isDirectorySelectionEnabled() && !jFileChooser.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            if (fileArray.length > 1) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(this.fileNameString(fileArray[i2]));
            if (fileArray.length <= 1) continue;
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    protected JPanel createDetailsView(JFileChooser jFileChooser) {
        final JFileChooser jFileChooser2 = jFileChooser;
        JPanel jPanel = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(jFileChooser2);
        this.detailsTable = new JTable(detailsTableModel){

            protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
                if (keyEvent.getKeyCode() == 27 && this.getCellEditor() == null) {
                    jFileChooser2.dispatchEvent(keyEvent);
                    return true;
                }
                return super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
            }
        };
        this.detailsTable.setComponentOrientation(jFileChooser2.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel tableColumnModel = this.detailsTable.getColumnModel();
        TableColumn[] tableColumnArray = new TableColumn[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            tableColumnArray[i2] = tableColumnModel.getColumn(i2);
            tableColumnArray[i2].setPreferredWidth(this.COLUMN_WIDTHS[i2]);
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            tableColumnModel.removeColumn(tableColumnArray[2]);
            tableColumnModel.removeColumn(tableColumnArray[4]);
        }
        DetailsTableCellRenderer detailsTableCellRenderer = new DetailsTableCellRenderer(jFileChooser2);
        this.detailsTable.setDefaultRenderer(File.class, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(Date.class, detailsTableCellRenderer);
        this.detailsTable.setDefaultRenderer(Object.class, detailsTableCellRenderer);
        final JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.editorFocusListener);
        tableColumnArray[0].setCellEditor(new DefaultCellEditor(jTextField){

            public boolean isCellEditable(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n2 = MetalFileChooserUI.this.detailsTable.rowAtPoint(mouseEvent.getPoint());
                    return mouseEvent.getClickCount() == 1 && MetalFileChooserUI.this.detailsTable.isRowSelected(n2);
                }
                return super.isCellEditable(eventObject);
            }

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
                Component component = super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
                if (object instanceof File) {
                    jTextField.setText(jFileChooser2.getName((File)object));
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
                return component;
            }
        });
        JList jList = new JList(detailsTableModel.listModel){
            JTable table;

            public void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public void setDragEnabled(boolean bl2) {
                if (this.table != null) {
                    this.table.setDragEnabled(bl2);
                } else {
                    super.setDragEnabled(bl2);
                }
            }

            public int locationToIndex(Point point) {
                return this.table.rowAtPoint(point);
            }

            public Rectangle getCellBounds(int n2, int n3) {
                Rectangle rectangle = this.table.getCellRect(n2, 0, false);
                Rectangle rectangle2 = this.table.getCellRect(n3, 0, false);
                return rectangle.union(rectangle2);
            }

            public Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public void setTransferHandler(TransferHandler transferHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(transferHandler);
                } else {
                    super.setTransferHandler(transferHandler);
                }
            }

            public Component add(Component component) {
                if (component instanceof JTextField) {
                    return this.table.add(component);
                }
                return super.add(component);
            }
            {
                this.table = MetalFileChooserUI.this.detailsTable;
            }
        };
        jList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(jFileChooser2, jList));
        JScrollPane jScrollPane = new JScrollPane(this.detailsTable);
        jScrollPane.setComponentOrientation(jFileChooser2.getComponentOrientation());
        LookAndFeel.installColors(jScrollPane.getViewport(), "Table.background", "Table.foreground");
        jScrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JScrollPane jScrollPane = (JScrollPane)componentEvent.getComponent();
                MetalFileChooserUI.this.fixNameColumnWidth(jScrollPane.getViewport().getSize().width);
                jScrollPane.removeComponentListener(this);
            }
        });
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JPanel createList(JFileChooser jFileChooser) {
        JPanel jPanel = new JPanel(new BorderLayout());
        final JFileChooser jFileChooser2 = jFileChooser;
        this.list = new JList(){

            public int getNextMatch(String string, int n2, Position.Bias bias) {
                ListModel listModel = this.getModel();
                int n3 = listModel.getSize();
                if (string == null || n2 < 0 || n2 >= n3) {
                    throw new IllegalArgumentException();
                }
                boolean bl2 = bias == Position.Bias.Backward;
                int n4 = n2;
                while (bl2 ? n4 >= 0 : n4 < n3) {
                    String string2 = jFileChooser2.getName((File)listModel.getElementAt(n4));
                    if (string2.regionMatches(true, 0, string, 0, string.length())) {
                        return n4;
                    }
                    n4 += bl2 ? -1 : 1;
                }
                return -1;
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        if (jFileChooser.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(jFileChooser));
        this.list.addMouseListener(this.createDoubleClickListener(jFileChooser, this.list));
        this.list.addMouseListener(this.createSingleClickListener(jFileChooser, this.list));
        this.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new BasicFileChooserUI.SelectionListener(){

            /*
             * Enabled aggressive block sorting
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                File[] fileArray;
                JFileChooser jFileChooser;
                block7: {
                    int n2;
                    Object[] objectArray;
                    FileSystemView fileSystemView;
                    block9: {
                        JList jList;
                        block6: {
                            block8: {
                                if (listSelectionEvent.getValueIsAdjusting()) return;
                                jFileChooser = MetalFileChooserUI.this.getFileChooser();
                                fileSystemView = jFileChooser.getFileSystemView();
                                jList = (JList)listSelectionEvent.getSource();
                                if (!jFileChooser.isMultiSelectionEnabled()) break block6;
                                fileArray = null;
                                objectArray = jList.getSelectedValues();
                                if (objectArray == null) break block7;
                                if (objectArray.length != 1 || !((File)objectArray[0]).isDirectory() || !jFileChooser.isTraversable((File)objectArray[0])) break block8;
                                if (jFileChooser.getFileSelectionMode() != 0 && fileSystemView.isFileSystem((File)objectArray[0])) break block8;
                                MetalFileChooserUI.this.setDirectorySelected(true);
                                MetalFileChooserUI.this.setDirectory((File)objectArray[0]);
                                break block7;
                            }
                            fileArray = new File[objectArray.length];
                            n2 = 0;
                            break block9;
                        }
                        File file = (File)jList.getSelectedValue();
                        if (file != null && file.isDirectory() && jFileChooser.isTraversable(file)) {
                            if (jFileChooser.getFileSelectionMode() == 0 || !fileSystemView.isFileSystem(file)) {
                                MetalFileChooserUI.this.setDirectorySelected(true);
                                MetalFileChooserUI.this.setDirectory(file);
                                jFileChooser.setSelectedFile(null);
                                return;
                            }
                        }
                        MetalFileChooserUI.this.setDirectorySelected(false);
                        if (file == null) return;
                        jFileChooser.setSelectedFile(file);
                        return;
                    }
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        boolean bl2;
                        File file = (File)objectArray[i2];
                        boolean bl3 = file.isDirectory();
                        boolean bl4 = ShellFolder.disableFileChooserSpeedFix() ? file.isFile() : (bl2 = !bl3);
                        if ((!jFileChooser.isFileSelectionEnabled() || !bl2) && (!jFileChooser.isDirectorySelectionEnabled() || !fileSystemView.isFileSystem(file) || !bl3)) continue;
                        fileArray[n2++] = file;
                    }
                    if (n2 == 0) {
                        fileArray = null;
                    } else if (n2 < objectArray.length) {
                        File[] fileArray2 = new File[n2];
                        System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                        fileArray = fileArray2;
                    }
                    MetalFileChooserUI.this.setDirectorySelected(false);
                }
                jFileChooser.setSelectedFiles(fileArray);
            }
        };
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalFileChooserUI((JFileChooser)jComponent);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser jFileChooser) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser jFileChooser) {
        return new DirectoryComboBoxRenderer();
    }

    private MouseListener createSingleClickListener(JFileChooser jFileChooser, JList jList) {
        return new SingleClickListener(jList);
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth;

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int n2;
                int n3 = 0;
                for (n2 = 0; n2 < this.group.length; ++n2) {
                    n3 = Math.max(this.group[n2].getSuperPreferredWidth(), n3);
                }
                for (n2 = 0; n2 < this.group.length; ++n2) {
                    this.group[n2].maxWidth = n3;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, dimension.height);
        }

        AlignedLabel(String string) {
            super(string);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        static /* synthetic */ AlignedLabel[] access$4002(AlignedLabel alignedLabel, AlignedLabel[] alignedLabelArray) {
            alignedLabel.group = alignedLabelArray;
            return alignedLabelArray;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Component[] componentArray = container.getComponents();
            if (componentArray != null && componentArray.length > 0) {
                int n2;
                int n3;
                int n4 = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n4];
                Insets insets = container.getInsets();
                int n5 = insets.top + this.topMargin;
                int n6 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    dimensionArray[n3] = componentArray[n3].getPreferredSize();
                    n6 = Math.max(n6, dimensionArray[n3].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    n3 = container.getSize().width - insets.left - n6;
                    n2 = this.hGap + n6;
                } else {
                    n3 = insets.left;
                    n2 = -(this.hGap + n6);
                }
                for (int i2 = n4 - 1; i2 >= 0; --i2) {
                    componentArray[i2].setBounds(n3, n5, n6, dimensionArray[i2].height);
                    n3 -= n2;
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n2 = componentArray.length;
                int n3 = 0;
                Insets insets = container.getInsets();
                int n4 = this.topMargin + insets.top + insets.bottom;
                int n5 = insets.left + insets.right;
                int n6 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Dimension dimension = componentArray[i2].getPreferredSize();
                    n3 = Math.max(n3, dimension.height);
                    n6 = Math.max(n6, dimension.width);
                }
                return new Dimension(n5 + n2 * n6 + (n2 - 1) * this.hGap, n4 + n3);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        public void run() {
            MetalFileChooserUI.this.setFileSelected();
        }

        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        public void setValue(Object object) {
            this.setIcon(null);
            if (object instanceof File) {
                File file = (File)object;
                String string = this.chooser.getName(file);
                this.setText(string);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (object instanceof Date) {
                this.setText(object == null ? "" : this.df.format((Date)object));
            } else {
                super.setValue(object);
            }
        }

        DetailsTableCellRenderer(JFileChooser jFileChooser) {
            this.chooser = jFileChooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, jFileChooser.getLocale());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (n3 == 1 || n3 == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0;
        }

        public Class getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return class$java$io$File == null ? (class$java$io$File = MetalFileChooserUI.class$("java.io.File")) : class$java$io$File;
                }
                case 3: {
                    return class$java$util$Date == null ? (class$java$util$Date = MetalFileChooserUI.class$("java.util.Date")) : class$java$util$Date;
                }
            }
            return super.getColumnClass(n2);
        }

        public Object getValueAt(int n2, int n3) {
            File file = (File)this.listModel.getElementAt(n2);
            switch (n3) {
                case 0: {
                    return file;
                }
                case 1: {
                    if (!file.exists() || file.isDirectory()) {
                        return null;
                    }
                    long l2 = file.length() / 1024L;
                    if (l2 < 1024L) {
                        return (l2 == 0L ? 1L : l2) + " KB";
                    }
                    if ((l2 /= 1024L) < 1024L) {
                        return l2 + " MB";
                    }
                    return (l2 /= 1024L) + " GB";
                }
                case 2: {
                    if (!file.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(file);
                }
                case 3: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    long l3 = file.lastModified();
                    return l3 == 0L ? null : new Date(l3);
                }
                case 4: {
                    if (!file.exists() || this.chooser.getFileSystemView().isFileSystemRoot(file)) {
                        return null;
                    }
                    String string = "";
                    if (!file.canWrite()) {
                        string = string + "R";
                    }
                    if (file.isHidden()) {
                        string = string + "H";
                    }
                    return string;
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n2, int n3) {
            if (n3 == 0) {
                JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                File file = (File)this.getValueAt(n2, n3);
                if (file != null) {
                    String string = jFileChooser.getName(file);
                    String string2 = file.getName();
                    String string3 = ((String)object).trim();
                    if (!string3.equals(string)) {
                        FileSystemView fileSystemView;
                        File file2;
                        int n4;
                        String string4 = string3;
                        int n5 = string2.length();
                        if (n5 > (n4 = string.length()) && string2.charAt(n4) == '.') {
                            string4 = string3 + string2.substring(n4);
                        }
                        if (!(file2 = (fileSystemView = jFileChooser.getFileSystemView()).createFileObject(file.getParentFile(), string4)).exists() && MetalFileChooserUI.this.getModel().renameFile(file, file2) && fileSystemView.isParent(jFileChooser.getCurrentDirectory(), file2)) {
                            if (jFileChooser.isMultiSelectionEnabled()) {
                                jFileChooser.setSelectedFiles(new File[]{file2});
                            } else {
                                jFileChooser.setSelectedFile(file2);
                            }
                        }
                    }
                }
            }
        }

        public String getColumnName(int n2) {
            return this.columnNames[n2];
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableDataChanged();
        }

        DetailsTableModel(JFileChooser jFileChooser) {
            this.columnNames = new String[]{MetalFileChooserUI.this.fileNameHeaderText, MetalFileChooserUI.this.fileSizeHeaderText, MetalFileChooserUI.this.fileTypeHeaderText, MetalFileChooserUI.this.fileDateHeaderText, MetalFileChooserUI.this.fileAttrHeaderText};
            this.chooser = jFileChooser;
            this.listModel = MetalFileChooserUI.this.getModel();
            this.listModel.addListDataListener(this);
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            File file = (File)MetalFileChooserUI.this.directoryComboBox.getSelectedItem();
            MetalFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
        }

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = MetalFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public int getSize() {
            return this.directories.size();
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i2 = 0; i2 < this.depths.length; ++i2) {
                File file = (File)this.directories.get(i2);
                File file2 = file.getParentFile();
                this.depths[i2] = 0;
                if (file2 == null) continue;
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    if (!file2.equals((File)this.directories.get(i3))) continue;
                    this.depths[i2] = this.depths[i3] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int n2) {
            return this.depths != null && n2 >= 0 && n2 < this.depths.length ? this.depths[n2] : 0;
        }

        private void addItem(File file) {
            if (file == null) {
                return;
            }
            this.directories.clear();
            Object[] objectArray = MetalFileChooserUI.this.useShellFolder ? (File[])ShellFolder.get("fileChooserComboBoxFolders") : this.fsv.getRoots();
            this.directories.addAll(Arrays.asList(objectArray));
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file;
            }
            try {
                File file3;
                File file4 = file3 = MetalFileChooserUI.this.useShellFolder ? ShellFolder.getShellFolder(file2) : file2;
                Vector vector = new Vector(10);
                do {
                    vector.addElement(file4);
                } while ((file4 = file4.getParentFile()) != null);
                int n2 = vector.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    file4 = (File)vector.get(i2);
                    if (!this.directories.contains(file4)) continue;
                    int n3 = this.directories.indexOf(file4);
                    for (int i3 = i2 - 1; i3 >= 0; --i3) {
                        this.directories.insertElementAt(vector.get(i3), n3 + i2 - i3);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(file3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.calculateDepths();
            }
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public Object getElementAt(int n2) {
            return this.directories.elementAt(n2);
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged(this, -1, -1);
        }

        public DirectoryComboBoxModel() {
            File file = MetalFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.addItem(file);
            }
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            Icon icon;
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object == null) {
                this.setText("");
                return this;
            }
            File file = (File)object;
            this.setText(MetalFileChooserUI.this.getFileChooser().getName(file));
            this.ii.icon = icon = MetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.ii.depth = MetalFileChooserUI.this.directoryComboBoxModel.getDepth(n2);
            this.setIcon(this.ii);
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MetalFileChooserUI.this.applyEdit();
        }

        EditActionListener() {
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            File file = (File)object;
            String string = MetalFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = MetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (bl2) {
                MetalFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (string == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = MetalFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl2 = false;
            if (fileFilter != null) {
                for (int i2 = 0; i2 < this.filters.length; ++i2) {
                    if (this.filters[i2] != fileFilter) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    MetalFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return MetalFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public Object getElementAt(int n2) {
            if (n2 > this.getSize() - 1) {
                return MetalFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n2];
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                MetalFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                MetalFileChooserUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        protected FilterComboBoxModel() {
            this.filters = MetalFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent(jList, object, n2, bl2, bl3);
            if (object != null && object instanceof FileFilter) {
                this.setText(((FileFilter)object).getDescription());
            }
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        IndentIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (component.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(component, graphics, n2 + this.depth * 10, n3);
            } else {
                this.icon.paintIcon(component, graphics, n2, n3);
            }
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() == 1) {
                    JFileChooser jFileChooser = MetalFileChooserUI.this.getFileChooser();
                    int n2 = this.list.locationToIndex(mouseEvent.getPoint());
                    if ((!jFileChooser.isMultiSelectionEnabled() || jFileChooser.getSelectedFiles().length <= 1) && n2 >= 0 && this.list.isSelectedIndex(n2) && MetalFileChooserUI.this.getEditIndex() == n2 && MetalFileChooserUI.this.editFile == null) {
                        MetalFileChooserUI.this.editFileName(n2);
                    } else if (n2 >= 0) {
                        MetalFileChooserUI.this.setEditIndex(n2);
                    } else {
                        MetalFileChooserUI.this.resetEditIndex();
                    }
                } else {
                    MetalFileChooserUI.this.resetEditIndex();
                }
            }
        }

        public SingleClickListener(JList jList) {
            this.list = jList;
        }
    }
}

