/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.security.AccessController;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalFontDesktopProperty;
import javax.swing.plaf.metal.MetalHighContrastTheme;
import javax.swing.plaf.metal.MetalTheme;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;

public class MetalLookAndFeel
extends BasicLookAndFeel {
    private static boolean METAL_LOOK_AND_FEEL_INITED = false;
    private static MetalTheme currentTheme;
    private static boolean isOnlyOneContext;
    private static AppContext cachedAppContext;
    private static boolean checkedWindows;
    private static boolean isWindows;
    private static boolean checkedSystemFontSettings;
    private static boolean useSystemFonts;

    static {
        isOnlyOneContext = true;
    }

    protected void createDefaultTheme() {
        MetalLookAndFeel.getCurrentTheme();
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    static boolean isWindows() {
        if (!checkedWindows) {
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string != null && string.indexOf("Windows") != -1) {
                isWindows = true;
                String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
                useSystemFonts = string2 != null && Boolean.valueOf(string2) != false;
            }
            checkedWindows = true;
        }
        return isWindows;
    }

    private static boolean useHighContrastTheme() {
        if (MetalLookAndFeel.isWindows() && MetalLookAndFeel.useSystemFonts()) {
            Boolean bl2 = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on");
            return bl2 == null ? false : bl2;
        }
        return false;
    }

    static boolean useSystemFonts() {
        if (MetalLookAndFeel.isWindows() && useSystemFonts) {
            if (METAL_LOOK_AND_FEEL_INITED) {
                Object object = UIManager.get("Application.useSystemFontSettings");
                return object == null || Boolean.TRUE.equals(object);
            }
            return true;
        }
        return false;
    }

    public void provideErrorFeedback(Component component) {
        super.provideErrorFeedback(component);
    }

    public String getDescription() {
        return "The Java(tm) Look and Feel";
    }

    public String getID() {
        return "Metal";
    }

    public String getName() {
        return "Metal";
    }

    public UIDefaults getDefaults() {
        METAL_LOOK_AND_FEEL_INITED = true;
        this.createDefaultTheme();
        UIDefaults uIDefaults = super.getDefaults();
        currentTheme.addCustomEntriesToTable(uIDefaults);
        currentTheme.install();
        return uIDefaults;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "javax.swing.plaf.metal.";
        Object[] objectArray = new Object[]{"ButtonUI", string + "MetalButtonUI", "CheckBoxUI", string + "MetalCheckBoxUI", "ComboBoxUI", string + "MetalComboBoxUI", "DesktopIconUI", string + "MetalDesktopIconUI", "FileChooserUI", string + "MetalFileChooserUI", "InternalFrameUI", string + "MetalInternalFrameUI", "LabelUI", string + "MetalLabelUI", "PopupMenuSeparatorUI", string + "MetalPopupMenuSeparatorUI", "ProgressBarUI", string + "MetalProgressBarUI", "RadioButtonUI", string + "MetalRadioButtonUI", "ScrollBarUI", string + "MetalScrollBarUI", "ScrollPaneUI", string + "MetalScrollPaneUI", "SeparatorUI", string + "MetalSeparatorUI", "SliderUI", string + "MetalSliderUI", "SplitPaneUI", string + "MetalSplitPaneUI", "TabbedPaneUI", string + "MetalTabbedPaneUI", "TextFieldUI", string + "MetalTextFieldUI", "ToggleButtonUI", string + "MetalToggleButtonUI", "ToolBarUI", string + "MetalToolBarUI", "ToolTipUI", string + "MetalToolTipUI", "TreeUI", string + "MetalTreeUI", "RootPaneUI", string + "MetalRootPaneUI"};
        uIDefaults.putDefaults(objectArray);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.initResourceBundle(uIDefaults);
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getTextFieldBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue2 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getTextBorder");
        MetalLazyValue metalLazyValue = new MetalLazyValue("javax.swing.plaf.metal.MetalBorders$DialogBorder");
        MetalLazyValue metalLazyValue2 = new MetalLazyValue("javax.swing.plaf.metal.MetalBorders$QuestionDialogBorder");
        UIDefaults.LazyInputMap lazyInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap lazyInputMap2 = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        UIDefaults.ProxyLazyValue proxyLazyValue3 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$ScrollPaneBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue4 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getButtonBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue5 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getToggleButtonBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue6 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{uIDefaults.getColor("controlShadow")});
        UIDefaults.ProxyLazyValue proxyLazyValue7 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders", "getDesktopIconBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue8 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$MenuBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue9 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$PopupMenuBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue10 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$MenuItemBorder");
        String string = new String("-");
        UIDefaults.ProxyLazyValue proxyLazyValue11 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$ToolBarBorder");
        UIDefaults.ProxyLazyValue proxyLazyValue12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getControlDarkShadow(), new Integer(1)});
        UIDefaults.ProxyLazyValue proxyLazyValue13 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getPrimaryControlDarkShadow()});
        UIDefaults.ProxyLazyValue proxyLazyValue14 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getControlDarkShadow()});
        UIDefaults.ProxyLazyValue proxyLazyValue15 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource$LineBorderUIResource", new Object[]{MetalLookAndFeel.getFocusColor()});
        InsetsUIResource insetsUIResource = new InsetsUIResource(4, 2, 0, 6);
        InsetsUIResource insetsUIResource2 = new InsetsUIResource(0, 9, 1, 9);
        InsetsUIResource insetsUIResource3 = new InsetsUIResource(0, 0, 0, 0);
        Object[] objectArray = new Object[]{new Integer(16)};
        Object[] objectArray2 = new Object[]{"OptionPane.errorSound", "OptionPane.informationSound", "OptionPane.questionSound", "OptionPane.warningSound"};
        MetalTheme metalTheme = MetalLookAndFeel.getCurrentTheme();
        FontActiveValue fontActiveValue = new FontActiveValue(metalTheme, 3);
        FontActiveValue fontActiveValue2 = new FontActiveValue(metalTheme, 0);
        FontActiveValue fontActiveValue3 = new FontActiveValue(metalTheme, 2);
        FontActiveValue fontActiveValue4 = new FontActiveValue(metalTheme, 4);
        FontActiveValue fontActiveValue5 = new FontActiveValue(metalTheme, 5);
        FontActiveValue fontActiveValue6 = new FontActiveValue(metalTheme, 1);
        Object[] objectArray3 = new Object[]{"AuditoryCues.defaultCueList", objectArray2, "AuditoryCues.playList", null, "TextField.border", proxyLazyValue, "TextField.font", fontActiveValue3, "PasswordField.border", proxyLazyValue2, "PasswordField.font", fontActiveValue3, "TextArea.font", fontActiveValue3, "TextPane.background", uIDefaults.get("window"), "TextPane.font", fontActiveValue3, "EditorPane.background", uIDefaults.get("window"), "EditorPane.font", fontActiveValue3, "TextField.focusInputMap", lazyInputMap, "PasswordField.focusInputMap", lazyInputMap, "TextArea.focusInputMap", lazyInputMap2, "TextPane.focusInputMap", lazyInputMap2, "EditorPane.focusInputMap", lazyInputMap2, "FormattedTextField.border", proxyLazyValue, "FormattedTextField.font", fontActiveValue3, "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Button.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "Button.select", MetalLookAndFeel.getControlShadow(), "Button.border", proxyLazyValue4, "Button.font", fontActiveValue2, "Button.focus", MetalLookAndFeel.getFocusColor(), "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "Checkbox.select", MetalLookAndFeel.getControlShadow(), "CheckBox.font", fontActiveValue2, "CheckBox.focus", MetalLookAndFeel.getFocusColor(), "CheckBox.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getCheckBoxIcon"), "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButton.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "RadioButton.select", MetalLookAndFeel.getControlShadow(), "RadioButton.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getRadioButtonIcon"), "RadioButton.font", fontActiveValue2, "RadioButton.focus", MetalLookAndFeel.getFocusColor(), "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToggleButton.select", MetalLookAndFeel.getControlShadow(), "ToggleButton.disabledText", MetalLookAndFeel.getInactiveControlTextColor(), "ToggleButton.focus", MetalLookAndFeel.getFocusColor(), "ToggleButton.border", proxyLazyValue5, "ToggleButton.font", fontActiveValue2, "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "FileView.directoryIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "FileView.fileIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "FileView.computerIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeComputerIcon"), "FileView.hardDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeHardDriveIcon"), "FileView.floppyDriveIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFloppyDriveIcon"), "FileChooser.detailsViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserDetailViewIcon"), "FileChooser.homeFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserHomeFolderIcon"), "FileChooser.listViewIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserListViewIcon"), "FileChooser.newFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserNewFolderIcon"), "FileChooser.upFolderIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getFileChooserUpFolderIcon"), "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"}), "ToolTip.font", fontActiveValue6, "ToolTip.border", proxyLazyValue13, "ToolTip.borderInactive", proxyLazyValue14, "ToolTip.backgroundInactive", uIDefaults.get("control"), "ToolTip.foregroundInactive", uIDefaults.get("controlDkShadow"), "ToolTip.hideAccelerator", Boolean.FALSE, "Slider.border", null, "Slider.foreground", MetalLookAndFeel.getPrimaryControlShadow(), "Slider.focus", MetalLookAndFeel.getFocusColor(), "Slider.focusInsets", insetsUIResource3, "Slider.trackWidth", new Integer(7), "Slider.majorTickLength", new Integer(6), "Slider.horizontalThumbIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getHorizontalSliderThumbIcon"), "Slider.verticalThumbIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getVerticalSliderThumbIcon"), "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "ctrl PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "ctrl PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ProgressBar.font", fontActiveValue2, "ProgressBar.foreground", MetalLookAndFeel.getPrimaryControlShadow(), "ProgressBar.selectionBackground", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ProgressBar.border", proxyLazyValue12, "ProgressBar.cellSpacing", new Integer(0), "ProgressBar.cellLength", new Integer(1), "ComboBox.background", uIDefaults.get("control"), "ComboBox.foreground", uIDefaults.get("controlText"), "ComboBox.selectionBackground", MetalLookAndFeel.getPrimaryControlShadow(), "ComboBox.selectionForeground", MetalLookAndFeel.getControlTextColor(), "ComboBox.font", fontActiveValue2, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "InternalFrame.icon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameDefaultMenuIcon"), "InternalFrame.border", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$InternalFrameBorder"), "InternalFrame.optionDialogBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$OptionDialogBorder"), "InternalFrame.paletteBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$PaletteBorder"), "InternalFrame.paletteTitleHeight", new Integer(11), "InternalFrame.paletteCloseIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory$PaletteCloseIcon"), "InternalFrame.closeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameCloseIcon", objectArray), "InternalFrame.maximizeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameMaximizeIcon", objectArray), "InternalFrame.iconifyIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameMinimizeIcon", objectArray), "InternalFrame.minimizeIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getInternalFrameAltMaximizeIcon", objectArray), "InternalFrame.titleFont", fontActiveValue4, "InternalFrame.windowBindings", null, "InternalFrame.closeSound", "sounds/FrameClose.wav", "InternalFrame.maximizeSound", "sounds/FrameMaximize.wav", "InternalFrame.minimizeSound", "sounds/FrameMinimize.wav", "InternalFrame.restoreDownSound", "sounds/FrameRestoreDown.wav", "InternalFrame.restoreUpSound", "sounds/FrameRestoreUp.wav", "DesktopIcon.border", proxyLazyValue7, "DesktopIcon.font", fontActiveValue2, "DesktopIcon.foreground", MetalLookAndFeel.getControlTextColor(), "DesktopIcon.background", MetalLookAndFeel.getControl(), "DesktopIcon.width", new Integer(160), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "shift RIGHT", "shrinkRight", "shift KP_RIGHT", "shrinkRight", "LEFT", "left", "KP_LEFT", "left", "shift LEFT", "shrinkLeft", "shift KP_LEFT", "shrinkLeft", "UP", "up", "KP_UP", "up", "shift UP", "shrinkUp", "shift KP_UP", "shrinkUp", "DOWN", "down", "KP_DOWN", "down", "shift DOWN", "shrinkDown", "shift KP_DOWN", "shrinkDown", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}), "TitledBorder.font", fontActiveValue2, "TitledBorder.titleColor", MetalLookAndFeel.getSystemTextColor(), "TitledBorder.border", proxyLazyValue6, "Label.font", fontActiveValue2, "Label.foreground", MetalLookAndFeel.getSystemTextColor(), "Label.disabledForeground", MetalLookAndFeel.getInactiveSystemTextColor(), "List.font", fontActiveValue2, "List.focusCellHighlightBorder", proxyLazyValue15, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection"}), "ScrollBar.background", MetalLookAndFeel.getControl(), "ScrollBar.highlight", MetalLookAndFeel.getControlHighlight(), "ScrollBar.shadow", MetalLookAndFeel.getControlShadow(), "ScrollBar.darkShadow", MetalLookAndFeel.getControlDarkShadow(), "ScrollBar.thumb", MetalLookAndFeel.getPrimaryControlShadow(), "ScrollBar.thumbShadow", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ScrollBar.thumbHighlight", MetalLookAndFeel.getPrimaryControl(), "ScrollBar.width", new Integer(17), "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.border", proxyLazyValue3, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "TabbedPane.font", fontActiveValue2, "TabbedPane.tabAreaBackground", MetalLookAndFeel.getControl(), "TabbedPane.background", MetalLookAndFeel.getControlShadow(), "TabbedPane.light", MetalLookAndFeel.getControl(), "TabbedPane.focus", MetalLookAndFeel.getPrimaryControlDarkShadow(), "TabbedPane.selected", MetalLookAndFeel.getControl(), "TabbedPane.selectHighlight", MetalLookAndFeel.getControlHighlight(), "TabbedPane.tabAreaInsets", insetsUIResource, "TabbedPane.tabInsets", insetsUIResource2, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Table.font", fontActiveValue3, "Table.focusCellHighlightBorder", proxyLazyValue15, "Table.scrollPaneBorder", proxyLazyValue3, "Table.gridColor", MetalLookAndFeel.getControlShadow(), "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}), "TableHeader.font", fontActiveValue3, "TableHeader.cellBorder", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalBorders$TableHeaderBorder"), "MenuBar.border", proxyLazyValue8, "MenuBar.font", fontActiveValue, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "Menu.border", proxyLazyValue10, "Menu.borderPainted", Boolean.TRUE, "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(-4), "Menu.submenuPopupOffsetY", new Integer(-3), "Menu.font", fontActiveValue, "Menu.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "Menu.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "Menu.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "Menu.acceleratorFont", fontActiveValue5, "Menu.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "Menu.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "Menu.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemCheckIcon"), "Menu.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuArrowIcon"), "MenuItem.border", proxyLazyValue10, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.font", fontActiveValue, "MenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "MenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "MenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "MenuItem.acceleratorFont", fontActiveValue5, "MenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "MenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "MenuItem.acceleratorDelimiter", string, "MenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemCheckIcon"), "MenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "MenuItem.commandSound", "sounds/MenuItemCommand.wav", "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.informationSound", "sounds/OptionPaneInformation.wav", "OptionPane.warningSound", "sounds/OptionPaneWarning.wav", "OptionPane.errorSound", "sounds/OptionPaneError.wav", "OptionPane.questionSound", "sounds/OptionPaneQuestion.wav", "OptionPane.errorDialog.border.background", new ColorUIResource(153, 51, 51), "OptionPane.errorDialog.titlePane.foreground", new ColorUIResource(51, 0, 0), "OptionPane.errorDialog.titlePane.background", new ColorUIResource(255, 153, 153), "OptionPane.errorDialog.titlePane.shadow", new ColorUIResource(204, 102, 102), "OptionPane.questionDialog.border.background", new ColorUIResource(51, 102, 51), "OptionPane.questionDialog.titlePane.foreground", new ColorUIResource(0, 51, 0), "OptionPane.questionDialog.titlePane.background", new ColorUIResource(153, 204, 153), "OptionPane.questionDialog.titlePane.shadow", new ColorUIResource(102, 153, 102), "OptionPane.warningDialog.border.background", new ColorUIResource(153, 102, 51), "OptionPane.warningDialog.titlePane.foreground", new ColorUIResource(102, 51, 0), "OptionPane.warningDialog.titlePane.background", new ColorUIResource(255, 204, 153), "OptionPane.warningDialog.titlePane.shadow", new ColorUIResource(204, 153, 102), "Separator.background", MetalLookAndFeel.getSeparatorBackground(), "Separator.foreground", MetalLookAndFeel.getSeparatorForeground(), "PopupMenu.border", proxyLazyValue9, "PopupMenu.popupSound", "sounds/PopupMenuPopup.wav", "PopupMenu.font", fontActiveValue, "CheckBoxMenuItem.border", proxyLazyValue10, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.font", fontActiveValue, "CheckBoxMenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "CheckBoxMenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "CheckBoxMenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "CheckBoxMenuItem.acceleratorFont", fontActiveValue5, "CheckBoxMenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "CheckBoxMenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "CheckBoxMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getCheckBoxMenuItemIcon"), "CheckBoxMenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "CheckBoxMenuItem.commandSound", "sounds/MenuItemCommand.wav", "RadioButtonMenuItem.border", proxyLazyValue10, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.font", fontActiveValue, "RadioButtonMenuItem.selectionForeground", MetalLookAndFeel.getMenuSelectedForeground(), "RadioButtonMenuItem.selectionBackground", MetalLookAndFeel.getMenuSelectedBackground(), "RadioButtonMenuItem.disabledForeground", MetalLookAndFeel.getMenuDisabledForeground(), "RadioButtonMenuItem.acceleratorFont", fontActiveValue5, "RadioButtonMenuItem.acceleratorForeground", MetalLookAndFeel.getAcceleratorForeground(), "RadioButtonMenuItem.acceleratorSelectionForeground", MetalLookAndFeel.getAcceleratorSelectedForeground(), "RadioButtonMenuItem.checkIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getRadioButtonMenuItemIcon"), "RadioButtonMenuItem.arrowIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getMenuItemArrowIcon"), "RadioButtonMenuItem.commandSound", "sounds/MenuItemCommand.wav", "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.arrowButtonInsets", new Insets(0, 0, 0, 0), "Spinner.border", proxyLazyValue, "Spinner.arrowButtonBorder", proxyLazyValue4, "Spinner.font", fontActiveValue2, "SplitPane.dividerSize", new Integer(10), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "Tree.font", fontActiveValue3, "Tree.textBackground", MetalLookAndFeel.getWindowBackground(), "Tree.selectionBorderColor", MetalLookAndFeel.getFocusColor(), "Tree.openIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "Tree.closedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeFolderIcon"), "Tree.leafIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeLeafIcon"), "Tree.expandedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{false}), "Tree.collapsedIcon", new UIDefaults.ProxyLazyValue("javax.swing.plaf.metal.MetalIconFactory", "getTreeControlIcon", new Object[]{true}), "Tree.line", MetalLookAndFeel.getPrimaryControl(), "Tree.hash", MetalLookAndFeel.getPrimaryControl(), "Tree.rowHeight", new Integer(0), "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "ToolBar.border", proxyLazyValue11, "ToolBar.background", MetalLookAndFeel.getMenuBackground(), "ToolBar.foreground", MetalLookAndFeel.getMenuForeground(), "ToolBar.font", fontActiveValue, "ToolBar.dockingBackground", MetalLookAndFeel.getMenuBackground(), "ToolBar.floatingBackground", MetalLookAndFeel.getMenuBackground(), "ToolBar.dockingForeground", MetalLookAndFeel.getPrimaryControlDarkShadow(), "ToolBar.floatingForeground", MetalLookAndFeel.getPrimaryControl(), "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "RootPane.frameBorder", new MetalLazyValue("javax.swing.plaf.metal.MetalBorders$FrameBorder"), "RootPane.plainDialogBorder", metalLazyValue, "RootPane.informationDialogBorder", metalLazyValue, "RootPane.errorDialogBorder", new MetalLazyValue("javax.swing.plaf.metal.MetalBorders$ErrorDialogBorder"), "RootPane.colorChooserDialogBorder", metalLazyValue2, "RootPane.fileChooserDialogBorder", metalLazyValue2, "RootPane.questionDialogBorder", metalLazyValue2, "RootPane.warningDialogBorder", new MetalLazyValue("javax.swing.plaf.metal.MetalBorders$WarningDialogBorder"), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}};
        uIDefaults.putDefaults(objectArray3);
        if (MetalLookAndFeel.isWindows() && MetalLookAndFeel.useSystemFonts() && metalTheme.isSystemTheme()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            MetalFontDesktopProperty metalFontDesktopProperty = new MetalFontDesktopProperty("win.messagebox.font.height", toolkit, 0);
            objectArray3 = new Object[]{"OptionPane.messageFont", metalFontDesktopProperty, "OptionPane.buttonFont", metalFontDesktopProperty};
            uIDefaults.putDefaults(objectArray3);
        }
    }

    private void initResourceBundle(UIDefaults uIDefaults) {
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.metal.resources.metal");
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"desktop", MetalLookAndFeel.getDesktopColor(), "activeCaption", MetalLookAndFeel.getWindowTitleBackground(), "activeCaptionText", MetalLookAndFeel.getWindowTitleForeground(), "activeCaptionBorder", MetalLookAndFeel.getPrimaryControlShadow(), "inactiveCaption", MetalLookAndFeel.getWindowTitleInactiveBackground(), "inactiveCaptionText", MetalLookAndFeel.getWindowTitleInactiveForeground(), "inactiveCaptionBorder", MetalLookAndFeel.getControlShadow(), "window", MetalLookAndFeel.getWindowBackground(), "windowBorder", MetalLookAndFeel.getControl(), "windowText", MetalLookAndFeel.getUserTextColor(), "menu", MetalLookAndFeel.getMenuBackground(), "menuText", MetalLookAndFeel.getMenuForeground(), "text", MetalLookAndFeel.getWindowBackground(), "textText", MetalLookAndFeel.getUserTextColor(), "textHighlight", MetalLookAndFeel.getTextHighlightColor(), "textHighlightText", MetalLookAndFeel.getHighlightedTextColor(), "textInactiveText", MetalLookAndFeel.getInactiveSystemTextColor(), "control", MetalLookAndFeel.getControl(), "controlText", MetalLookAndFeel.getControlTextColor(), "controlHighlight", MetalLookAndFeel.getControlHighlight(), "controlLtHighlight", MetalLookAndFeel.getControlHighlight(), "controlShadow", MetalLookAndFeel.getControlShadow(), "controlDkShadow", MetalLookAndFeel.getControlDarkShadow(), "scrollbar", MetalLookAndFeel.getControl(), "info", MetalLookAndFeel.getPrimaryControl(), "infoText", MetalLookAndFeel.getPrimaryControlInfo()};
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            uIDefaults.put((String)objectArray[i2], objectArray[i2 + 1]);
        }
    }

    public static ColorUIResource getAcceleratorForeground() {
        return MetalLookAndFeel.getCurrentTheme().getAcceleratorForeground();
    }

    public static ColorUIResource getAcceleratorSelectedForeground() {
        return MetalLookAndFeel.getCurrentTheme().getAcceleratorSelectedForeground();
    }

    public static ColorUIResource getBlack() {
        return MetalLookAndFeel.getCurrentTheme().getBlack();
    }

    public static ColorUIResource getControl() {
        return MetalLookAndFeel.getCurrentTheme().getControl();
    }

    public static ColorUIResource getControlDarkShadow() {
        return MetalLookAndFeel.getCurrentTheme().getControlDarkShadow();
    }

    public static ColorUIResource getControlDisabled() {
        return MetalLookAndFeel.getCurrentTheme().getControlDisabled();
    }

    public static ColorUIResource getControlHighlight() {
        return MetalLookAndFeel.getCurrentTheme().getControlHighlight();
    }

    public static ColorUIResource getControlInfo() {
        return MetalLookAndFeel.getCurrentTheme().getControlInfo();
    }

    public static ColorUIResource getControlShadow() {
        return MetalLookAndFeel.getCurrentTheme().getControlShadow();
    }

    public static ColorUIResource getControlTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getControlTextColor();
    }

    public static ColorUIResource getDesktopColor() {
        return MetalLookAndFeel.getCurrentTheme().getDesktopColor();
    }

    public static ColorUIResource getFocusColor() {
        return MetalLookAndFeel.getCurrentTheme().getFocusColor();
    }

    public static ColorUIResource getHighlightedTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getHighlightedTextColor();
    }

    public static ColorUIResource getInactiveControlTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getInactiveControlTextColor();
    }

    public static ColorUIResource getInactiveSystemTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getInactiveSystemTextColor();
    }

    public static ColorUIResource getMenuBackground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuBackground();
    }

    public static ColorUIResource getMenuDisabledForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuDisabledForeground();
    }

    public static ColorUIResource getMenuForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuForeground();
    }

    public static ColorUIResource getMenuSelectedBackground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuSelectedBackground();
    }

    public static ColorUIResource getMenuSelectedForeground() {
        return MetalLookAndFeel.getCurrentTheme().getMenuSelectedForeground();
    }

    public static ColorUIResource getPrimaryControl() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControl();
    }

    public static ColorUIResource getPrimaryControlDarkShadow() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlDarkShadow();
    }

    public static ColorUIResource getPrimaryControlHighlight() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlHighlight();
    }

    public static ColorUIResource getPrimaryControlInfo() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlInfo();
    }

    public static ColorUIResource getPrimaryControlShadow() {
        return MetalLookAndFeel.getCurrentTheme().getPrimaryControlShadow();
    }

    public static ColorUIResource getSeparatorBackground() {
        return MetalLookAndFeel.getCurrentTheme().getSeparatorBackground();
    }

    public static ColorUIResource getSeparatorForeground() {
        return MetalLookAndFeel.getCurrentTheme().getSeparatorForeground();
    }

    public static ColorUIResource getSystemTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getSystemTextColor();
    }

    public static ColorUIResource getTextHighlightColor() {
        return MetalLookAndFeel.getCurrentTheme().getTextHighlightColor();
    }

    public static ColorUIResource getUserTextColor() {
        return MetalLookAndFeel.getCurrentTheme().getUserTextColor();
    }

    public static ColorUIResource getWhite() {
        return MetalLookAndFeel.getCurrentTheme().getWhite();
    }

    public static ColorUIResource getWindowBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowBackground();
    }

    public static ColorUIResource getWindowTitleBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleBackground();
    }

    public static ColorUIResource getWindowTitleForeground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleForeground();
    }

    public static ColorUIResource getWindowTitleInactiveBackground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleInactiveBackground();
    }

    public static ColorUIResource getWindowTitleInactiveForeground() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleInactiveForeground();
    }

    public static FontUIResource getControlTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getControlTextFont();
    }

    public static FontUIResource getMenuTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getMenuTextFont();
    }

    public static FontUIResource getSubTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getSubTextFont();
    }

    public static FontUIResource getSystemTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getSystemTextFont();
    }

    public static FontUIResource getUserTextFont() {
        return MetalLookAndFeel.getCurrentTheme().getUserTextFont();
    }

    public static FontUIResource getWindowTitleFont() {
        return MetalLookAndFeel.getCurrentTheme().getWindowTitleFont();
    }

    private static MetalTheme getCurrentTheme() {
        AppContext appContext = AppContext.getAppContext();
        if (cachedAppContext != appContext) {
            currentTheme = (MetalTheme)appContext.get("currentMetalTheme");
            if (currentTheme == null) {
                currentTheme = MetalLookAndFeel.useHighContrastTheme() ? new MetalHighContrastTheme() : new DefaultMetalTheme();
                MetalLookAndFeel.setCurrentTheme(currentTheme);
            }
            cachedAppContext = appContext;
        }
        return currentTheme;
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        if (metalTheme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = metalTheme;
        cachedAppContext = AppContext.getAppContext();
        cachedAppContext.put("currentMetalTheme", metalTheme);
    }

    private static class FontActiveValue
    implements UIDefaults.ActiveValue {
        private int type;
        private MetalTheme theme;

        FontActiveValue(MetalTheme metalTheme, int n2) {
            this.theme = metalTheme;
            this.type = n2;
        }

        public Object createValue(UIDefaults uIDefaults) {
            FontUIResource fontUIResource = null;
            switch (this.type) {
                case 0: {
                    fontUIResource = this.theme.getControlTextFont();
                    break;
                }
                case 1: {
                    fontUIResource = this.theme.getSystemTextFont();
                    break;
                }
                case 2: {
                    fontUIResource = this.theme.getUserTextFont();
                    break;
                }
                case 3: {
                    fontUIResource = this.theme.getMenuTextFont();
                    break;
                }
                case 4: {
                    fontUIResource = this.theme.getWindowTitleFont();
                    break;
                }
                case 5: {
                    fontUIResource = this.theme.getSubTextFont();
                }
            }
            return fontUIResource;
        }
    }

    private static class MetalLazyValue
    implements UIDefaults.LazyValue {
        private String className;

        MetalLazyValue(String string) {
            this.className = string;
        }

        public Object createValue(UIDefaults uIDefaults) {
            try {
                Class clazz = Class.forName(this.className);
                return clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }
    }
}

