/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder;
import sun.security.action.LoadLibraryAction;

public class Win32ShellFolderManager
extends ShellFolderManager {
    private static Win32ShellFolder desktop;
    private static Win32ShellFolder drives;
    private static Win32ShellFolder recent;
    private static Win32ShellFolder network;
    private static Win32ShellFolder personal;
    private static String osName;
    private static boolean isXP;
    private static File[] roots;
    private Comparator driveComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ShellFolder)object).getPath().compareTo(((ShellFolder)object2).getPath());
        }
    };
    private Comparator fileComparator = new Comparator(){

        public int compare(File file, File file2) {
            Win32ShellFolder win32ShellFolder = null;
            Win32ShellFolder win32ShellFolder2 = null;
            if (file instanceof Win32ShellFolder && (win32ShellFolder = (Win32ShellFolder)file).getPIDL() != 0L) {
                win32ShellFolder = null;
            }
            if (file2 instanceof Win32ShellFolder && (win32ShellFolder2 = (Win32ShellFolder)file2).getPIDL() != 0L) {
                win32ShellFolder2 = null;
            }
            if (win32ShellFolder != null && win32ShellFolder2 != null) {
                return win32ShellFolder.compareTo(win32ShellFolder2);
            }
            if (win32ShellFolder != null) {
                return -1;
            }
            if (win32ShellFolder2 != null) {
                return 1;
            }
            String string = file.getName();
            String string2 = file2.getName();
            int n2 = string.toLowerCase().compareTo(string2.toLowerCase());
            if (n2 != 0) {
                return n2;
            }
            return string.compareTo(string2);
        }

        public int compare(Object object, Object object2) {
            return this.compare((File)object, (File)object2);
        }
    };

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        osName = System.getProperty("os.name");
        isXP = osName != null && osName.startsWith("Windows XP");
    }

    public boolean isComputerNode(File file) {
        if (file != null && file.equals(Win32ShellFolderManager.getDrives())) {
            return true;
        }
        String string = file.getAbsolutePath();
        return string.startsWith("\\\\") && string.indexOf("\\", 2) < 0;
    }

    public boolean isFileSystemRoot(File file) {
        if (file != null) {
            Object object;
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDrives();
            if (file instanceof Win32ShellFolder) {
                object = (Win32ShellFolder)file;
                if (((Win32ShellFolder)object).isFileSystem()) {
                    if (((Win32ShellFolder)object).parent != null) {
                        return ((Win32ShellFolder)object).parent.equals(win32ShellFolder);
                    }
                } else {
                    return false;
                }
            }
            return ((String)(object = file.getPath())).length() == 3 && ((String)object).charAt(1) == ':' && Arrays.asList(win32ShellFolder.listFiles()).contains(file);
        }
        return false;
    }

    public void sortFiles(List list) {
        Collections.sort(list, this.fileComparator);
    }

    static Win32ShellFolder getDesktop() {
        if (desktop == null) {
            try {
                desktop = new Win32ShellFolder(null, 0);
            }
            catch (IOException iOException) {
                desktop = null;
            }
        }
        return desktop;
    }

    static Win32ShellFolder getDrives() {
        if (drives == null) {
            try {
                drives = new Win32ShellFolder((ShellFolder)Win32ShellFolderManager.getDesktop(), 17);
            }
            catch (IOException iOException) {
                drives = null;
            }
        }
        return drives;
    }

    static Win32ShellFolder getNetwork() {
        if (network == null) {
            try {
                network = new Win32ShellFolder((ShellFolder)Win32ShellFolderManager.getDesktop(), 18);
            }
            catch (IOException iOException) {
                network = null;
            }
        }
        return network;
    }

    static Win32ShellFolder getPersonal() {
        if (personal == null) {
            try {
                String string = Win32ShellFolder.getFileSystemPath(5);
                if (string != null && (personal = Win32ShellFolderManager.getDesktop().getChildByPath(string)) == null) {
                    personal = new Win32ShellFolder(null, string);
                }
            }
            catch (IOException iOException) {
                personal = null;
            }
        }
        return personal;
    }

    static Win32ShellFolder getRecent() {
        if (recent == null) {
            try {
                String string = Win32ShellFolder.getFileSystemPath(8);
                if (string != null) {
                    recent = new Win32ShellFolder(null, string);
                }
            }
            catch (IOException iOException) {
                recent = null;
            }
        }
        return recent;
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getPersonal();
            if (win32ShellFolder == null) {
                win32ShellFolder = Win32ShellFolderManager.getDesktop();
            }
            return win32ShellFolder;
        }
        if (string.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDesktop();
                roots = win32ShellFolder != null ? new File[]{win32ShellFolder} : (File[])super.get(string);
            }
            return roots;
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDesktop();
            if (win32ShellFolder != null) {
                ArrayList arrayList = new ArrayList();
                Win32ShellFolder win32ShellFolder2 = Win32ShellFolderManager.getDrives();
                arrayList.add(win32ShellFolder);
                Object[] objectArray = win32ShellFolder.listFiles();
                Arrays.sort(objectArray);
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    Object[] objectArray2;
                    Win32ShellFolder win32ShellFolder3 = (Win32ShellFolder)objectArray[i2];
                    if (win32ShellFolder3.getPIDL() != 0L && !win32ShellFolder3.isDirectory()) continue;
                    arrayList.add(win32ShellFolder3);
                    if (!win32ShellFolder3.equals(win32ShellFolder2) || (objectArray2 = win32ShellFolder3.listFiles()) == null) continue;
                    Arrays.sort(objectArray2, this.driveComparator);
                    for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                        arrayList.add(objectArray2[i3]);
                    }
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            return super.get(string);
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            File[] fileArray = new File[]{Win32ShellFolderManager.getRecent(), Win32ShellFolderManager.getDesktop(), Win32ShellFolderManager.getPersonal(), Win32ShellFolderManager.getDrives(), Win32ShellFolderManager.getNetwork()};
            ArrayList arrayList = new ArrayList();
            for (int i4 = 0; i4 < fileArray.length; ++i4) {
                if (fileArray[i4] == null) continue;
                arrayList.add(fileArray[i4]);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        if (string.startsWith("fileChooserIcon ")) {
            int n2;
            block17: {
                n2 = -1;
                String string2 = string.substring(string.indexOf(" ") + 1);
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.equals("ListView")) {
                        n2 = isXP ? 21 : 2;
                    }
                    if (string2.equals("DetailsView")) {
                        n2 = isXP ? 23 : 3;
                    }
                    if (string2.equals("UpFolder")) {
                        n2 = isXP ? 28 : 8;
                    }
                    if (!string2.equals("NewFolder")) break block17;
                    int n3 = n2 = isXP ? 31 : 11;
                }
            }
            if (n2 >= 0) {
                return Win32ShellFolder.getFileChooserIcon(n2);
            }
        }
        return null;
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new Win32ShellFolder(null, file);
    }
}

