/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.RemoteProxy;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final Log serverRefLog = Log.getLog("sun.rmi.server.ref", "transport", RemoteProxy.logLevel);
    public static final boolean logCalls;
    public static final Log callLog;
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog;
    private static final boolean suppressStackTraces;
    private transient Skeleton skel;
    private transient Map methodTable = null;
    private static Map methodTableCache;
    private static Map withoutSkeletons;
    static /* synthetic */ Class class$java$rmi$Remote;

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
        logCalls = bl2;
        callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
        wantExceptionLog = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
        suppressStackTraces = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
        methodTableCache = new WeakHashMap(11);
        withoutSkeletons = Collections.synchronizedMap(new WeakHashMap(11));
    }

    public UnicastServerRef() {
    }

    public UnicastServerRef(int n2) {
        super(new LiveRef(n2));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    private static long computeMethodHash(Method method) {
        long l2 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            String string = UnicastServerRef.getMethodNameAndDescriptor(method);
            if (serverRefLog.isLoggable(Log.VERBOSE)) {
                serverRefLog.log(Log.VERBOSE, "string used for method hash: \"" + string + "\"");
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i2 = 0; i2 < Math.min(8, byArray.length); ++i2) {
                l2 += (long)(byArray[i2] & 0xFF) << i2 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    private static String getTypeDescriptor(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private static String getMethodNameAndDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append('(');
        Class[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(classArray[i2]));
        }
        stringBuffer.append(')');
        Class clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(clazz));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void dispatch(Remote var1_1, RemoteCall var2_2) throws IOException {
        try {
            var6_3 = var2_2.getInputStream();
            var3_6 = var6_3.readInt();
            if (var3_6 < 0) ** GOTO lbl10
            if (this.skel != null) {
                this.oldDispatch(var1_1, var2_2, var3_6);
                return;
            }
            try {
                throw new UnmarshalException("skeleton class not found but required for client version");
lbl10:
                // 1 sources

                var4_7 = var6_3.readLong();
            }
            catch (Exception var7_8) {
                throw new UnmarshalException("error unmarshalling call header", var7_8);
            }
            var7_9 = (MarshalInputStream)var6_3;
            var7_9.skipDefaultResolveClass();
            var8_11 = (Method)this.methodTable.get(new Long(var4_7));
            if (var8_11 == null) {
                throw new UnmarshalException("invalid method hash");
            }
            this.logCall(var1_1, var8_11);
            var9_12 = var8_11.getParameterTypes();
            var10_13 = new Object[var9_12.length];
            try {
                this.unmarshalCustomCallData(var6_3);
                for (var11_14 = 0; var11_14 < var9_12.length; ++var11_14) {
                    var10_13[var11_14] = UnicastServerRef.unmarshalValue(var9_12[var11_14], var6_3);
                }
            }
            catch (IOException var11_15) {
                throw new UnmarshalException("error unmarshalling arguments", var11_15);
            }
            catch (ClassNotFoundException var11_16) {
                throw new UnmarshalException("error unmarshalling arguments", var11_16);
            }
            finally {
                var2_2.releaseInputStream();
            }
            try {
                var11_17 = var8_11.invoke(var1_1, var10_13);
            }
            catch (InvocationTargetException var12_19) {
                throw var12_19.getTargetException();
            }
            try {
                var12_20 = var2_2.getResultStream(true);
                var13_22 = var8_11.getReturnType();
                if (var13_22 != Void.TYPE) {
                    UnicastServerRef.marshalValue(var13_22, var11_17, var12_20);
                }
            }
            catch (IOException var12_21) {
                throw new MarshalException("error marshalling return", var12_21);
            }
        }
        catch (Throwable var6_4) {
            this.logCallException(var6_4);
            var7_10 = var2_2.getResultStream(false);
            if (var6_4 instanceof Error) {
                var6_5 /* !! */  = new ServerError("Error occurred in server thread", (Error)var6_4);
            } else if (var6_4 instanceof RemoteException) {
                var6_5 /* !! */  = new ServerException("RemoteException occurred in server thread", (Exception)var6_4);
            }
            if (UnicastServerRef.suppressStackTraces) {
                UnicastServerRef.clearStackTraces(var6_5 /* !! */ );
            }
            var7_10.writeObject(var6_5 /* !! */ );
        }
        finally {
            var2_2.releaseInputStream();
            var2_2.releaseOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n2) throws IOException {
        try {
            long l2;
            ObjectInput objectInput;
            try {
                objectInput = remoteCall.getInputStream();
                l2 = objectInput.readLong();
            }
            catch (Exception exception) {
                throw new UnmarshalException("error unmarshalling call header", exception);
            }
            this.logCall(remote, this.skel.getOperations()[n2]);
            this.unmarshalCustomCallData(objectInput);
            this.skel.dispatch(remote, remoteCall, n2, l2);
        }
        catch (Throwable throwable) {
            RemoteException remoteException;
            this.logCallException(throwable);
            ObjectOutput objectOutput = remoteCall.getResultStream(false);
            if (throwable instanceof Error) {
                remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
            } else if (throwable instanceof RemoteException) {
                remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
            }
            if (suppressStackTraces) {
                UnicastServerRef.clearStackTraces(remoteException);
            }
            objectOutput.writeObject(remoteException);
        }
        finally {
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
        }
    }

    public RemoteStub setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = RemoteProxy.getSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
        return RemoteProxy.getStub(remote, this.getClientRef());
    }

    private static Map createMethodTable(Class clazz) {
        HashMap hashMap = new HashMap(11);
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class[] classArray = clazz2.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if (!(class$java$rmi$Remote == null ? UnicastServerRef.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[i2])) continue;
                Method[] methodArray = classArray[i2].getMethods();
                for (int i3 = 0; i3 < methodArray.length; ++i3) {
                    final Method method = methodArray[i3];
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                    long l2 = UnicastServerRef.computeMethodHash(method);
                    hashMap.put(new Long(l2), method);
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getMethodTable(Class clazz) {
        SoftReference[] softReferenceArray = methodTableCache;
        synchronized (methodTableCache) {
            SoftReference[] softReferenceArray2 = (SoftReference[])methodTableCache.get(clazz);
            if (softReferenceArray2 == null) {
                softReferenceArray2 = new SoftReference[]{null};
                methodTableCache.put(clazz, softReferenceArray2);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            softReferenceArray = softReferenceArray2;
            synchronized (softReferenceArray2) {
                Map map = null;
                if (softReferenceArray2[0] != null) {
                    map = (Map)softReferenceArray2[0].get();
                }
                if (map == null) {
                    map = UnicastServerRef.createMethodTable(clazz);
                    softReferenceArray2[0] = new SoftReference(map);
                }
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return map;
            }
        }
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        return this.exportObject(remote, object, false);
    }

    public RemoteStub exportObject(Remote remote, Object object, boolean bl2) throws RemoteException {
        RemoteStub remoteStub = this.setSkeleton(remote);
        Target target = new Target(remote, this, remoteStub, this.ref.getObjID(), bl2);
        this.ref.exportObject(target);
        this.methodTable = UnicastServerRef.getMethodTable(remote.getClass());
        return remoteStub;
    }
}

