/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.UID;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import sun.rmi.transport.DGCImpl;
import sun.security.action.GetLongAction;

public class DGCAckHandler {
    private static final long dgcAckTimeout = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.ackTimeout", 300000L));
    private static final Map idTable = Collections.synchronizedMap(new HashMap(11));
    private final UID id;
    private List objList = new ArrayList();
    private final TimerTask timerTask = new TimerTask(){

        public void run() {
            DGCAckHandler.received(DGCAckHandler.this.id);
        }
    };

    synchronized void startTimer() {
        if (this.objList != null) {
            DGCImpl.timer.schedule(this.timerTask, dgcAckTimeout);
        }
    }

    synchronized void add(Object object) {
        if (this.objList != null) {
            this.objList.add(object);
        }
    }

    DGCAckHandler(UID uID) {
        this.id = uID;
        idTable.put(uID, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void received(UID uID) {
        DGCAckHandler dGCAckHandler = (DGCAckHandler)idTable.remove(uID);
        if (dGCAckHandler != null) {
            DGCAckHandler dGCAckHandler2 = dGCAckHandler;
            synchronized (dGCAckHandler2) {
                dGCAckHandler.timerTask.cancel();
                dGCAckHandler.objList = null;
            }
        }
    }
}

