/******************************************
DUCK PUNT
Copyright (C) 2005 Geoffrey M. Draper

This file is part of Duck Punt.
Duck Punt is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************/

import java.applet.*;
import java.net.*;

public class SoundEffects
{
	public static int KICK_SOUND = 0;
	public static int SLIP_SOUND = 1;
	public static int FALL_SOUND = 2;
	public static int CHEER_SOUND = 3;
	public static int WHISTLE_SOUND = 4;
	private static boolean soundEnabled;
	
	private static AudioClip clip[];
	
	private SoundEffects() {}
	
	public static void init()
	{
		soundEnabled = true;
		String prefix = "file:" + System.getProperty("user.dir") + "/data/audio/";
		clip = new AudioClip[5];
		try {
			clip[KICK_SOUND] = Applet.newAudioClip(new URL(prefix + "cartoonhammer.wav"));
			clip[SLIP_SOUND] = Applet.newAudioClip(new URL(prefix + "cartoonsplit.wav"));
			clip[FALL_SOUND] = Applet.newAudioClip(new URL(prefix + "fall2.wav"));
			clip[CHEER_SOUND] = Applet.newAudioClip(new URL(prefix + "crowdcheersmall.wav"));
			clip[WHISTLE_SOUND] = Applet.newAudioClip(new URL(prefix + "whistleshort.wav"));
		} catch (MalformedURLException e) {
			System.err.println(e.getMessage());
		}		
	}

	public static void play(int sound)
	{
		if (soundEnabled) {
			clip[sound].play();
		}
	}
	
	public static boolean enabled() {
		return soundEnabled;
	}
	
	public static void toggleSound() {
		soundEnabled = !soundEnabled;
	}

}
