/******************************************
DUCK PUNT
Copyright (C) 2005 Geoffrey M. Draper

This file is part of Duck Punt.
Duck Punt is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
******************************************/

import javax.swing.*;
import java.awt.*;
import java.util.Date;

/* Adapted from an online tutorial by Tony Colston
 * http://www.javaworld.com/javaworld/javatips/jw-javatip104.html
 */

class SplashScreen extends JWindow
{
		Date timeSplashScreenStarted;

    public SplashScreen()
    {
        JLabel l = new JLabel(new ImageIcon("data/images/splash.gif"));
        getContentPane().add(l, BorderLayout.CENTER);
        pack();
        Dimension screenSize =
          Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        setLocation(screenSize.width/2 - (labelSize.width/2),
                    screenSize.height/2 - (labelSize.height/2));
        setVisible(true);
        screenSize = null;
        labelSize = null;
				timeSplashScreenStarted = new Date();
    }
		
		public void close()
		{
			setVisible(false);
			dispose();
		}
		
		public void closeAfterAppropriateTimeout(long timeout)
		{
			while ((new Date().getTime()) - timeSplashScreenStarted.getTime() < timeout)
			{
				DuckPunt.pause(500);
			}
			close();		
		}
}
