/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#ifndef GAMEDATA
#define GAMEDATA

#include "myavatarsprite.h"
#include "myflashingsignsprite.h"
#include "mybankersprite.h"
#include "mycanvas.h"
#include <qiconview.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qstring.h>
#include <qpointarray.h>
#include <qvector.h>
#include <qsound.h>

#define NUM_OBJECTS 12
#define NUM_ROOMS 9

//class Memento;
//class GameState;

class GameData {

	public:
	static GameData* instance(QIconView *iv, MyCanvas *mv);
	~GameData();

	/*Memento* createMemento();
	Memento* createEmptyMemento();
	void setMemento(const Memento*);*/

	/*this sprite contains all the animated frames for our main character
	at first, this is just Tux, but later, it will be boys and girls
	of all races*/
	MyAvatarSprite *avatar;
	int avatarDir;	//0=front_left, 1=left, 2=front_right, 3=right, 4=back
	QPoint *avatarDestination;

	QCanvasSprite *catSprite;
	QCanvasSprite *blackDoor;
	QCanvasSprite *carrotSprite;
	MyBankerSprite *banker;
	MyFlashingSignSprite *flashingSign;

	typedef enum {
		BANK,
		GREEN_ROOM,
		CAT_ROOM,
		WHITE_ROOM,
		GOLD_ROOM,
		HOT_ROOM,
		OFFICE,
		MILK_ROOM,
		STORE
	} RoomID;

	typedef enum {
		MAP,			//might get rid of this
		CHULA,
		COUPON,
		EMPTY_BOWL,
		COLD_MILK,
		WARM_MILK,
		CATALOG,		//will probably get rid of this
		MAGAZINE,
		EGG,
		JEWEL,
		COIN,
		VASE
	} ObjID;

	typedef enum {
		DO_NOTHING,
		TRYING_LOCKED_DOOR,
		TRYING_LEFT_CHAIR,
		TRYING_MIDDLE_CHAIR,
		TRYING_RIGHT_CHAIR,
		TRYING_OFFICE_CHAIR,
		FILLING_BOWL,
		DEPOSITING_COUPON,
		PICKING_UP_MAGAZINE,
		FEEDING_NELLAN_COLD_MILK,
		FEEDING_NELLAN_WARM_MILK,
		DEPOSITING_EGG,
		DEPOSITING_JEWEL,
		DEPOSITING_COIN,
		DEPOSITING_VASE//,
	} PendingActionID;

	/*
		Room 0: Bank
		Room 1: Green Room
		Room 2: Cat Room
		Room 3: White Room
		Room 4: Gold Room
		Room 5: Hot Room
		Room 6: Office
		Room 7: Milk Room
		Room 8: Store
	*/

	typedef struct {
		QPointArray *perimeter;			//used to figure 'hot spots' where avatar transitions from one room to the next
		QPointArray *largePerimeter;	//used to figure where user can click on a door
		int room;
		QPoint *newPos;					//where the player starts in the next room 
		QPoint *target;					//if user clicks anywhere on door, go here
	} PassageWay;

	typedef struct {
		QPixmap *roomImage;
		QString roomName;
		QPointArray *perimeter;				//used to figure where avatar can walk
		QPointArray *largePerimeter;		//used to figure where user can click
		QArray<PassageWay> passageway;		//used to figure where avatar can go
		int numPassages;
		bool visited;
	} RoomData;

	/*
		0: Map - we might get rid of this
		1: Chula - starts out in White Room
		2: Coupon - starts out in Hot Room
		3: Empty Bowl - found in Store
		4: Filled Bowl - found in Milk Room
		5: College Catalog - we might get rid of this
		6: Magazine - starts out in Office
		7: Egg - found in Gold Room
		8: Jewel - starts out in Store
		9: Coin - starts out in Green Room
		10: Vase - found in Cat Room
	*/

	typedef struct {
		QCanvasSprite *largeIcon;
		QIconViewItem *smallIcon;
		QPixmap *smallPixmap;
		QBitmap *smallIconMask;
		QString name;
		int value;
		int location;	//-1 = in inventory; -2 = nonexistant; 0-8 = in a room
		bool isTreasure;
		int pointsAwarded;
	} ObjectData;

	RoomData roomData[NUM_ROOMS];
	ObjectData objectData[NUM_OBJECTS];
	int pendingAction;	//a "pending action" is a delayed action that takes place
						//after the player has walked to a certain spot

	int currentRoom;	//room where player is currently in
	int currentObject;	//object currently in player's hand
	bool carrotsEaten;	//has the big pile of carrots been eaten?
	bool dialogVisible;	//is there a dialog box visible?
	int stepValue;		//how many pixels does avatar move each step?

	int score;
	bool isSound;		//speech enabled?
	bool isMusic;		//music enabled?

	void playSound(QString filename);

protected:
	GameData(QIconView *iv, MyCanvas *mv);

private:
	static GameData* _instance;
#ifdef _WS_X11_
	int soundStrategy;
#endif
	//GameState* _state;
};

#endif	//GAMEDATA
