#include "memento.h"
#include "gamestate.h"
#include <qtextstream.h>
#include <iostream.h>

Memento::Memento() {
	_state = new GameState;
}

Memento::~Memento() {
	delete _state;
}

void Memento::setState(GameState *s) {
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		_state->objectLocation[i] = s->objectLocation[i];
		_state->objectX[i] = s->objectX[i];
		_state->objectY[i] = s->objectY[i];
		_state->objectPointsAwarded[i] = s->objectPointsAwarded[i];
	}
	for (i=0; i<NUM_ROOMS; i++) {
		_state->roomVisited[i] = s->roomVisited[i];
	}
	_state->avatarX = s->avatarX;
	_state->avatarY = s->avatarY;
	_state->currentRoom = s->currentRoom;
	//_state->currentObject = s->currentObject;
	_state->carrotsEaten = s->carrotsEaten;
	_state->score = s->score;
	_state->isSound = s->isSound;
	_state->isMusic = s->isMusic;
}

GameState* Memento::getState() {
	return _state;
}

void Memento::writeStateToFile(QTextStream *ts) {
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		*ts << QString::number(_state->objectLocation[i]) << '\n';
		*ts << QString::number(_state->objectX[i]) << '\n';
		*ts << QString::number(_state->objectY[i]) << '\n';
		*ts << QString::number(_state->objectPointsAwarded[i])  << '\n';
	}
	for (i=0; i<NUM_ROOMS; i++) {
		*ts << QString::number((int)_state->roomVisited[i]) << '\n';
	}
	*ts << QString::number(_state->avatarX) << '\n';
	*ts << QString::number(_state->avatarY) << '\n';
	*ts << QString::number(_state->currentRoom) << '\n';
	*ts << QString::number((int)_state->carrotsEaten) << '\n';
	*ts << QString::number(_state->score) << '\n';
	*ts << QString::number((int)_state->isSound) << '\n';
	*ts << QString::number((int)_state->isMusic) << '\n';
}

void Memento::readStateFromFile(QTextStream *ts) {
	QString s;
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		s = ts->readLine();
		_state->objectLocation[i] = s.toInt();
		s = ts->readLine();
		_state->objectX[i] = s.toInt();
		s = ts->readLine();
		_state->objectY[i] = s.toInt();
		s = ts->readLine();
		_state->objectPointsAwarded[i] = s.toInt();
	}
	for (i=0; i<NUM_ROOMS; i++) {
		s = ts->readLine();
		_state->roomVisited[i] = s.toInt();
	}
	s = ts->readLine();
	_state->avatarX = s.toInt();
	s = ts->readLine();
	_state->avatarY = s.toInt();
	s = ts->readLine();
	_state->currentRoom = s.toInt();
	//s = ts->readLine();
	//_state->currentObject = s.toInt();
	s = ts->readLine();
	_state->carrotsEaten = s.toInt();
	s = ts->readLine();
	_state->score = s.toInt();
	s = ts->readLine();
	_state->isSound = s.toInt();
	s = ts->readLine();
	_state->isMusic = s.toInt();
}
