#include "mycanvassprite.h"
#include "gamedata.h"
#include <iostream.h>

extern GameData *gd;

MyCanvasSprite::MyCanvasSprite( QCanvasPixmapArray *a, MyCanvas *can, int type)
						: QCanvasSprite(a, can)
{
	//gd = gamedata;
	spriteType = /*(SpriteType)*/type;
	//type =1, avatar
	//type 2, flashing sign
	//connect(this, SIGNAL(roomChanged()), this->canvas(), SIGNAL(roomChanged()));
	//myCanvas = new MyCanvas(this->canvas());
	myCanvas = can;

}	
	
void MyCanvasSprite::advance(int stage) {
	//int f=1;
	if (animated()) {
		if (stage == 1) {
			moveBy(xVelocity(), yVelocity());

			switch (spriteType) {
				case 0:
				//do nothing
				break;

				case 1://avatar
				//advance frame
				if (xVelocity() != 0 || yVelocity() != 0) {
					switch(gd->avatarDir) {
						//f = frame();
						case 0:
						setFrame((frame()+1) % 2);
						break;

						case 1:
						setFrame(2 + ((frame()+1) % 4));
						break;

						case 2:
						setFrame(6 + ((frame()+1) % 2));
						break;

						case 3:
						setFrame(8 + ((frame()+1) % 4));
						break;

						case 4:
						setFrame(12 + ((frame()+1) % 4));
						break;
					}
				}

				//check to see if player is on the floor
				if (isInsidePerimeter(gd->roomData[gd->currentRoom].perimeter)) {
					//check to see if player is in a doorway
					for (int i=0; i < gd->roomData[gd->currentRoom].numPassages; i++) {
						if (isInsidePerimeter((gd->roomData[gd->currentRoom].passageway[i]).perimeter)) {
							setX(gd->roomData[gd->currentRoom].passageway[i].newPos->x());
							setY(gd->roomData[gd->currentRoom].passageway[i].newPos->y());
							gd->currentRoom = gd->roomData[gd->currentRoom].passageway[i].room;
							myCanvas->emitRoomChanged();
						}
					}
					myCanvas->update();
				} else {
					moveBy(-xVelocity(), -yVelocity());
					setVelocity(0,0);
				}
				break;


			}
		}
	}
}

int MyCanvasSprite::isInsidePerimeter(QPointArray *p) {
	//adapted from http://astronomy.swin.edu.au/pbourke/geometry/insidepoly/
	//by Randolph Franklin
	int i, j, c = 0;
	int npol = p->size();
	int xx = (int)x();
	int yy = (int)y();
	QPoint *pi, *pj;
	//what, you expected this code to make SENSE ?
	for (i = 0, j = npol-1; i < npol; j = i++) {
		pi = new QPoint(p->point(i));
		pj = new QPoint(p->point(j));
		if ((((pi->y() <= yy) && (yy < pj->y() )) || ((pj->y() <= yy) && (yy < pi->y() ))) &&
			(xx < (pj->x() - pi->x()) * (yy - pi->y() ) / (pj->y() - pi->y() ) + pi->x() ))
				c = !c;
	}
	return c;
}
