/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#ifndef MY_CANVAS_VIEW_H
#define MY_CANVAS_VIEW_H

#include <qcanvas.h>

class GameData;
class QEvent;
class InfoBox;

class MyCanvasView : public QCanvasView
{
	Q_OBJECT
public:
	MyCanvasView( QCanvas *viewing=0, QWidget *parent=0/*GameData *gd=0*/);
	void moveAvatar(int x, int y);
	int isInsidePerimeter(int xx, int yy, QPointArray *p);

signals:
	void inventoryItemAdded(int id);
	void inventoryItemRemoved(int id);
	void currentObjectDropped();
	void roomChanged();
	void scoreChanged();

protected:	
	void contentsMousePressEvent(QMouseEvent* e);
	void keyPressEvent( QKeyEvent *k );
	void wheelEvent( QWheelEvent *e );

private:
	InfoBox *ib;

};

#endif
