/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include <qtextview.h>
#include "aboutbox.h"

AboutBox::AboutBox(QWidget *parent) : QTabDialog(parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu) {
	setCaption("About Thirsty Nellan");
	connect(this, SIGNAL(applyButtonPressed()), this, SLOT(accept()));
	QTextView *history = new QTextView(this);
	QTextView *license = new QTextView(this);
	QTextView *thanks = new QTextView(this);
	history->setMinimumSize(360,300);
	history->setText(			"THIRSTY NELLAN is based upon the old text adventure\n"
						"game, \"Nellan is Thirsty\" by Dr. Furman H. Smith.\n"
						"\"Nellan is Thirsty\" was originally published in the\n"
						"July/August 1980 issue of the magazine \"Recreational Computing.\"\n"
						"The game was originally created for the TRS-80 computer,\n"
						"but it was subsequently ported to the Commodore 64 by\n"
						"Steven Darnold, a programmer from New Zealand.  The\n"
						"Commodore version of \"Nellan is Thirsty\" was very\n"
						"widespread, and made its way into nearly every collection\n"
						"of public domain C-64 software.  Sadly, as the C-64 computer\n"
						"fell from popularity, \"Nellan is Thirsty\" also faded\n"
						"into obscurity.\n"
						"\"Nellan is Thirsty\" has historical significance in\n"
						"that it was the first text adventure game written\n"
						"specifically for children.  This re-adaptation of\n"
						"\"Nellan is Thirsty\" marks an new milestone\n"
						"in computer adventure game history.  Not only was\n"
						"\"Nellan is Thirsty\" the first adventure game for children,\n"
						"but now it is the first text adventure game ever to\n"
						"be completely rewritten with a modern graphical user\n"
						"interface.\n" );
	license->setText(			"THIRSTY NELLAN\n"
						"(C)2002 Geoffrey M. Draper\n"
						"This program is free software; you can redistribute it\n"
						"and/or modify it under the terms of the GNU General Public\n"
						"License as published by the Free Software Foundation;\n"
						"either version 2 of the License, or (at your option)\n"
						"any later version.\n"
						"As a special exception, the copyright holder (Geoffrey\n"
						"M. Draper) gives permission to link this program with\n"
						"Qt non-commercial edition, and distribute the resulting\n"
						"executable, without including the source code for the\n"
						"Qt non-commercial edition in the source distribution.\n"
						"(This clause applies only to Windows version of the\n"
						"software.)\n"
						"This program is distributed in the hope that it will be\n"
						"useful, but WITHOUT ANY WARRANTY; without even the\n"
						"implied warranty of MERCHANTABILITY or FITNESS FOR A\n"
						"PARTICULAR PURPOSE. See the GNU General Public License\n"
						"for more details.\n"
						"You should have received a copy of the GNU General\n"
						"Public License along with this program; if not,\n"
						"write to the\n"
						"Free Software Foundation, Inc.\n"
						"59 Temple Place - Suite 330\n"
						"Boston, MA 02111-1307, USA.");
	thanks->setText(	"***************************************************************\n"
						"                             In Memory Of\n"
						"                         Robert Lynn Draper\n"
						"                31 July 1970 - 11 December 2002\n"
						"***************************************************************\n\n"
						"THIRSTY NELLAN\n"
						"Programmer/Lead Artist: Geoffrey Draper\n"
						"Featuring the voice talents of:\n"
						"Jared Tarnasky (Narrator/Banker)\n"
						"Sarah Gordon (Chula the Rabbit)\n"		
						"Angelea McGarrah (Nellan the Cat)\n"
						"I am grateful to Dr. Furman H. Smith, who wrote the\n"
						"\"Nellan is Thirsty\" program, without which this\n"
						"present game would (of course) not have been written.\n"
						"I am also grateful to Steven Darnold who ported the\n"
						"game to the Commodore 64, otherwise I would not have\n"
						"ever come into contact with it.\n"
						"The nine rooms, as well as many of the objects in the\n"
						"game, were modeled and rendered in Maya 4\n"
						"(from Alias|Wavefront) on Silicon Graphics O2 workstations.\n"
						"The animated penguin sprite was borrowed directly from\n"
						"the game \"Tux Typing\".\nhttp://www.geekcomix.com/dm/tuxtype/\n"
						"I am grateful to Sam Hart for making these images available\n"
						"for use in other free software projects.\n"
						"The penguin, of course, is based on Tux the Linux penguin,\n"
						"designed by Larry Ewing.\nhttp://www.isc.tamu.edu/~lewing/linux/\n"
						"The jewel image used in this game was borrowed from KSokoban,\n"
						"part of the KDE games package.\nhttp://www.kde.org/\n"
						"The woodgrain texture maps used in several of the rooms are\n"
						"copyrighted by IconBazaar, used by permission.\nhttp://www.iconbazaar.com/\n"
						"The floral texture maps used in the White Room and Cat Room\n"
						"are copyrighted by Pat's Web Graphics, used by permission.\n"
						"http://www.patswebgraphics.com/\n"
						"The floor and wall textures in the Store and the Green Room,\n"
						"as well as the chair textures in the Green Room and Office,\n"
						"are copyrighted by \"The Big Waste of Space,\" used by permission.\n"
						"http://www.bigwaste.com/\n"
						"The portrait of Brigham Young on the wall in the Bank was\n"
						"borrowed from http://www.lds.org/ .\n"
						"The drawing of the bowl and pitcher that appears on the splash\n"
						"screen was drawn by the staff of \"Recreational Computing\" and\n"
						"originally appeared in the July/August 1980 issue, along with\n"
						"the source code of the \"Nellan is Thirsty\" text adventure.\n"
						"Other artwork, such as the carrots, the rabbit, the cat, and\n"
						"the cow on the wall in the Milk Room were hand-drawn by myself.\n"
						"Nearly all the graphics in this game were manipulated to some extent\n"
						"in The GIMP.\nhttp://www.gimp.org/\n"
						"Most of the audio clips used herein were edited using \"Ace of WAV\"\n"
						"(evaluation version) from Polyhedric Software.  I heartily recommend\n"
						"this product (and even registering it) for anyone who needs an\n"
						"intuituve WAV-file-editing package for long-term use.\n"
						"This program was written using the excellent Qt GUI toolkit\n"
						"from Trolltech.  I am grateful to Trolltech for making Qt\n"
						"available free-of-charge for non-commercial open-source usage.\n"
						"http://www.trolltech.com/\n"
											
						);
						
	addTab(history, "History");
	addTab(license, "Copyright");
	addTab(thanks, "Thanks to");

}
