/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

/****************************************************************
**
** MAIN WINDOW FOR NELLAN IS THIRSTY
**
****************************************************************/

#include "gameboard.h"
#include "mycanvasview.h"
#include "mycanvas.h"
#include <qapplication.h>
#include <qiconview.h>
#include <qlabel.h>
#include <qaccel.h>
#include <qlcdnumber.h>
#include <qlayout.h>
#include <qcolor.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <iostream.h>
#include <qnamespace.h>

extern GameData *gd;

GameBoard::GameBoard( QWidget *parent, const char *name )
        : QWidget( parent, name )
{
	QPixmap topleftIcon("data/images/icons/icon16x16.png");
	setIcon(topleftIcon);

	mainPanel = new MyCanvas(this, "main view");
	inventoryPanel = new QIconView(this, "inventory view");

	gd = GameData::instance(inventoryPanel, mainPanel);

	mainView = new MyCanvasView(mainPanel, this);
	QLabel *inventoryLabel = new QLabel("What you have:", this);

	connect(inventoryPanel, SIGNAL(pressed(QIconViewItem*)), this, SLOT(updateSelectedItem(QIconViewItem*)));
	connect(mainPanel, SIGNAL(roomChanged()), this, SIGNAL(roomChanged()));
	connect(mainView, SIGNAL(currentObjectDropped()), this, SLOT(dropCurrentObject()));
	connect(mainView, SIGNAL(inventoryItemAdded(int)), this, SLOT(addItemToInventory(int)));
	connect(mainPanel, SIGNAL(inventoryItemRemoved(int)), mainView, SIGNAL(inventoryItemRemoved(int)));
	connect(mainView, SIGNAL(inventoryItemRemoved(int)), this, SLOT(removeItemFromInventory(int)));
	connect(mainView, SIGNAL(inventoryItemAdded(int)), mainPanel, SLOT(refreshScene()));
	connect(mainPanel, SIGNAL(milkWarmed()), this, SLOT(warmMilk()));
	connect(mainView, SIGNAL(inventoryItemRemoved(int)), mainPanel, SLOT(refreshScene()));
	connect(mainView, SIGNAL(roomChanged()), mainPanel, SIGNAL(roomChanged()));
	connect(mainView, SIGNAL(scoreChanged()), this, SIGNAL(scoreChanged()));
	connect(mainPanel, SIGNAL(endgame()), this, SIGNAL(endgame()));
	
	inventoryPanel->setBackgroundColor(Qt::white);
	mainPanel->refreshScene();

	QVBoxLayout *grid = new QVBoxLayout( this );
	grid->addWidget(mainView);
	grid->addWidget(inventoryLabel);
	grid->addWidget(inventoryPanel);
}

void GameBoard::updateSelectedItem(QIconViewItem *item) {
	if (item != 0) {
		for (int i=0; i<NUM_OBJECTS; i++) {
			if (item->text() == gd->objectData[i].name) {
				gd->currentObject = i;
				break;
			}
		}
		setCursor(*(new QCursor(*(new QBitmap("data/images/cursors/white.xbm")), *(gd->objectData[gd->currentObject].smallIconMask))));
	} else {
		dropCurrentObject();
	}
}

void GameBoard::dropCurrentObject() {
	if (gd->currentObject != -1) {
		inventoryPanel->setSelected(gd->objectData[gd->currentObject].smallIcon, false);
	}
	gd->currentObject = -1;
	setCursor(Qt::arrowCursor);
}

void GameBoard::addItemToInventory(int id) {
	gd->objectData[id].location = -1;

	//contributed by Maurizio Paolini
	gd->objectData[id].smallIcon =
		new QIconViewItem(inventoryPanel,
			gd->objectData[id].name,
			*(gd->objectData[id].smallPixmap));
	(gd->objectData[id].smallIcon)->setDragEnabled(false);

	//inventoryPanel->insertItem(gd->objectData[id].smallIcon);
}

void GameBoard::removeItemFromInventory(int id) {
	//these two lines contributed by Maurizio Paolini
	delete gd->objectData[id].smallIcon;
	gd->objectData[id].smallIcon = 0;

	//inventoryPanel->takeItem(gd->objectData[id].smallIcon);
	dropCurrentObject();
}

void GameBoard::warmMilk() {
	gd->objectData[gd->COLD_MILK].location = -2;	//non-existant
	removeItemFromInventory(gd->COLD_MILK);
	addItemToInventory(gd->WARM_MILK);
}

void GameBoard::clearInventoryBox() {
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		if (gd->objectData[i].location == -1) {
			removeItemFromInventory(i);
		}
	}

}

void GameBoard::refreshAll() {
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		if (gd->objectData[i].location == -1) {
			addItemToInventory(i);
		}
	}
	emit scoreChanged();
	mainPanel->refreshScene();
}

void GameBoard::setKeyboardFocus(bool on) {
	if (on) mainView->grabKeyboard();
	else mainView->releaseKeyboard();

}
