/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include "gamedata.h"
#include "gamestate.h"
#include "memento.h"
#include <qlist.h>
#include <iostream.h>
#include <stdlib.h>

#ifdef _WS_X11_
#include <sys/stat.h>
#include <unistd.h>
extern "C" {
	int GetProcByName(char *, pid_t *, char *, int);
};
#endif //_WS_X11_

GameData* GameData::_instance = 0;

GameData* GameData::instance(QIconView *iv, MyCanvas *mv) {
	if (_instance == 0) {
		_instance = new GameData(iv, mv);
	}
	return _instance;
}

GameData::GameData(QIconView *iv, MyCanvas *mv) {

	int i;

	//initialize room data
	roomData[BANK].roomImage = new QPixmap("data/images/backgrounds/bank.png");
	roomData[GREEN_ROOM].roomImage = new QPixmap("data/images/backgrounds/green_room.png");
	roomData[CAT_ROOM].roomImage = new QPixmap("data/images/backgrounds/cat_room.png");
	roomData[WHITE_ROOM].roomImage = new QPixmap("data/images/backgrounds/white_room.png");
	roomData[GOLD_ROOM].roomImage = new QPixmap("data/images/backgrounds/gold_room.png");
	roomData[HOT_ROOM].roomImage = new QPixmap("data/images/backgrounds/hot_room.png");
	roomData[OFFICE].roomImage = new QPixmap("data/images/backgrounds/office_room.png");
	roomData[MILK_ROOM].roomImage = new QPixmap("data/images/backgrounds/milk_room.png");
	roomData[STORE].roomImage = new QPixmap("data/images/backgrounds/store.png");
	roomData[BANK].roomName = "Bank";
	roomData[GREEN_ROOM].roomName = "Green Room";
	roomData[CAT_ROOM].roomName = "Cat Room";
	roomData[WHITE_ROOM].roomName = "White Room";
	roomData[GOLD_ROOM].roomName = "Gold Room";
	roomData[HOT_ROOM].roomName = "Hot Room";
	roomData[OFFICE].roomName = "Office";
	roomData[MILK_ROOM].roomName = "Milk Room";
	roomData[STORE].roomName = "Store";

	//BANK
	roomData[BANK].perimeter = new QPointArray(8);
	roomData[BANK].largePerimeter = new QPointArray(8);
	roomData[BANK].perimeter->setPoint(0, 379, 510);	//lower-left corner
	roomData[BANK].perimeter->setPoint(1, 736, 510);	//lower-right corner
	roomData[BANK].perimeter->setPoint(2, 552, 355);	//upper-right corner
	roomData[BANK].perimeter->setPoint(3, 465, 355);	//lower-right of door
	roomData[BANK].perimeter->setPoint(4, 465, 345);	//upper-right of door
	roomData[BANK].perimeter->setPoint(5, 510, 345);	//upper-left of door
	roomData[BANK].perimeter->setPoint(6, 510, 355);	//lower-left of door
	roomData[BANK].perimeter->setPoint(7, 410, 355);	//upper-left corner
	roomData[BANK].largePerimeter->setPoint(0, 347, 510);	//lower-left corner
	roomData[BANK].largePerimeter->setPoint(1, 778, 510);	//lower-right corner
	roomData[BANK].largePerimeter->setPoint(2, 588, 355);	//upper-right corner
	roomData[BANK].largePerimeter->setPoint(3, 539, 355);	//lower-right of door
	roomData[BANK].largePerimeter->setPoint(4, 542, 191);	//upper-right of door
	roomData[BANK].largePerimeter->setPoint(5, 436, 191);	//upper-left of door
	roomData[BANK].largePerimeter->setPoint(6, 435, 355);	//lower-left of door
	roomData[BANK].largePerimeter->setPoint(7, 377, 353);	//upper-left corner

	roomData[BANK].numPassages = 1;
	roomData[BANK].passageway.resize(roomData[BANK].numPassages);
	roomData[BANK].passageway[0].perimeter = new QPointArray(4);
	roomData[BANK].passageway[0].perimeter->setPoints(4, 539,355, 542,191, 436,191, 435,355);
	roomData[BANK].passageway[0].room = WHITE_ROOM;	//north door leads to white room
	roomData[BANK].passageway[0].newPos = new QPoint(480, 485);
	roomData[BANK].passageway[0].largePerimeter = new QPointArray(4);
	roomData[BANK].passageway[0].largePerimeter->setPoints(4, 539,355, 542,191, 436,191, 435,355);
	roomData[BANK].passageway[0].target = new QPoint(488, 345/*348*/);

	//WHITE ROOM
	roomData[WHITE_ROOM].perimeter = new QPointArray(10);
	roomData[WHITE_ROOM].largePerimeter = new QPointArray(12);
	roomData[WHITE_ROOM].perimeter->setPoint(0, 20+29, 510);	//lower-left corner
	roomData[WHITE_ROOM].perimeter->setPoint(1, 791-40, 510);	//lower-right corner
	roomData[WHITE_ROOM].perimeter->setPoint(2, 681-40, 430);	//lower-right of east door
	roomData[WHITE_ROOM].perimeter->setPoint(3, 681-40, 416);	//upper-right of east door
	roomData[WHITE_ROOM].perimeter->setPoint(4, 638-40, 397);	//left-side of door
	roomData[WHITE_ROOM].perimeter->setPoint(5, 589-40, 365);	//upper-right corner
	roomData[WHITE_ROOM].perimeter->setPoint(6, 447+29, 365);	//right side north door
	roomData[WHITE_ROOM].perimeter->setPoint(7, 398, 365);		//middle north door
	roomData[WHITE_ROOM].perimeter->setPoint(8, 356-40, 365);	//left side north door
	roomData[WHITE_ROOM].perimeter->setPoint(9, 221+29, 365);	//upper-left of room
	roomData[WHITE_ROOM].largePerimeter->setPoint(0, 20, 510);	//lower-left corner
	roomData[WHITE_ROOM].largePerimeter->setPoint(1, 791, 510);	//lower-right corner
	roomData[WHITE_ROOM].largePerimeter->setPoint(2, 681, 430);	//lower-right of east door
	roomData[WHITE_ROOM].largePerimeter->setPoint(3, 687, 205);	//upper-right of east door
	roomData[WHITE_ROOM].largePerimeter->setPoint(4, 642, 206);	//upper-left of east door
	roomData[WHITE_ROOM].largePerimeter->setPoint(5, 638, 397);	//lower-left of east door
	roomData[WHITE_ROOM].largePerimeter->setPoint(6, 589, 365);	//upper-right corner
	roomData[WHITE_ROOM].largePerimeter->setPoint(7, 447, 365);	//lower-right north door
	roomData[WHITE_ROOM].largePerimeter->setPoint(8, 446, 192);	//upper-right north door
	roomData[WHITE_ROOM].largePerimeter->setPoint(9, 352, 192);	//upper-left north door
	roomData[WHITE_ROOM].largePerimeter->setPoint(10, 356, 365);	//lower-left north door
	roomData[WHITE_ROOM].largePerimeter->setPoint(11, 221, 365);	//upper-left of room

	roomData[WHITE_ROOM].numPassages = 3;
	roomData[WHITE_ROOM].passageway.resize(roomData[WHITE_ROOM].numPassages);
	roomData[WHITE_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[WHITE_ROOM].passageway[0].perimeter->setPoints(3, 681-40,430, 681-40,416, 638-40,397);
	roomData[WHITE_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[WHITE_ROOM].passageway[0].largePerimeter->setPoints(4, 678,427, 687,205, 642,206, 636,395);
	roomData[WHITE_ROOM].passageway[0].target = new QPoint(669, 414);
	roomData[WHITE_ROOM].passageway[0].room = GOLD_ROOM;	//east door -> gold room
	roomData[WHITE_ROOM].passageway[0].newPos = new QPoint(/*160*/163, 380);
	roomData[WHITE_ROOM].passageway[1].perimeter = new QPointArray(4);
	roomData[WHITE_ROOM].passageway[1].perimeter->setPoints(4, 435-34,510, 435-34,490, 549+29,490, 549+29,510);
	roomData[WHITE_ROOM].passageway[1].largePerimeter = new QPointArray(4);
	roomData[WHITE_ROOM].passageway[1].largePerimeter->setPoints(4, 435,510, 435,490, 549,490, 549,510);
	roomData[WHITE_ROOM].passageway[1].target = new QPoint(490,505);
	roomData[WHITE_ROOM].passageway[1].room = BANK;	//south door -> bank
	roomData[WHITE_ROOM].passageway[1].newPos = new QPoint(480, 360);
	roomData[WHITE_ROOM].passageway[2].perimeter = new QPointArray(3);
	roomData[WHITE_ROOM].passageway[2].perimeter->setPoints(3, 447+29,365, 398,192, 356-40, 365);
	roomData[WHITE_ROOM].passageway[2].largePerimeter = new QPointArray(4);
	roomData[WHITE_ROOM].passageway[2].largePerimeter->setPoints(4, 445,354, 446,192, 352,192, 353,354);
	roomData[WHITE_ROOM].passageway[2].target = new QPoint(398,347);
	roomData[WHITE_ROOM].passageway[2].room = OFFICE;	//north door
	roomData[WHITE_ROOM].passageway[2].newPos = new QPoint(400, 485);

	//GOLD ROOM
	roomData[GOLD_ROOM].perimeter = new QPointArray(16);
	roomData[GOLD_ROOM].largePerimeter = new QPointArray(19);
	roomData[GOLD_ROOM].perimeter->setPoint(0, 49+29, 510);		//lower-left corner
	roomData[GOLD_ROOM].perimeter->setPoint(1, 400, 530);		//low-center (below image)
	roomData[GOLD_ROOM].perimeter->setPoint(2, 762-40, 510);	//lower-right corner
	roomData[GOLD_ROOM].perimeter->setPoint(3, 764-40, 395);	//upper-right corner
	roomData[GOLD_ROOM].perimeter->setPoint(4, 737-40, 384);	//right door, right side
	roomData[GOLD_ROOM].perimeter->setPoint(5, 697-40, 357);	//right door, center
	roomData[GOLD_ROOM].perimeter->setPoint(6, 649-40, 361);	//right door, left side
	roomData[GOLD_ROOM].perimeter->setPoint(7, 550-40, 345);	//between center & right doors
	roomData[GOLD_ROOM].perimeter->setPoint(8, 456-35, 338);	//center door, right side
	roomData[GOLD_ROOM].perimeter->setPoint(9, 405, 173);		//center door, center
	roomData[GOLD_ROOM].perimeter->setPoint(10, 353+29, 337);	//center door, left side
	roomData[GOLD_ROOM].perimeter->setPoint(11, 262+29, 342);	//between left & center doors
	roomData[GOLD_ROOM].perimeter->setPoint(12, 168+29, 358);	//left door, right side
	roomData[GOLD_ROOM].perimeter->setPoint(13, 126+29, 348);	//left door, center
	roomData[GOLD_ROOM].perimeter->setPoint(14, 80+29, 381);	//left door, left side
	roomData[GOLD_ROOM].perimeter->setPoint(15, 46+29, 395);	//upper-left corner
	roomData[GOLD_ROOM].largePerimeter->setPoint(0, 49, 510);		//lower-left corner
	roomData[GOLD_ROOM].largePerimeter->setPoint(1, 400, 530);		//low-center (below image)
	roomData[GOLD_ROOM].largePerimeter->setPoint(2, 762, 510);	//lower-right corner
	roomData[GOLD_ROOM].largePerimeter->setPoint(3, 764, 395);	//upper-right corner
	roomData[GOLD_ROOM].largePerimeter->setPoint(4, 737, 384);	//right door, lower-right side
	roomData[GOLD_ROOM].largePerimeter->setPoint(5, 740, 153);	//right door, upper-right
	roomData[GOLD_ROOM].largePerimeter->setPoint(6, 651, 166);	//right door, upper-left
	roomData[GOLD_ROOM].largePerimeter->setPoint(7, 649, 361);	//right door, lower-left side
	roomData[GOLD_ROOM].largePerimeter->setPoint(8, 550, 345);	//between center & right doors
	roomData[GOLD_ROOM].largePerimeter->setPoint(9, 456, 338);	//center door, lower-right side
	roomData[GOLD_ROOM].largePerimeter->setPoint(10, 454, 173);		//center door, upper-right
	roomData[GOLD_ROOM].largePerimeter->setPoint(11, 351, 172);		//center door, upper-left
	roomData[GOLD_ROOM].largePerimeter->setPoint(12, 353, 337);	//center door, lower-left side
	roomData[GOLD_ROOM].largePerimeter->setPoint(13, 262, 342);	//between left & center doors
	roomData[GOLD_ROOM].largePerimeter->setPoint(14, 168, 358);	//left door, lower-right side
	roomData[GOLD_ROOM].largePerimeter->setPoint(15, 164, 167);	//left door, upper-right side
	roomData[GOLD_ROOM].largePerimeter->setPoint(16, 73, 154);	//left door, upper-left side
	roomData[GOLD_ROOM].largePerimeter->setPoint(17, 80, 381);	//left door, lower-left side
	roomData[GOLD_ROOM].largePerimeter->setPoint(18, 46, 395);	//upper-left corner

	roomData[GOLD_ROOM].numPassages = 3;
	roomData[GOLD_ROOM].passageway.resize(roomData[GOLD_ROOM].numPassages);
	roomData[GOLD_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[GOLD_ROOM].passageway[0].perimeter->setPoints(3, 168+29,358, 126+29,348, 80+29,381);
	roomData[GOLD_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[GOLD_ROOM].passageway[0].largePerimeter->setPoints(4, 168,358, 163,168, 72,154, 80,381);
	roomData[GOLD_ROOM].passageway[0].target = new QPoint(127, 370);
	roomData[GOLD_ROOM].passageway[0].room = WHITE_ROOM;	//west door -> white room
	roomData[GOLD_ROOM].passageway[0].newPos = new QPoint(580, 420);
	roomData[GOLD_ROOM].passageway[1].perimeter = new QPointArray(3);
	roomData[GOLD_ROOM].passageway[1].perimeter->setPoints(3, 456-35,350, 405,173, 353+29,350);
	roomData[GOLD_ROOM].passageway[1].largePerimeter = new QPointArray(4);
	roomData[GOLD_ROOM].passageway[1].largePerimeter->setPoints(4, 456,338, 454,173, 351,172, 353,337);
	roomData[GOLD_ROOM].passageway[1].target = new QPoint(401, 335);
	roomData[GOLD_ROOM].passageway[1].room = MILK_ROOM;	//north door -> milk room
	roomData[GOLD_ROOM].passageway[1].newPos = new QPoint(417, 485);
	roomData[GOLD_ROOM].passageway[2].perimeter = new QPointArray(3);
	roomData[GOLD_ROOM].passageway[2].perimeter->setPoints(3, 737-40,384, 697-40,357, 649-40,361);
	roomData[GOLD_ROOM].passageway[2].largePerimeter = new QPointArray(4);
	roomData[GOLD_ROOM].passageway[2].largePerimeter->setPoints(4, 737,384, 741,152, 651,166, 649,361);
	roomData[GOLD_ROOM].passageway[2].target = new QPoint(709, 371);
	roomData[GOLD_ROOM].passageway[2].room = HOT_ROOM;	//east door -> hot room
	roomData[GOLD_ROOM].passageway[2].newPos = new QPoint(170, 428);

	//MILK ROOM
	roomData[MILK_ROOM].perimeter = new QPointArray(10);
	roomData[MILK_ROOM].largePerimeter = new QPointArray(11);
	roomData[MILK_ROOM].perimeter->setPoint(0, 17+29, 510);		//lower-left corner
	roomData[MILK_ROOM].perimeter->setPoint(1, 792-40, 510);	//lower-right corner
	roomData[MILK_ROOM].perimeter->setPoint(2, 710-40, 455);	//east door, right corner
	roomData[MILK_ROOM].perimeter->setPoint(3, 520-40, 455);	//carrots, left side
	roomData[MILK_ROOM].perimeter->setPoint(4, 655-40, 408);	//east door, left corner
	roomData[MILK_ROOM].perimeter->setPoint(5, 600-40, 370);	//upper-right corner
	roomData[MILK_ROOM].perimeter->setPoint(6, 315+29, 370);	//cooler, top-right
	roomData[MILK_ROOM].perimeter->setPoint(7, 315+29, 410);	//cooler, bottom-right
	roomData[MILK_ROOM].perimeter->setPoint(8, 205+29, 435);	//cooler, southern tip
	roomData[MILK_ROOM].perimeter->setPoint(9, 138+29, 420);	//cooler, west tip
	roomData[MILK_ROOM].largePerimeter->setPoint(0, 179, 510);	//lower-left corner
	roomData[MILK_ROOM].largePerimeter->setPoint(1, 792, 510);	//lower-right corner
	roomData[MILK_ROOM].largePerimeter->setPoint(2, 710, 455);	//east door, lower-right corner
	roomData[MILK_ROOM].largePerimeter->setPoint(3, 717, 201);	//east door, upper-right
	roomData[MILK_ROOM].largePerimeter->setPoint(4, 660, 205);	//east door, upper-left
	roomData[MILK_ROOM].largePerimeter->setPoint(5, 655, 408);	//east door, lower-left corner
	roomData[MILK_ROOM].largePerimeter->setPoint(6, 600, 370);	//upper-right corner
	roomData[MILK_ROOM].largePerimeter->setPoint(7, 315, 370);	//cooler, top-right
	roomData[MILK_ROOM].largePerimeter->setPoint(8, 315, 410);	//cooler, bottom-right
	roomData[MILK_ROOM].largePerimeter->setPoint(9, 205, 435);	//cooler, southern tip
	roomData[MILK_ROOM].largePerimeter->setPoint(10, 138, 420);	//cooler, west tip

	roomData[MILK_ROOM].numPassages = 2;
	roomData[MILK_ROOM].passageway.resize(roomData[MILK_ROOM].numPassages);
	roomData[MILK_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[MILK_ROOM].passageway[0].perimeter->setPoints(3, 365+29,510, 410,490, 474,510);
	roomData[MILK_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[MILK_ROOM].passageway[0].largePerimeter->setPoints(4, 358,510, 358,490, 474,490, 474,510);
	roomData[MILK_ROOM].passageway[0].target = new QPoint(418,504);
	roomData[MILK_ROOM].passageway[0].room = GOLD_ROOM;	//south door - gold room
	roomData[MILK_ROOM].passageway[0].newPos = new QPoint(405, 354);
	roomData[MILK_ROOM].passageway[1].perimeter = new QPointArray(3);
	roomData[MILK_ROOM].passageway[1].perimeter->setPoints(3, 710-40,447, 684-40,410, 655-40,408);
	roomData[MILK_ROOM].passageway[1].largePerimeter = new QPointArray(4);
	roomData[MILK_ROOM].passageway[1].largePerimeter->setPoints(4, 710,447, 717,201, 660,205, 655,408);
	roomData[MILK_ROOM].passageway[1].target = new QPoint(686, 419);
	roomData[MILK_ROOM].passageway[1].room = STORE;	//east door - store
	roomData[MILK_ROOM].passageway[1].newPos = new QPoint(170, 422);
	
	//STORE
	roomData[STORE].perimeter = new QPointArray(10);
	roomData[STORE].largePerimeter = new QPointArray(11);
	roomData[STORE].perimeter->setPoint(0, 17+29, 510);		//lower-left corner
	roomData[STORE].perimeter->setPoint(1, 785-40, 510);	//lower-right corner
	roomData[STORE].perimeter->setPoint(2, 665-40, 424);	//middle right wall
	roomData[STORE].perimeter->setPoint(3, 607-40, 424);	//lower corner machine
	roomData[STORE].perimeter->setPoint(4, 386-40, 399);	//left corner machine
	roomData[STORE].perimeter->setPoint(5, 386-40, 382);	//middle north wall
	roomData[STORE].perimeter->setPoint(6, 207+29, 382);	//upper left corner
	roomData[STORE].perimeter->setPoint(7, 166+29, 401);	//upper corner door
	roomData[STORE].perimeter->setPoint(8, 138+29, 401);	//middle door
	roomData[STORE].perimeter->setPoint(9, 117+29, 439);	//lower corner door
	roomData[STORE].largePerimeter->setPoint(0, 179, 510);		//lower-left corner
	roomData[STORE].largePerimeter->setPoint(1, 785, 510);	//lower-right corner
	roomData[STORE].largePerimeter->setPoint(2, 665, 424);	//middle right wall
	roomData[STORE].largePerimeter->setPoint(3, 607, 424);	//lower corner machine
	roomData[STORE].largePerimeter->setPoint(4, 386, 399);	//left corner machine
	roomData[STORE].largePerimeter->setPoint(5, 386, 382);	//middle north wall
	roomData[STORE].largePerimeter->setPoint(6, 207, 382);	//upper left corner
	roomData[STORE].largePerimeter->setPoint(7, 166, 401);	//lower-right corner door
	roomData[STORE].largePerimeter->setPoint(8, 158, 195);	//upper-right corner door
	roomData[STORE].largePerimeter->setPoint(9, 106, 188);	//upper-left door
	roomData[STORE].largePerimeter->setPoint(10, 117, 439);	//lower-left corner door

	roomData[STORE].numPassages = 1;
	roomData[STORE].passageway.resize(roomData[STORE].numPassages);
	roomData[STORE].passageway[0].perimeter = new QPointArray(3);
	roomData[STORE].passageway[0].perimeter->setPoints(3, 166+29,401, 138+29,401, 117+29,439);
	roomData[STORE].passageway[0].largePerimeter = new QPointArray(4);
	roomData[STORE].passageway[0].largePerimeter->setPoints(4, 166,401, 158,195, 106,188, 117,439);
	roomData[STORE].passageway[0].target = new QPoint(138, 401);
	roomData[STORE].passageway[0].room = MILK_ROOM;	//west door - milk room
	roomData[STORE].passageway[0].newPos = new QPoint(658, 440);
	
	//HOT ROOM
	roomData[HOT_ROOM].perimeter = new QPointArray(7);
	roomData[HOT_ROOM].largePerimeter = new QPointArray(8);
	roomData[HOT_ROOM].perimeter->setPoint(0, 17+29, 510);		//lower-left corner
	roomData[HOT_ROOM].perimeter->setPoint(1, 789-40, 510);	//lower-right corner
	roomData[HOT_ROOM].perimeter->setPoint(2, 593-40, 370);	//upper-right corner
	roomData[HOT_ROOM].perimeter->setPoint(3, 208+29, 370);	//upper-left corner
	roomData[HOT_ROOM].perimeter->setPoint(4, 147+29, 413);	//right corner left door
	roomData[HOT_ROOM].perimeter->setPoint(5, 121+29, 413);	//middle left door
	roomData[HOT_ROOM].perimeter->setPoint(6, 101+29, 447);	//left corner left door
	roomData[HOT_ROOM].largePerimeter->setPoint(0, 17, 510);	//lower-left corner
	roomData[HOT_ROOM].largePerimeter->setPoint(1, 789, 510);	//lower-right corner
	roomData[HOT_ROOM].largePerimeter->setPoint(2, 593, 370);	//upper-right corner
	roomData[HOT_ROOM].largePerimeter->setPoint(3, 208, 370);	//upper-left corner
	roomData[HOT_ROOM].largePerimeter->setPoint(4, 147, 413);	//lower-right corner left door
	roomData[HOT_ROOM].largePerimeter->setPoint(5, 137, 191);	//upper-right left door
	roomData[HOT_ROOM].largePerimeter->setPoint(6, 88, 184);	//upper-left left door
	roomData[HOT_ROOM].largePerimeter->setPoint(7, 101, 447);	//lower-left corner left door

	roomData[HOT_ROOM].numPassages = 2;
	roomData[HOT_ROOM].passageway.resize(roomData[HOT_ROOM].numPassages);
	roomData[HOT_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[HOT_ROOM].passageway[0].perimeter->setPoints(3, 147+29,413, 121+29,413, 101+29,447);
	roomData[HOT_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[HOT_ROOM].passageway[0].largePerimeter->setPoints(4, 147,413, 137,191, 88,184, 101,447);
	roomData[HOT_ROOM].passageway[0].target = new QPoint(121,413);
	roomData[HOT_ROOM].passageway[0].room = GOLD_ROOM;	//west door - gold room
	roomData[HOT_ROOM].passageway[0].newPos = new QPoint(635, 385);
	roomData[HOT_ROOM].passageway[1].perimeter = new QPointArray(3);
	roomData[HOT_ROOM].passageway[1].perimeter->setPoints(3, 157,510, 218,493, 279,510);
	roomData[HOT_ROOM].passageway[1].largePerimeter = new QPointArray(4);
	roomData[HOT_ROOM].passageway[1].largePerimeter->setPoints(4, 157,510, 157,492, 279,492, 279,510);
	roomData[HOT_ROOM].passageway[1].target = new QPoint(218,505);
	roomData[HOT_ROOM].passageway[1].room = CAT_ROOM;	//south door - cat room
	roomData[HOT_ROOM].passageway[1].newPos = new QPoint(300, 360);

	//CAT ROOM
	roomData[CAT_ROOM].perimeter = new QPointArray(11);
	roomData[CAT_ROOM].largePerimeter = new QPointArray(13);
	roomData[CAT_ROOM].perimeter->setPoint(0, 16+29, 510);		//lower-left corner
	roomData[CAT_ROOM].perimeter->setPoint(1, 331-40, 510);	//next to paw, low
	roomData[CAT_ROOM].perimeter->setPoint(2, 340-40, 467);	//next to paw, high
	roomData[CAT_ROOM].perimeter->setPoint(3, 570-40, 360);	//behind cat
	roomData[CAT_ROOM].perimeter->setPoint(4, 356-40, 360);	//right corner north door
	roomData[CAT_ROOM].perimeter->setPoint(5, 304-40, 337);	//middle north door
	roomData[CAT_ROOM].perimeter->setPoint(6, 257+29, 360);	//left corner north door
	roomData[CAT_ROOM].perimeter->setPoint(7, 215+29, 360);	//upper-left corner
	roomData[CAT_ROOM].perimeter->setPoint(8, 168+29, 395);	//right corner left door
	roomData[CAT_ROOM].perimeter->setPoint(9, 135+29, 395);	//middle left door
	roomData[CAT_ROOM].perimeter->setPoint(10, 106+29, 443);	//left corner left door
	roomData[CAT_ROOM].largePerimeter->setPoint(0, 16, 510);	//lower-left corner
	roomData[CAT_ROOM].largePerimeter->setPoint(1, 331, 510);	//next to paw, low
	roomData[CAT_ROOM].largePerimeter->setPoint(2, 340, 467);	//next to paw, high
	roomData[CAT_ROOM].largePerimeter->setPoint(3, 570, 360);	//behind cat
	roomData[CAT_ROOM].largePerimeter->setPoint(4, 356, 360);	//lower-right corner north door
	roomData[CAT_ROOM].largePerimeter->setPoint(5, 351, 182);	//upper-right north door
	roomData[CAT_ROOM].largePerimeter->setPoint(6, 249, 182);	//upper-left north door
	roomData[CAT_ROOM].largePerimeter->setPoint(7, 257, 360);	//lower-left corner north door
	roomData[CAT_ROOM].largePerimeter->setPoint(8, 215, 360);	//upper-left corner
	roomData[CAT_ROOM].largePerimeter->setPoint(9, 168, 395);	//lower-right corner left door
	roomData[CAT_ROOM].largePerimeter->setPoint(10, 156, 174);	//upper-right left door
	roomData[CAT_ROOM].largePerimeter->setPoint(11, 88, 164);	//upper-left left door
	roomData[CAT_ROOM].largePerimeter->setPoint(12, 106, 443);	//lower-left corner left door

	roomData[CAT_ROOM].numPassages = 2;
	roomData[CAT_ROOM].passageway.resize(roomData[CAT_ROOM].numPassages);
	roomData[CAT_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[CAT_ROOM].passageway[0].perimeter->setPoints(3, 356-40,360, 304-40,182, 257+29,360);
	roomData[CAT_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[CAT_ROOM].passageway[0].largePerimeter->setPoints(4, 356,360, 351,182, 249,182, 257,360);
	roomData[CAT_ROOM].passageway[0].target = new QPoint(304, 351);
	roomData[CAT_ROOM].passageway[0].room = HOT_ROOM;	//north door - hot room
	roomData[CAT_ROOM].passageway[0].newPos = new QPoint(218, 490);
	roomData[CAT_ROOM].passageway[1].perimeter = new QPointArray(3);
	roomData[CAT_ROOM].passageway[1].perimeter->setPoints(3, 168+29,395, 135+29,395, 106+29,443);
	roomData[CAT_ROOM].passageway[1].largePerimeter = new QPointArray(4);
	roomData[CAT_ROOM].passageway[1].largePerimeter->setPoints(4, 168,395, 156,174, 88,164, 106,443);
	roomData[CAT_ROOM].passageway[1].room = GREEN_ROOM;	//west door - green room
	roomData[CAT_ROOM].passageway[1].target = new QPoint(119, 423);
	roomData[CAT_ROOM].passageway[1].newPos = new QPoint(635, 430);

	//GREEN ROOM
	roomData[GREEN_ROOM].perimeter = new QPointArray(7);
	roomData[GREEN_ROOM].largePerimeter = new QPointArray(8);
	roomData[GREEN_ROOM].perimeter->setPoint(0, 21+29, 510);		//lower-left corner
	roomData[GREEN_ROOM].perimeter->setPoint(1, 785-40, 510);	//lower-right corner
	roomData[GREEN_ROOM].perimeter->setPoint(2, 721-40, 460);	//right side east door
	roomData[GREEN_ROOM].perimeter->setPoint(3, 690-40, 411);	//middle east door
	roomData[GREEN_ROOM].perimeter->setPoint(4, 656-40, 411);	//left side east door
	roomData[GREEN_ROOM].perimeter->setPoint(5, 634-40, 400);	//upper-right corner
	roomData[GREEN_ROOM].perimeter->setPoint(6, 182+29, 400);	//upper-left corner
	roomData[GREEN_ROOM].largePerimeter->setPoint(0, 21, 510);		//lower-left corner
	roomData[GREEN_ROOM].largePerimeter->setPoint(1, 785, 510);	//lower-right corner
	roomData[GREEN_ROOM].largePerimeter->setPoint(2, 721, 460);	//lower-right side east door
	roomData[GREEN_ROOM].largePerimeter->setPoint(3, 727, 179);	//upper-right east door
	roomData[GREEN_ROOM].largePerimeter->setPoint(4, 659, 190);	//upper-left east door
	roomData[GREEN_ROOM].largePerimeter->setPoint(5, 656, 411);	//lower-left side east door
	roomData[GREEN_ROOM].largePerimeter->setPoint(6, 634, 400);	//upper-right corner
	roomData[GREEN_ROOM].largePerimeter->setPoint(7, 182, 400);	//upper-left corner

	roomData[GREEN_ROOM].numPassages = 1;
	roomData[GREEN_ROOM].passageway.resize(roomData[GREEN_ROOM].numPassages);
	roomData[GREEN_ROOM].passageway[0].perimeter = new QPointArray(3);
	roomData[GREEN_ROOM].passageway[0].perimeter->setPoints(3, 721-40,460, 690-40,411, 656-40,411);
	roomData[GREEN_ROOM].passageway[0].largePerimeter = new QPointArray(4);
	roomData[GREEN_ROOM].passageway[0].largePerimeter->setPoints(4, 721,460, 727,179, 659,190, 656,411);
	roomData[GREEN_ROOM].passageway[0].target = new QPoint(690, 428);
	roomData[GREEN_ROOM].passageway[0].room = CAT_ROOM;	//east door - cat room
	roomData[GREEN_ROOM].passageway[0].newPos = new QPoint(180, 420);

	//OFFICE
	roomData[OFFICE].perimeter = new QPointArray(9);
	roomData[OFFICE].largePerimeter = new QPointArray(9);
	roomData[OFFICE].perimeter->setPoint(0, 15+29, 510);		//lower-left corner
	roomData[OFFICE].perimeter->setPoint(1, 782-40, 510);	//lower-right corner
	roomData[OFFICE].perimeter->setPoint(2, 758-40, 496);	//lower-right bookshelf
	roomData[OFFICE].perimeter->setPoint(3, 642-40, 496);	//lower-left bookshelf
	roomData[OFFICE].perimeter->setPoint(4, 592-40, 430);	//upper-left bookshelf
	roomData[OFFICE].perimeter->setPoint(5, 500-40, 438);	//base of chair
	roomData[OFFICE].perimeter->setPoint(6, 441+29, 420);	//upper-right desk
	roomData[OFFICE].perimeter->setPoint(7, 200, 475);	//lower-middle desk
	roomData[OFFICE].perimeter->setPoint(8, 109+29, 430);	//left side desk
	roomData[OFFICE].largePerimeter->setPoint(0, 15, 510);		//lower-left corner
	roomData[OFFICE].largePerimeter->setPoint(1, 782, 510);	//lower-right corner
	roomData[OFFICE].largePerimeter->setPoint(2, 758, 496);	//lower-right bookshelf
	roomData[OFFICE].largePerimeter->setPoint(3, 642, 496);	//lower-left bookshelf
	roomData[OFFICE].largePerimeter->setPoint(4, 592, 430);	//upper-left bookshelf
	roomData[OFFICE].largePerimeter->setPoint(5, 500, 438);	//base of chair
	roomData[OFFICE].largePerimeter->setPoint(6, 441, 420);	//upper-right desk
	roomData[OFFICE].largePerimeter->setPoint(7, 200, 475);	//lower-middle desk
	roomData[OFFICE].largePerimeter->setPoint(8, 109, 430);	//left side desk

	roomData[OFFICE].numPassages = 1;
	roomData[OFFICE].passageway.resize(roomData[OFFICE].numPassages);
	roomData[OFFICE].passageway[0].perimeter = new QPointArray(3);
	roomData[OFFICE].passageway[0].perimeter->setPoints(3, 343,510, 400,490, 454,510);
	roomData[OFFICE].passageway[0].largePerimeter = new QPointArray(4);
	roomData[OFFICE].passageway[0].largePerimeter->setPoints(4, 343,510, 343,492, 454,492, 454,510);
	roomData[OFFICE].passageway[0].target = new QPoint(396, 505);
	roomData[OFFICE].passageway[0].room = WHITE_ROOM;	//south door - white room
	roomData[OFFICE].passageway[0].newPos = new QPoint(400, 370);

	//load object data
	//MAP
	objectData[MAP].name = "Map";
	objectData[MAP].smallPixmap = new QPixmap("data/images/objects/magazine_icon.png");
	objectData[MAP].smallPixmap->setMask(objectData[MAP].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *mapPixmap = new QCanvasPixmapArray("data/images/objects/coupon.png");
	(mapPixmap->image(0))->setMask((mapPixmap->image(0))->createHeuristicMask());
	objectData[MAP].smallIconMask = new QBitmap("data/images/cursors/chula_mask.xbm");
	objectData[MAP].largeIcon = new QCanvasSprite(mapPixmap, mv);
	objectData[MAP].location = -2;	//BANK
	objectData[MAP].largeIcon->move(645,423);
	objectData[MAP].isTreasure = false;

	//CHULA
	objectData[CHULA].name = "Rabbit";
	objectData[CHULA].smallPixmap = new QPixmap("data/images/objects/chula_icon.png");
	objectData[CHULA].smallPixmap->setMask(objectData[CHULA].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *chulaPixmap = new QCanvasPixmapArray("data/images/objects/chula.png");
	(chulaPixmap->image(0))->setMask((chulaPixmap->image(0))->createHeuristicMask());
	objectData[CHULA].smallIconMask = new QBitmap("data/images/cursors/chula.xbm");
	objectData[CHULA].largeIcon = new QCanvasSprite(chulaPixmap, mv);
	objectData[CHULA].location = WHITE_ROOM;
	objectData[CHULA].largeIcon->move(168,416);//(645,410);
	objectData[CHULA].isTreasure = false;

	//COUPON
	objectData[COUPON].name = "Coupon";
	objectData[COUPON].smallPixmap = new QPixmap("data/images/objects/coupon_icon.png");
	QCanvasPixmapArray *couponPixmap = new QCanvasPixmapArray("data/images/objects/coupon.png");
	(couponPixmap->image(0))->setMask((couponPixmap->image(0))->createHeuristicMask());
	objectData[COUPON].smallIconMask = new QBitmap("data/images/cursors/coupon.xbm");
	objectData[COUPON].largeIcon = new QCanvasSprite(couponPixmap, mv);
	objectData[COUPON].location = HOT_ROOM;
	objectData[COUPON].largeIcon->move(550,423);
	objectData[COUPON].isTreasure = false;

	//EMPTY BOWL
	objectData[EMPTY_BOWL].name = "Empty Bowl";
	objectData[EMPTY_BOWL].smallPixmap = new QPixmap("data/images/objects/bowl_icon.png");
	objectData[EMPTY_BOWL].smallPixmap->setMask(objectData[EMPTY_BOWL].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *bowlPixmap = new QCanvasPixmapArray("data/images/objects/bowl.png");
	(bowlPixmap->image(0))->setMask((bowlPixmap->image(0))->createHeuristicMask());
	objectData[EMPTY_BOWL].smallIconMask = new QBitmap("data/images/cursors/bowl.xbm");
	objectData[EMPTY_BOWL].largeIcon = new QCanvasSprite(bowlPixmap, mv);
	objectData[EMPTY_BOWL].location = -2;	//nonexistant
	objectData[EMPTY_BOWL].largeIcon->move(461,322);
	objectData[EMPTY_BOWL].isTreasure = false;

	//BOWL OF COLD MILK
	objectData[COLD_MILK].name = "Cold Milk";
	objectData[COLD_MILK].smallPixmap = new QPixmap("data/images/objects/bowl_cold_milk_icon.png");
	objectData[COLD_MILK].smallPixmap->setMask(objectData[COLD_MILK].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *coldBowlPixmap = new QCanvasPixmapArray("data/images/objects/bowl_cold_milk.png");
	(coldBowlPixmap->image(0))->setMask((coldBowlPixmap->image(0))->createHeuristicMask());
	objectData[COLD_MILK].smallIconMask = new QBitmap("data/images/cursors/bowl.xbm");
	objectData[COLD_MILK].largeIcon = new QCanvasSprite(coldBowlPixmap, mv);
	objectData[COLD_MILK].location = -2;	//nonexistant
	objectData[COLD_MILK].largeIcon->move(233,376);
	objectData[COLD_MILK].isTreasure = false;

	//BOWL OF WARM MILK
	objectData[WARM_MILK].name = "Warm Milk";
	objectData[WARM_MILK].smallPixmap = new QPixmap("data/images/objects/bowl_warm_milk_icon.png");
	objectData[WARM_MILK].smallPixmap->setMask(objectData[WARM_MILK].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *warmBowlPixmap = new QCanvasPixmapArray("data/images/objects/bowl_warm_milk.png");
	(warmBowlPixmap->image(0))->setMask((warmBowlPixmap->image(0))->createHeuristicMask());
	objectData[WARM_MILK].smallIconMask = new QBitmap("data/images/cursors/bowl.xbm");
	objectData[WARM_MILK].largeIcon = new QCanvasSprite(warmBowlPixmap, mv);
	objectData[WARM_MILK].location = -2;	//nonexistant
	objectData[WARM_MILK].largeIcon->move(290,460);
	objectData[WARM_MILK].largeIcon->setZ(2);
	objectData[WARM_MILK].isTreasure = false;

	//CATALOG
	objectData[CATALOG].name = "Catalog";
	objectData[CATALOG].smallPixmap = new QPixmap("data/images/objects/magazine_icon.png");
	QCanvasPixmapArray *catalogPixmap = new QCanvasPixmapArray("data/images/objects/coupon.png");
	(catalogPixmap->image(0))->setMask((catalogPixmap->image(0))->createHeuristicMask());
	objectData[CATALOG].smallIconMask = new QBitmap("data/images/cursors/bowl.xbm");
	objectData[CATALOG].largeIcon = new QCanvasSprite(catalogPixmap, mv);
	objectData[CATALOG].location = -2;	//nonexistant
	objectData[CATALOG].largeIcon->move(645,423);
	objectData[CATALOG].isTreasure = false;

	//MAGAZINE
	objectData[MAGAZINE].name = "Magazine";
	objectData[MAGAZINE].smallPixmap = new QPixmap("data/images/objects/magazine_icon.png");
	QCanvasPixmapArray *magazinePixmap = new QCanvasPixmapArray("data/images/objects/magazine.png");
	(magazinePixmap->image(0))->setMask((magazinePixmap->image(0))->createHeuristicMask());
	objectData[MAGAZINE].smallIconMask = new QBitmap("data/images/cursors/magazine.xbm");
	objectData[MAGAZINE].largeIcon = new QCanvasSprite(magazinePixmap, mv);
	objectData[MAGAZINE].location = OFFICE;
	objectData[MAGAZINE].largeIcon->move(209,278);
	objectData[MAGAZINE].isTreasure = false;

	//EGG
	objectData[EGG].name = "Egg";
	objectData[EGG].smallPixmap = new QPixmap("data/images/objects/egg_icon.png");
	objectData[EGG].smallPixmap->setMask(objectData[EGG].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *eggPixmap = new QCanvasPixmapArray("data/images/objects/egg.png");
	(eggPixmap->image(0))->setMask((eggPixmap->image(0))->createHeuristicMask());
	objectData[EGG].smallIconMask = new QBitmap("data/images/cursors/egg.xbm");
	objectData[EGG].largeIcon = new QCanvasSprite(eggPixmap, mv);
	objectData[EGG].location = -2;	//nonexistant
	objectData[EGG].isTreasure = true;

	//JEWEL
	objectData[JEWEL].name = "Jewel";
	objectData[JEWEL].smallPixmap = new QPixmap("data/images/objects/jewel_icon.png");
	objectData[JEWEL].smallPixmap->setMask(objectData[JEWEL].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *jewelPixmap = new QCanvasPixmapArray("data/images/objects/jewel.png");
	(jewelPixmap->image(0))->setMask((jewelPixmap->image(0))->createHeuristicMask());
	objectData[JEWEL].smallIconMask = new QBitmap("data/images/cursors/jewel.xbm");
	objectData[JEWEL].largeIcon = new QCanvasSprite(jewelPixmap, mv);
	objectData[JEWEL].location = STORE;
	objectData[JEWEL].largeIcon->move(680,444);
	objectData[JEWEL].isTreasure = true;

	//COIN
	objectData[COIN].name = "Coin";
	objectData[COIN].smallPixmap = new QPixmap("data/images/objects/coin_icon.png");
	objectData[COIN].smallPixmap->setMask(objectData[COIN].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *coinPixmap = new QCanvasPixmapArray("data/images/objects/coin.png");
	(coinPixmap->image(0))->setMask((coinPixmap->image(0))->createHeuristicMask());
	objectData[COIN].smallIconMask = new QBitmap("data/images/cursors/coin.xbm");
	objectData[COIN].largeIcon = new QCanvasSprite(coinPixmap, mv);
	objectData[COIN].location = GREEN_ROOM;
	objectData[COIN].largeIcon->move(200,423);
	objectData[COIN].isTreasure = true;

	//VASE
	objectData[VASE].name = "Vase";
	objectData[VASE].smallPixmap = new QPixmap("data/images/objects/vase_icon.png");
	objectData[VASE].smallPixmap->setMask(objectData[VASE].smallPixmap->createHeuristicMask());
	QCanvasPixmapArray *vasePixmap = new QCanvasPixmapArray("data/images/objects/vase.png");
	(vasePixmap->image(0))->setMask((vasePixmap->image(0))->createHeuristicMask());
	objectData[VASE].smallIconMask = new QBitmap("data/images/cursors/vase.xbm");
	objectData[VASE].largeIcon = new QCanvasSprite(vasePixmap, mv);
	objectData[VASE].location = -2;	//nonexistant
	objectData[VASE].largeIcon->move(280,426);
	objectData[VASE].largeIcon->setZ(1);
	objectData[VASE].isTreasure = true;

	//set some defaults
	for (i=0; i<NUM_OBJECTS; i++) {
		objectData[i].smallIcon = new QIconViewItem(iv, objectData[i].name, *(objectData[i].smallPixmap));
		(objectData[i].smallIcon)->setDragEnabled(false);
		iv->takeItem(objectData[i].smallIcon);
		objectData[i].pointsAwarded = 0;
	}

	for (i=0; i<NUM_ROOMS; i++) {
		roomData[i].visited = false;
	}

	//NELLAN
	QCanvasPixmapArray *catPixmap = new QCanvasPixmapArray("data/images/chars/nellan.png");
	(catPixmap->image(0))->setMask((catPixmap->image(0))->createHeuristicMask());
	catSprite = new QCanvasSprite(catPixmap, mv);
	catSprite->setZ(1);			//avatar can move behind nellan
	catSprite->move(300,30);	//nellan sits in the corner

	//OPEN DOORWAY IN WHITE ROOM (AFTER OFFICE IS VISITED)
	QCanvasPixmapArray *blackDoorPixmap = new QCanvasPixmapArray("data/images/misc/black_door.png");
	blackDoor = new QCanvasSprite(blackDoorPixmap, mv);
	blackDoor->setZ(-1);			//avatar must be in front of doorway
	blackDoor->move(352,191);		//open doorway covers up closed door

	//PILE OF CARROTS BLOCKING EAST DOOR IN MILK ROOM
	QCanvasPixmapArray *carrotPixmap = new QCanvasPixmapArray("data/images/misc/carrots.png");
	(carrotPixmap->image(0))->setMask((carrotPixmap->image(0))->createHeuristicMask());
	carrotSprite = new QCanvasSprite(carrotPixmap, mv);
	carrotSprite->setZ(-1);			//by default, avatar occludes carrots
	carrotSprite->move(520,255);	//place carrots by east door
	carrotsEaten = false;
	
	//FLASHING SIGN ON VENDING MACHINE
	QCanvasPixmapArray *flashingSignPixmapArray = new QCanvasPixmapArray("data/images/misc/store_sign%1.png", 3);
	flashingSign = new MyFlashingSignSprite(flashingSignPixmapArray, mv);
	
	//TUX AVATAR
	QCanvasPixmapArray *avatarCanvasPixmapArray = new QCanvasPixmapArray("data/images/avatars/tux/tux%1.png", 16);
	for (i=0; i<16; i++) {
		(avatarCanvasPixmapArray->image(i))->setMask((avatarCanvasPixmapArray->image(i))->createHeuristicMask());
		(avatarCanvasPixmapArray->image(i))->setOffset(46, 120);
	}

	//BANKER
	QCanvasPixmapArray *bankerPixmapArray = new QCanvasPixmapArray("data/images/chars/banker%1.png", 6);
	banker = new MyBankerSprite(bankerPixmapArray, mv);

	avatar = new MyAvatarSprite(avatarCanvasPixmapArray, mv);
	avatar->show();

	pendingAction = DO_NOTHING;
	dialogVisible = false;
	avatarDir = 0;
	stepValue = 4;
	avatarDestination = new QPoint(-100,-100);
	currentRoom = BANK;			//player begins in the Bank
	currentObject = -1;			//player has nothing, holds nothing
	score = 0;

	isSound = true;
	isMusic = false;

#ifdef _WS_X11_
	//initialize sound technique (NAS, arts, or Java)
	// 1 = NAS (Qt native sound)
	// 2 = aRts (supported by KDE)
	// 3 = /usr/bin/play
	// 4 = Java (something else to try)

	pid_t pid;
	char errtext[257];
	struct stat statbuf;
	soundStrategy = 5;	//default to Java
	if (QSound::available()) {
		soundStrategy = 1;
		//cout << "using nasd" << endl;
	} else {
		if (GetProcByName("artsd",&pid,errtext,sizeof(errtext)) == 0) {
			soundStrategy = 2;
			//cout << "using artsd" << endl;
		} else {
			if (stat("/usr/bin/play", &statbuf) == 0) {
				soundStrategy = 3;
			//cout << "using play" << endl;
			}
		}
	}
#endif

	//_state = new GameState;
}

void GameData::playSound(QString filename) {
	if (isSound) {
#ifdef _WS_X11_
		QString command = "";
		switch (soundStrategy) {
		case 1:
			QSound::play(filename);
			break;
		case 2:
			command = "artsplay " + filename;
			system((const char *)command);
			break;
		case 3:
			command = "/usr/bin/play " + filename + " &";
			system((const char *)command);
			break;
		case 4:
			command = "java -cp data/audio playSound " + filename + " &";
			system((const char *)command);
			break;
		default:
			break;
		}
#else
		QSound::play(filename);
#endif
	}
}

/*Memento* GameData::createMemento() {
	int i;
	Memento *m = new Memento();
	for (i=0; i<NUM_OBJECTS; i++) {
		_state->objectLocation[i] = objectData[i].location;
		_state->objectX[i] = (int)objectData[i].largeIcon->x();
		_state->objectY[i] = (int)objectData[i].largeIcon->y();
		_state->objectPointsAwarded[i] = objectData[i].pointsAwarded;
	}
	for (i=0; i<NUM_ROOMS; i++) {
		_state->roomVisited[i] = roomData[i].visited;
	}
	_state->avatarX = (int)avatar->x();
	_state->avatarY = (int)avatar->y();
	_state->currentRoom = currentRoom;
	_state->carrotsEaten = carrotsEaten;
	_state->score = score;
	_state->isSound = isSound;
	_state->isMusic = isMusic;
    m->setState(_state);
	return m;
}

Memento* GameData::createEmptyMemento() {
	Memento *m = new Memento();
	return m;
}

void GameData::setMemento(const Memento *m) {
	int i;
	for (i=0; i<NUM_OBJECTS; i++) {
		objectData[i].location = m->_state->objectLocation[i];
		objectData[i].largeIcon->setX(m->_state->objectX[i]);
		objectData[i].largeIcon->setY(m->_state->objectY[i]);
		objectData[i].pointsAwarded = m->_state->objectPointsAwarded[i];
	}
	for (i=0; i<NUM_ROOMS; i++) {
		roomData[i].visited = m->_state->roomVisited[i];
	}
	avatar->setX(m->_state->avatarX);
	avatar->setY(m->_state->avatarY);
	currentRoom = m->_state->currentRoom;
	carrotsEaten = m->_state->carrotsEaten;
	score = m->_state->score;
	isSound = m->_state->isSound;
	isMusic = m->_state->isMusic;
}*/
