/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include "myavatarsprite.h"
#include "gamedata.h"
#include <iostream.h>

extern GameData *gd;

MyAvatarSprite::MyAvatarSprite( QCanvasPixmapArray *a, MyCanvas *can)
						: QCanvasSprite(a, can)
{
	myCanvas = can;
	timer = new QTime();
	setAnimated(true);
	setVelocity(0,0);
	move(550, 450);
	consecutiveCollisionCount = 0;

}	
	
void MyAvatarSprite::advance(int stage) {

	if (stage == 1 && !gd->dialogVisible) {
		moveBy(xVelocity(), yVelocity());

		//advance frame
		if (timer->elapsed() > 200) {
			if (xVelocity() != 0 || yVelocity() != 0) {
				switch(gd->avatarDir) {
					case 0:	//front-left
					setFrame((frame()+1) % 2);
					break;

					case 1:	//left
					setFrame(2 + ((frame()+1) % 4));
					break;

					case 2:	//front_right
					setFrame(6 + ((frame()+1) % 2));
					break;

					case 3:	//right
					setFrame(8 + ((frame()+1) % 4));
					break;

					case 4:	//back
					setFrame(12 + ((frame()+1) % 4));
					break;
				}
			}
			timer->start();
		}

		//allow avatar to move behind/in front of carrot-pile
		if (gd->currentRoom == gd->MILK_ROOM) {
			if (!gd->carrotsEaten) {
				if (y() < 450) {
					gd->carrotSprite->setZ(1);
				} else {
					gd->carrotSprite->setZ(-1);
				}
			}
		}

		collisionList = collisions(false);
		if (!collisionList.isEmpty()) {
			for (QCanvasItemList::Iterator it = collisionList.begin(); it != collisionList.end(); ++it) {
				if (collidesWith(*it)) {
					if (consecutiveCollisionCount++ > 10) {
						for (int i=0; i<NUM_OBJECTS; i++) {
							if (gd->objectData[i].location == gd->currentRoom) {
								if (gd->objectData[i].largeIcon == *it) {
									if (gd->currentObject == -1) {
										if (gd->objectData[i].isTreasure) {
											if (gd->objectData[i].pointsAwarded == 0) {
												QString filename = "data/images/squares/egg.png";
												switch(i) {
													case gd->JEWEL: filename = "data/images/squares/jewel.png"; break;
													case gd->COIN: filename = "data/images/squares/coin.png"; break;
													case gd->VASE: filename = "data/images/squares/vase.png"; break;
												}
												gd->playSound("data/audio/N4treasures.WAV");
												myCanvas->showInfoBox(filename, " This is one of the four treasures\n"
																							" in the Enchanted House.  You can \n"
																							" get points for treasures by\n"
																							" depositing them in the Bank.");
												gd->score += 5;
												gd->objectData[i].pointsAwarded = 5;
												myCanvas->emitScoreChanged();
											}
										}
										if (i == gd->COUPON) {
											gd->playSound("data/audio/Ncoupon.WAV");
											myCanvas->showInfoBox("data/images/squares/coupon.png", " What's this? A coupon for a free \n"
																						" bowl!  If you insert this coupon\n"
																						" into any vending machine, you \n"
																						" will get a nice clean bowl.");
										}
										//pick up whatever you ran into
										myCanvas->emitInventoryItemAdded(i);
									}
								}
							}
						}
					}
				}
			}
		} else {
			consecutiveCollisionCount = 0;
		}

		//check to see if player is on the floor
		if (isInsidePerimeter(gd->roomData[gd->currentRoom].perimeter) && !isInsideDestination()) {
			//check to see if player is in a doorway
			for (int i=0; i < gd->roomData[gd->currentRoom].numPassages; i++) {
				if (isInsidePerimeter((gd->roomData[gd->currentRoom].passageway[i]).perimeter)) {
					setX(gd->roomData[gd->currentRoom].passageway[i].newPos->x());
					setY(gd->roomData[gd->currentRoom].passageway[i].newPos->y());
					gd->currentRoom = gd->roomData[gd->currentRoom].passageway[i].room;
					setVelocity(0,0);
					myCanvas->emitRoomChanged();
				}
			}
		} else {
			moveBy(-xVelocity(), -yVelocity());
			setVelocity(0,0);
			//HERE, check for pendingActions!
			switch (gd->pendingAction) {
				case gd->DO_NOTHING:
				default:
				break;

				case gd->TRYING_LOCKED_DOOR:
				gd->playSound("data/audio/nlockeddoor.WAV");
				myCanvas->showInfoBox("data/images/squares/information.png", " Try as you might, the door is solidly \n"
										" locked shut.  Perhaps it can only be \n"
										" unlocked from the other side...?");
				break;

				case gd->TRYING_LEFT_CHAIR:
				gd->playSound("data/audio/Nouch.WAV");
				myCanvas->showInfoBox("data/images/squares/sitting_on_chair_1.png", " Ouch!  This chair is too hard! ");
				setFrame(0);
				break;

				case gd->TRYING_MIDDLE_CHAIR:
				gd->playSound("data/audio/Noomph.WAV");
				myCanvas->showInfoBox("data/images/squares/sitting_on_chair_2.png", " Oomph!  This chair is too soft! ");
				setFrame(0);
				break;

				case gd->TRYING_RIGHT_CHAIR:
				gd->playSound("data/audio/Nmagicchair.WAV");
				myCanvas->showInfoBox("data/images/squares/sitting_on_chair_3.png", " As you settle down onto the chair, you\n"
										" start feeling dizzy.  The room begins\n"
										" to spin around you, and suddenly everything \n"
										" goes very dark...");
				gd->currentRoom = gd->OFFICE;
				move(487, 456);
				setFrame(0);
				myCanvas->emitRoomChanged();
				break;

				case gd->TRYING_OFFICE_CHAIR:
				gd->playSound("data/audio/nbacktogreenroom.WAV");
				myCanvas->showInfoBox("data/images/squares/sitting_in_office.png", " You sit in the chair, fully expecting\n"
										" to be magically transported back to \n"
										" the Green Room.");
				gd->currentRoom = gd->GREEN_ROOM;
				move(539, 423);
				setFrame(6);
				myCanvas->emitRoomChanged();
				break;

				case gd->FILLING_BOWL:
				gd->playSound("data/audio/Nfullmilk.WAV");
				myCanvas->showInfoBox("data/images/squares/milk_pouring.png", "     GLUG, GLUG, PLINK!\n"
										" Your bowl is now filled with \n"
										" fresh, cold milk.");
				gd->objectData[gd->COLD_MILK].location = gd->MILK_ROOM;
				myCanvas->emitInventoryItemRemoved(gd->EMPTY_BOWL);
				gd->objectData[gd->EMPTY_BOWL].location = -2;
				break;

				case gd->DEPOSITING_COUPON:
				gd->playSound("data/audio/nbowlclank.WAV");
				myCanvas->showInfoBox("data/images/squares/bowl.png", " The coupon disappears into the slot,\n"
										" and the machine blinks and whirrs for \n"
										" a few seconds.\n"
										" CLUNK!  A shiny new bowl drops into\n"
										" the dispenser.");
				gd->objectData[gd->EMPTY_BOWL].location = gd->STORE;
				myCanvas->emitInventoryItemRemoved(gd->COUPON);
				gd->objectData[gd->COUPON].location = -2;
				break;

				case gd->PICKING_UP_MAGAZINE:
				gd->playSound("data/audio/nmagazine.WAV");
				myCanvas->showInfoBox("data/images/squares/magazine.png", " Well, what do you know! \n"
										" You found a genuine copy of the \n"
										" July/August 1980 issue of \"Recreational \n"
										" Computing\" magazine!  It looks \n"
										" strangely familiar to you, although \n"
										" it's hard to say why.");
				myCanvas->emitInventoryItemAdded(gd->MAGAZINE);
				break;

				case gd->FEEDING_NELLAN_WARM_MILK:
				gd->playSound("data/audio/NEwarmmilk.WAV");
				myCanvas->showInfoBox("data/images/squares/nellan_hello.png", " Nellan slowly laps up the milk and\n"
								" politely says, \"Thank you for the milk. \n"
								" Pity it's so warm.\"");
				gd->objectData[gd->EMPTY_BOWL].location = gd->currentRoom;
				gd->objectData[gd->EMPTY_BOWL].largeIcon->move(290,460);
				gd->objectData[gd->EMPTY_BOWL].largeIcon->setZ(2);
				myCanvas->emitInventoryItemRemoved(gd->WARM_MILK);
				gd->objectData[gd->WARM_MILK].location = -2;
				break;

				case gd->FEEDING_NELLAN_COLD_MILK:
				gd->playSound("data/audio/NEcoldmilk.WAV");
				myCanvas->showInfoBox("data/images/squares/nellan_hello.png", " Eagerly, Nellan drinks the milk and licks\n"
								" the bowl clean.  She is purring very loudly.\n"
								" \"Thank you, my friend, for bringing me this\n"
								" lovely cold milk.  I know it was not easy.\n"
								" Please accept this small token of my appreciation.");
				gd->objectData[gd->VASE].location = gd->currentRoom;
				myCanvas->emitInventoryItemRemoved(gd->COLD_MILK);
				gd->objectData[gd->COLD_MILK].location = -2;
				break;

				case gd->DEPOSITING_EGG:
				gd->playSound("data/audio/K_egg.WAV");
				myCanvas->showInfoBox("data/images/squares/banker.png", " The banker, Mr. Klinkoyn, looks happy to \n"
								" see you. \"Ah!  You found my Golden Egg! \n"
								" Thank you for returning it.\" ");
				gd->objectData[gd->EGG].location = -2;
				myCanvas->emitInventoryItemRemoved(gd->EGG);
				break;

				case gd->DEPOSITING_JEWEL:
				gd->playSound("data/audio/K_jewel.WAV");				
				myCanvas->showInfoBox("data/images/squares/banker.png", " The banker, Mr. Klinkoyn, looks happy to \n"
								" see you. \"I've been missing this Jewel!  Thank \n"
								" you for finding it.\" ");
				gd->objectData[gd->JEWEL].location = -2;
				myCanvas->emitInventoryItemRemoved(gd->JEWEL);
				break;

				case gd->DEPOSITING_COIN:
				gd->playSound("data/audio/k_coin.WAV");				
				myCanvas->showInfoBox("data/images/squares/banker.png", " The banker, Mr. Klinkoyn, looks happy to \n"
								" see you. \"This coin has been in the family \n"
								" for a long time.  I'm glad you found it.\" ");
				gd->objectData[gd->COIN].location = -2;
				myCanvas->emitInventoryItemRemoved(gd->COIN);
				break;

				case gd->DEPOSITING_VASE:
				gd->playSound("data/audio/K_vace.WAV");
				myCanvas->showInfoBox("data/images/squares/banker.png", " The banker, Mr. Klinkoyn, looks happy to \n"
								" see you. \"Thank you for finding this \n"
								" vase.  It had been missing a long time!\" ");
				gd->objectData[gd->VASE].location = -2;
				myCanvas->emitInventoryItemRemoved(gd->VASE);
				break;


			}
			//check for an end-of-game condition
			switch (gd->pendingAction) {
				case gd->DEPOSITING_EGG:
				case gd->DEPOSITING_JEWEL:
				case gd->DEPOSITING_COIN:
				case gd->DEPOSITING_VASE:
				if (gd->score == 100) {
					gd->playSound("data/audio/won.WAV");
					myCanvas->showInfoBox("data/images/squares/banker.png", "   Congratulations!!!   \n      YOU WON!!!       ");
					myCanvas->emitEndgame();
				}
				break;
			}
			gd->pendingAction = gd->DO_NOTHING;
		}
		myCanvas->update();

	}
}

bool MyAvatarSprite::isInsideDestination() {
	bool result = false;
	if ((gd->avatarDestination->x() - gd->stepValue < x()) &&
		(x() < gd->avatarDestination->x() + gd->stepValue) &&
		(gd->avatarDestination->y() - gd->stepValue < y()) &&
		(y() < gd->avatarDestination->y() + gd->stepValue)) {
			result = true;
			gd->avatarDestination = new QPoint(-100,-100);
	}
	return result;
}

int MyAvatarSprite::isInsidePerimeter(QPointArray *p) {
	//adapted from http://astronomy.swin.edu.au/pbourke/geometry/insidepoly/
	//by Randolph Franklin
	int i, j, c = 0;
	int npol = p->size();
	int xx = (int)x();
	int yy = (int)y();
	QPoint *pi, *pj;
	//what, you expected this code to make SENSE ?
	for (i = 0, j = npol-1; i < npol; j = i++) {
		pi = new QPoint(p->point(i));
		pj = new QPoint(p->point(j));
		if ((((pi->y() <= yy) && (yy < pj->y() )) || ((pj->y() <= yy) && (yy < pi->y() ))) &&
			(xx < (pj->x() - pi->x()) * (yy - pi->y() ) / (pj->y() - pi->y() ) + pi->x() ))
				c = !c;
	}
	return c;
}
