/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#include "mycanvas.h"
#include "gamedata.h"
#include "infobox.h"
#include <iostream.h>

extern GameData *gd;

MyCanvas::MyCanvas(QObject *parent, const char *name)
				: QCanvas (parent, name)
{
	connect(this, SIGNAL(roomChanged()), this, SLOT(refreshScene()));
	resize(800, 510);
	setAdvancePeriod(50);
}

void MyCanvas::hideAllSprites() {
	for (int i=0; i<NUM_OBJECTS; i++) {
		gd->objectData[i].largeIcon->hide();
	}
	gd->catSprite->hide();
	gd->flashingSign->hide();
	gd->blackDoor->hide();
	gd->carrotSprite->hide();
	gd->banker->hide();
}

void MyCanvas::refreshScene() {
	InfoBox *ib;
	setBackgroundPixmap(*(gd->roomData[gd->currentRoom].roomImage));
	hideAllSprites();

	for (int i=0; i<NUM_OBJECTS; i++) {
		if (gd->objectData[i].location == gd->currentRoom) {
			gd->objectData[i].largeIcon->show();
		}
	}
	switch(gd->currentRoom) {
		case gd->BANK:
		gd->banker->strikeAPose();
		break;

		case gd->GREEN_ROOM:
		break;

		case gd->CAT_ROOM:
		gd->catSprite->show();
		if (!gd->roomData[gd->CAT_ROOM].visited) {
			gd->playSound("data/audio/Ncat.WAV");
			ib = new InfoBox("data/images/squares/nellan_hello.png", " Wow!  You've never seen a cat this big\n"
														" before.  She smiles at you and says, \"Hello,\n"
														" my friend.  My name is Nellan.  I'm so thirsty.\n"
														" Would you be kind enough to bring me some cold \n"
														" milk?  I must warn you; it won't be easy.\n"
														" But I think you are clever enough to do it.\"", (QWidget*)parent());
			ib->exec();
		}
		break;

		case gd->WHITE_ROOM:
		if (gd->roomData[gd->OFFICE].visited) {
			gd->blackDoor->show();
		}
		if (!gd->roomData[gd->WHITE_ROOM].visited) {
			gd->playSound("data/audio/HiCulla.WAV");
			ib = new InfoBox("data/images/squares/chula_hello.png", " A fluffy white rabbit hops up to you\n"
													" and says, \"Hi, my name's Chula!  Welcome \n"
													" to the Enchanted House, my friend!\"\n"
													" She gives you a hug and says, \"If you\n"
													" pick me up and carry me to the room\n"
													" to the right, I'll give you a\n"
													" present that I saved for you.\"", (QWidget*)parent());
			ib->exec();
		}
		break;

		case gd->GOLD_ROOM:
		if (gd->objectData[gd->CHULA].location == -1) {		//if we're carrying the rabbit
			if (gd->objectData[gd->EGG].location == -2 &&	//and the egg is still hidden...
				gd->objectData[gd->EGG].pointsAwarded == 0) {	//and we haven't picked up the egg yet
				gd->playSound("data/audio/Nchulaegg.WAV");
 				ib = new InfoBox("data/images/squares/chula_egg.png", " Chula hops out of your arms and runs \n"
															" off.  A moment later she returns with\n"
															" a large golden egg.", (QWidget*)parent());
				ib->exec();
				gd->objectData[gd->EGG].location = gd->GOLD_ROOM;
				gd->objectData[gd->EGG].largeIcon->move(363, 380);
				gd->objectData[gd->EGG].largeIcon->setZ(2);
				gd->objectData[gd->CHULA].location = gd->GOLD_ROOM;
				gd->objectData[gd->CHULA].largeIcon->move(263, 330);
				gd->objectData[gd->CHULA].largeIcon->setZ(2);
				emit inventoryItemRemoved(gd->CHULA);
			}	
		}
		break;

		case gd->HOT_ROOM:
		if (!gd->roomData[gd->HOT_ROOM].visited) {
			gd->playSound("data/audio/nhotinhere.WAV");
			ib = new InfoBox("data/images/squares/thermometer.png", " Whew! It's hot in here! ", (QWidget*)parent());
			ib->exec();
		}
		if (gd->objectData[gd->COLD_MILK].location == -1) {
			emit milkWarmed();
			gd->playSound("data/audio/Nwarmmilk.WAV");
			ib = new InfoBox("data/images/squares/milk_warmed.png", " Because this room is so hot, the\n"
														" milk in your bowl becomes warm. ", (QWidget*)parent());
			ib->exec();
		}
		break;

		case gd->OFFICE:
		if (!gd->roomData[gd->OFFICE].visited) {
			gd->playSound("data/audio/Noffice.WAV");
			ib = new InfoBox("data/images/squares/sitting_in_office.png", " WOW!  That chair must have been magic!\n"
													" You find yourself in an old, dusty office.\n"
													" You get the impression that no one has set \n"
													" foot inside this room for many years.", (QWidget*)parent());
			ib->exec();
			gd->roomData[gd->WHITE_ROOM].perimeter->setPoint(7, 398, 341);
		}
		break;

		case gd->MILK_ROOM:
		if (!gd->carrotsEaten) {
			gd->carrotSprite->show();
		}
		break;

		case gd->STORE:
		gd->flashingSign->show();
		break;
	}
	gd->roomData[gd->currentRoom].visited = true;
	update();
}

void MyCanvas::emitRoomChanged() {
	emit roomChanged();
}

void MyCanvas::emitScoreChanged() {
	emit scoreChanged();
}

void MyCanvas::emitInventoryItemAdded(int id) {
	emit inventoryItemAdded(id);
}

void MyCanvas::emitInventoryItemRemoved(int id) {
	emit inventoryItemRemoved(id);
}

void MyCanvas::emitEndgame() {
	emit endgame();
}

void MyCanvas::showInfoBox(QString filename, QString msg) {
	InfoBox *ib;
	ib = new InfoBox(filename, msg, (QWidget*)parent());
	ib->exec();
}

