/******************************************
THIRSTY NELLAN
An 3D Animated Adventure Game for children
Copyright (C) 2002 Geoffrey M. Draper

This file is part of Thirsty Nellan.
Thirsty Nellan is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Thirsty Nellan is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Thirsty Nellan; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

As a special exception, the copyright holder (Geoffrey
M. Draper) gives permission to link this program with
Qt non-commercial edition, and distribute the resulting
executable, without including the source code for the
Qt non-commercial edition in the source distribution.
(This clause applies only to Windows version of the software.)

******************************************/

#ifndef MY_CANVAS_H
#define MY_CANVAS_H

#include <qcanvas.h>

class MyCanvas : public QCanvas {
	Q_OBJECT

public:
	MyCanvas(QObject *parent=0, const char *name=0);
	void hideAllSprites();
	void emitRoomChanged();
	void emitScoreChanged();
	void emitInventoryItemAdded(int id);
	void emitInventoryItemRemoved(int id);
	void emitEndgame();
	void showInfoBox(QString filename, QString msg);

public slots:
	void refreshScene();

signals:
	void roomChanged();
	void milkWarmed();
	void inventoryItemAdded(int id);
	void inventoryItemRemoved(int id);
	void scoreChanged();
	void endgame();
};

#endif
