package projman;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingConstants;
import javax.swing.TransferHandler;

public class CandidateList extends JComponent implements ActionListener {
	private final Ward ward;
	private Auxiliary currentAuxiliary;	//EQ, HPG, or RS?
	private final EntityStatus teachStatus;	//is this a list of teachers or teachees?
	private JList peopleListBox;
	private JLabel label;
	private DefaultListModel listModel;
	private MyCellRenderer customRenderer;
	private JScrollPane listScroller;
	private static final long serialVersionUID = 42L;
	
	
	//hack so that when we drag an individual to the whiteboard, DnD can
	//tell by querying the JList if the individual came from a teacher
	//list or a teachee list.
	public class TeachingJList extends JList {
		public EntityStatus status;
		public TeachingJList(ListModel model, EntityStatus status) {
			super(model);
			this.status = status;
		}
		public boolean handleDrop(Entity entity, EntityStatus status) {
			if (this.status == status) {
				ward.assignmentsChanged();
			}
			return (this.status == status);
		}
	}
	
	public CandidateList(Ward w, Auxiliary aux, EntityStatus status) {
		ward = w;
		teachStatus = status;
		listModel = new DefaultListModel();
		customRenderer = new MyCellRenderer();
		setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		label = new JLabel();
		label.setHorizontalAlignment(SwingConstants.CENTER);
		add(label);
		peopleListBox = new TeachingJList(listModel, status);
		peopleListBox.setCellRenderer(customRenderer);
		peopleListBox.setBorder(BorderFactory.createEtchedBorder());
		peopleListBox.setDragEnabled(true);
		
		MouseListener mouseListener = new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON1) {
					int index = peopleListBox.locationToIndex(e.getPoint());
					handleEditEvent(index);
				}
			}
			
			//we check for popup triggers in both mousePressed
			//and mouseReleased for correct cross-platform behavior
			@Override
			public void mousePressed(MouseEvent e) {
				if (e.isPopupTrigger()) {
					drawPopupMenu(e.getPoint());
				}
			}
			
			@Override
			public void mouseReleased(MouseEvent e) {
				if (e.isPopupTrigger()) {
					drawPopupMenu(e.getPoint());
				}
			}
			
		};
		peopleListBox.addMouseListener(mouseListener);
		
		peopleListBox.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_DELETE) {
					handleActionEvent(Constants.DELETE_BUTTON_LABEL);
				}
			}
		});
		
		listScroller = new JScrollPane(peopleListBox);
		listScroller.setAlignmentX(LEFT_ALIGNMENT);
		add(listScroller);
		refresh(aux);
	}
	
	private void drawPopupMenu(Point absXY) {
		Point relXY = new Point(absXY.x,  absXY.y - listScroller.getViewport().getViewPosition().y);
		int mouseOverIndex = peopleListBox.locationToIndex(absXY);
		if (!peopleListBox.isSelectedIndex(mouseOverIndex)) {
			//if the item the user clicked on isn't selected,
			//de-select whatever was  previously selected and
			//make that item selected.
			peopleListBox.clearSelection();
			peopleListBox.setSelectedIndex(mouseOverIndex);
		}
		int indices[] = peopleListBox.getSelectedIndices();
		JPopupMenu menu = new JPopupMenu();
		JMenuItem menuItem = new JMenuItem(Main.messages.getString(Constants.ADD_NEW_BUTTON_LABEL));
		menuItem.setActionCommand(Constants.ADD_NEW_BUTTON_LABEL);
		menuItem.addActionListener(CandidateList.this);
		menu.add(menuItem);
		if (indices.length == 1) {
			menuItem = new JMenuItem(Main.messages.getString(Constants.EDIT_BUTTON_LABEL));
			menuItem.setActionCommand(Constants.EDIT_BUTTON_LABEL);
			menuItem.addActionListener(CandidateList.this);
			menu.add(menuItem);
		}
		if (indices.length > 0) {
			menuItem = new JMenuItem(Main.messages.getString(Constants.DELETE_BUTTON_LABEL));
			menuItem.setActionCommand(Constants.DELETE_BUTTON_LABEL);
			menuItem.addActionListener(CandidateList.this);
			menu.add(menuItem);
		}
		menu.show(this, relXY.x, relXY.y);
	}
	
	
	public void refresh(Auxiliary aux) {
		//Main.say("CandidateList: called refresh()");
		currentAuxiliary = aux;
		String labelText;
		listModel.clear();
		
		//display the correct label for this particular list
		if (teachStatus == EntityStatus.PROJECT) {
			labelText = Main.messages.getString(Constants.AVAILABLE_HOME_TEACHERS);
		} else {
			labelText = Main.messages.getString(Constants.NEEDING_HOME_TEACHERS);
		}
		label.setText(labelText);

		if (teachStatus == EntityStatus.PROJECT) {
			for (Resource f : ward.getAllResources()) {
				listModel.addElement(f);
			}
		} else {
			for (Project f : ward.getAllProjects()) {
				if (f.getTeachers() == null) {
					listModel.addElement(f);
				}
			}
		}
	}
	
	private void handleEditEvent(int index) {
		if (index != -1) {
			Entity obj = (Entity)listModel.get(index);
			ward.displayEditSomethingDialog(obj);
		}
	}
	
	private void handleAddNewEvent() {
		if (teachStatus == EntityStatus.RESOURCE) {
			ward.displayNewProjectDialog(Main.instance(), currentAuxiliary);
		} else {
			ward.displayNewResourceDialog(Main.instance(), currentAuxiliary);
		}
	}
	
	private void handleDeleteEvent(int indices[]) {
		if (indices.length != -1) {
			Entity obj = (Entity)listModel.get(indices[0]);
			if (obj instanceof Project) {
				ward.deleteProjects(listModel, indices);
			}
			if (obj instanceof Resource) {
				ward.deleteResources(listModel, indices);
			}
		}
	}
	
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		handleActionEvent(command);
	}
	
	private void handleActionEvent(String command) {
		if (command.equals(Constants.ADD_NEW_BUTTON_LABEL)) {
			handleAddNewEvent();
		}
		if (command.equals(Constants.EDIT_BUTTON_LABEL)) {
			handleEditEvent(peopleListBox.getSelectedIndex());
		}
		if (command.equals(Constants.DELETE_BUTTON_LABEL)) {
			handleDeleteEvent(peopleListBox.getSelectedIndices());
		}
	}
	
//	public TeacherOrTeachee getCurrentSelection() {
//		return (TeacherOrTeachee)peopleListBox.getSelectedValue();
//	}
	
	public void setCustomTransferHandler(TransferHandler h) {
		peopleListBox.setTransferHandler(h);
	}
	
	private class MyCellRenderer extends JLabel implements ListCellRenderer {
		
		private static final long serialVersionUID = 42L;
		
		public Component getListCellRendererComponent(
				JList list,
				Object value,            // value to display
				int index,               // cell index
				boolean isSelected,      // is the cell selected
				boolean cellHasFocus)    // the list and the cell have the focus
		{
			String s = "";
			if (value instanceof Entity) {
				s = ((Entity)value).getName();
				if (value instanceof ResourceBase) {
					s += (" (" + ((ResourceBase)value).getCompanionships().size() + ")");
				}
			}
			setText(s);
			if (isSelected) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
			}
			else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}
			setEnabled(list.isEnabled());
			setFont(list.getFont());
			setOpaque(true);
			return this;
		}
	}
}