package projman;


import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;

import projman.DiffWard.Status;
import projman.AbstractWhiteboard.ChartStyle;

public class Config {
	public static int db_distanceBetweenWindowEdgeAndOuterRadius;
	public static int db_regularWedgeThickness;
	public static int db_zoomWedgeThickness[];
	public static int db_numberOfZoomWedgeSizes;
	public static int db_progressWedgeThickness;
	public static int db_distanceBetweenRegularAndProgressWedge;
	public static int db_totalNumberOfRadii;
	public static int db_flyingCardSteps;
	public static Color textColor;
	public static Color backgroundColor;
	public static Color circleBackgroundColor;
	private static Color cardBorderColor;
	public static Color projectBorderColor;
	public static Color resourceBorderColor;
	public static Color skillBorderColor;
	public static int db_distanceBetweenOuterRadiusAndLabel;
	public static Color db_homeTeachingArrowColor;
	public static Color db_visitingTeachingArrowColor;
	public static Color wb_teamConnectionColor;
	public static int db_numProgressSegments;
	public static int wb_distanceBetweenCards;
	public static Color wb_selectedTeamBorderColor;
	public static boolean antialias;
	public static boolean db_zoom;
	public static boolean db_frills;
	public static boolean db_animate;
	public static boolean db_newStyle;
	public static Color unfinishedProjectColor;
	public static Color resourceColor;
	public static Color skillColor;
	public static Color eqColor;
	public static Color hpColor;
	public static Color rsColor;
	public static Color eqColor_light;
	public static Color hpColor_light;
	public static Color rsColor_light;
	public static Color notTeachableColor;
	public static Color db_ringBorderColor;
	public static final Auxiliary DEFAULT_AUX = Auxiliary.ELDERS_QUORUM;
	public static final ChartStyle DEFAULT_CHARTSTYLE = ChartStyle.VERTICAL;
	public static Color wb_lassoColor;
	public static Color oldEntityColor;
	public static Color newEntityColor;
	public static Font regularFont;
	public static int regularFontSize;
	public static int largeFontSize;
	public static Font largeFont;
	public static Stroke regularLine;
	public static Stroke thickLine;
	public static Stroke thinLine;
	public static int numbprojectcolors=10;
	public static Color projectColor [];
	public static Color projectProgressColor [];
	public static int db_millisecondsBetweenWedgeAnimationFrames;

	public static void init() {
		antialias = true;
		db_zoom = false;
		db_animate = true;
		db_newStyle = false;
		db_frills = true;
		db_distanceBetweenWindowEdgeAndOuterRadius = 30;
		db_regularWedgeThickness = 50;
		db_numberOfZoomWedgeSizes = 3;
		db_zoomWedgeThickness = new int[db_numberOfZoomWedgeSizes];
		for (int i=0; i<db_numberOfZoomWedgeSizes; ++i) {
			//let the zoom wedges gradually decrease in size.
			db_zoomWedgeThickness[i] = db_regularWedgeThickness + 
			(int)(db_regularWedgeThickness*Math.cos(i * ((Math.PI/2)/db_numberOfZoomWedgeSizes)));
		}
		db_distanceBetweenRegularAndProgressWedge = 5;
		db_progressWedgeThickness = 50;
		db_numProgressSegments = 4;
		db_totalNumberOfRadii = db_numProgressSegments + 3;
		db_millisecondsBetweenWedgeAnimationFrames = 25;
		db_flyingCardSteps = 5;
		textColor = Color.BLACK;
		backgroundColor = new Color(248,248,248);
		circleBackgroundColor = new Color(244,239,227);
		db_distanceBetweenOuterRadiusAndLabel = 5;
		wb_distanceBetweenCards = 30;
		eqColor = Color.GREEN;
		hpColor = Color.ORANGE;
		rsColor = Color.PINK;
		eqColor_light = new Color(128,255,128);//light green
		hpColor_light = new Color(255,214,128);//light orange
		rsColor_light = new Color(255,209,209);//lighter pink
		notTeachableColor = Color.LIGHT_GRAY;
		oldEntityColor = notTeachableColor;
		newEntityColor = Color.YELLOW;
		cardBorderColor = new Color(28,47,72);
		projectBorderColor = cardBorderColor;
		resourceBorderColor = cardBorderColor;
		skillBorderColor = cardBorderColor;		
		wb_selectedTeamBorderColor = Color.RED;
		db_homeTeachingArrowColor = new Color(85,103,116);
		db_visitingTeachingArrowColor = rsColor;
		wb_teamConnectionColor = Color.BLUE;
		db_ringBorderColor = new Color(211,78,78);
		projectColor =new Color[numbprojectcolors];
		projectColor [0] = new Color(244,249,161);//yellow-green
		projectColor [1] = new Color(255,249,161);//yellow
		projectColor [2]= new Color(254,230,132);//gold
		projectColor [3]= new Color(254,196,132);//orange
		projectColor [4]= new Color(252, 185, 150);//pink/orange
		projectColor [5]= new Color(239,169,159);//pink
		projectColor [6]= new Color(239,169,179);//pink/purple
		projectColor [7]= new Color(211,161,178);//dark Purple
		projectColor [8]= new Color(234,201,208);//red
		projectColor [9]= new Color(234,201,185);//red

		projectProgressColor =new Color[numbprojectcolors];
		projectProgressColor [0] = new Color (246,249,187);//yellow-green
		projectProgressColor [1] = new Color (255,252,212);//yellow
		projectProgressColor [2]= new Color(254,236,161);//orange
		projectProgressColor [3]= new Color(254,221,185);//purple
		projectProgressColor [4]= new Color(252, 221, 205);//pink/orange
		projectProgressColor [5]= new Color(239,213,209);//pink
		projectProgressColor [6]= new Color(239,217,221);//pink-purple
		projectProgressColor [7]= new Color(237,210,219);//dark Purple
		projectProgressColor [8]= new Color(242,228,231);//red
		projectProgressColor [9]= new Color(234,218,210);//red

		resourceColor = new Color(152,181,198);//blue
		skillColor = new Color(191,231,148);//green
		wb_lassoColor = Color.GRAY;
		regularFontSize = 15;//12;
		regularFont = new Font("Arial", Font.BOLD, regularFontSize);
		largeFontSize = 20;
		largeFont = new Font("Arial", Font.BOLD, largeFontSize);
		regularLine = new BasicStroke(2);
		thickLine = new BasicStroke(4);
		thinLine = new BasicStroke(1);
	}

	public static Color getColorForEntity(Entity family) {
		return getColorForEntity(family, Status.SAME);
	}

	public static Color getColorForEntity(Entity family, Status diffStatus) {
		Color result = skillColor;

		if (diffStatus == Status.OLD) {
			result = oldEntityColor;
		} else {
			if (family instanceof Project) {
				Project p = (Project)family;
				int index = p.getWard().getAllProjects().indexOf(p);
				result = projectColor[index % Config.numbprojectcolors];
			} else if (family instanceof Resource) {
				result = resourceColor;
			} else {
				result = skillColor;
			}
		}

		return result;
	}

	public static Color getProgressColor(Project p) {
		Color result;
		int index = p.getWard().getAllProjects().indexOf(p);
		result = projectProgressColor[index % Config.numbprojectcolors];
		return result;
	}

	public static Color getBorderColorForEntity(Entity family) {
		Color result;

		if (family instanceof Project) {
			result = projectBorderColor;
		} else if (family instanceof Resource) {
			result = resourceBorderColor;
		} else {
			result = skillBorderColor;
		}

		return result;
	}

}
