package projman;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;

import projman.DiffWard.Status;

public class DiffArrow extends Arrow {
	
	private Status diffStatus;
	private static final float SPACING = 25;//15
	private static final float THRESHOLD = SPACING*SPACING;
	private static final int SEGMENT_LENGTH = 10;//4
	
	public DiffArrow(final Point2D p1, final Point2D p2, final Entity from, final Entity to, final Status status) {
		super(p1, p2, from, to);
		diffStatus = status;
	}
	
	@Override
	public void draw(Graphics2D g, Color color) {
		Stroke formerStroke = g.getStroke();
		g.setColor(color);
		
		if (diffStatus == Status.SAME) {
			g.setStroke(Config.regularLine);
			g.drawLine(startPoint.x, startPoint.y, endPoint.x, endPoint.y);
		} else {
			//draw cute "artistic" arrows:
			//plot points every few spaces. For OLD lines,
			//plot a minus sign. For NEW lines, plot a plus sign.
			g.setStroke(Config.regularLine);//thinLine
			if (endPoint != null && startPoint != null) {
				float rise, run;//, slope;
				rise = endPoint.y - startPoint.y;
				run = endPoint.x - startPoint.x;
				float stepX = 0, stepY = 0;
				if (Math.abs(rise) >= Math.abs(run)) {
					//go mostly vertical
					stepY = Math.signum(rise) * SPACING;
					if (rise != 0) stepX = run / Math.abs(rise / SPACING); 
				} else {
					stepX = Math.signum(run) * SPACING;
					if (run != 0) stepY = rise / Math.abs(run / SPACING); 
				}
				Point2D.Float current = new Point2D.Float(startPoint.x+stepX, startPoint.y+stepY);
				while (current.distanceSq(endPoint) > THRESHOLD) {
					if (diffStatus == Status.OLD) {
						drawMinusSign(g, current);
					} else {
						drawPlusSign(g, current);
					}
					current.x += stepX;
					current.y += stepY;
				}
			}
		}
		g.setStroke(formerStroke);
	}
	
	private void drawMinusSign(Graphics2D g, Point2D.Float cur) {
		g.drawLine((int)cur.x-SEGMENT_LENGTH, (int)cur.y, (int)cur.x+SEGMENT_LENGTH, (int)cur.y);
	}
	
	private void drawPlusSign(Graphics2D g, Point2D.Float cur) {
		g.drawLine((int)cur.x-SEGMENT_LENGTH, (int)cur.y, (int)cur.x+SEGMENT_LENGTH, (int)cur.y);
		g.drawLine((int)cur.x, (int)cur.y-SEGMENT_LENGTH, (int)cur.x, (int)cur.y+SEGMENT_LENGTH);
	}

}
