package projman;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import projman.DiffWard.Status;

/**
 * See the FIXME comment in DiffWard.
 *
 */
public class DiffResource implements Comparable<DiffResource>, Serializable {
	private Resource resource;
	private DiffWard.Status resourceStatus;
	private Map<String, Status> skills;
	
	public DiffResource(Resource r, Status s) {
		resource = r;
		resourceStatus = s;
		skills = new HashMap<String, Status>();
	}
	
	public Resource getResource() {
		return resource;
	}

	public DiffWard.Status getResourceStatus() {
		return resourceStatus;
	}
	
	public Set<String> getSkills() {
		return skills.keySet();
	}
	
	public DiffWard.Status getSkillStatus(String s) {
		return skills.get(s);
	}
	
	public DiffResource computeDifferences(Ward ward1, Ward ward2) {
		//if the resource did not exist in one or the other of the two charts,
		//then there's no need to check whether its skills changed from one
		//chart to the other. Thus, add its skills to the "diffcomp"
		//either as "old" or "new", depending on whether the resource existed
		//in chart 1 or chart 2, respectively.
		if (resourceStatus == Status.OLD || resourceStatus == Status.NEW) {
			Set<Skill> ss = resource.getSkillSet();
				for (Skill k : ss) {
					//diffComp.add(r, resourceStatus);
					skills.put(k.getName(), resourceStatus);
				}
		} else {
			//If the resource does exist in both charts, then check to see which
			//of its skills it also had in chart 1, 2, or both.
			Set<Skill> skills1 = ward1.getResourceByName(resource.getName()).getSkillSet();
			Set<Skill> skills2 = ward2.getResourceByName(resource.getName()).getSkillSet();
			List<Skill> unmatchedSkills1 = new LinkedList<Skill>();
			List<Skill> unmatchedSkills2 = new LinkedList<Skill>();
			
			//populate unmatched skills arrays
			for (Skill s : skills1) {
				unmatchedSkills1.add(s);
			}
			for (Skill s : skills2) {
				unmatchedSkills2.add(s);
			}
			
			//find diffs in the skills
			for (Skill res1 : skills1) {
				for (Skill res2 : skills2) {
					if (res1.equals(res2)) {
						//Main.say("both charts have a skill called: " + res1.getName());
						unmatchedSkills1.remove(res1);
						unmatchedSkills2.remove(res2);
						//diffWard.add(res1, Status.SAME);
						skills.put(res1.getName(), Status.SAME);
						break;
					}
				}
			}
			for (Skill p : unmatchedSkills1) {
				///Main.say("Chart 1 has a skill called " + p.getName() + " that does not exist in chart 2.");
				//diffWard.add(p, Status.OLD);
				skills.put(p.getName(), Status.OLD);
			}
			for (Skill p : unmatchedSkills2) {
				//Main.say("Chart 2 has a skill called " + p.getName() + " that does not exist in chart 1.");
				//diffWard.add(p, Status.NEW);
				skills.put(p.getName(), Status.NEW);
			}

		}
		
		return this;
	}

	//TODO figure out why some compilers like this and some don't.
	//@Override
	public int compareTo(DiffResource o) {
		return resource.compareTo(o.resource);
	}

}
