package projman;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class DraggedSelection implements Transferable {

	private Entity data;
	private EntityStatus status;

    /**
     * Creates a <code>Transferable</code> capable of transferring
     * the specified <code>TeacherOrTeachee</code>.
     */
	public DraggedSelection(Entity t, EntityStatus s) {
		data = t;
		status = s;
	}
	
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] {EntityTransferHandler.getMemberDataFlavor()};
	}

	public boolean isDataFlavorSupported(DataFlavor flavor) {
		if (flavor.equals(EntityTransferHandler.getMemberDataFlavor())) return true;
		return false;
	}

	public Object getTransferData(DataFlavor flavor)
			throws UnsupportedFlavorException, IOException {
		if (flavor.equals(EntityTransferHandler.getMemberDataFlavor())) {
			return this;
		} else {
			throw new UnsupportedFlavorException(flavor);
		}
	}
	
	public Entity getEntity() { return data; }
	public EntityStatus getTeachingStatus() { return status; }

}
