package projman;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditSkillDialog extends JDialog implements ActionListener {
	private Skill brother;
	private JTextField nameTextField;
	private static final long serialVersionUID = 42L;
	
	public EditSkillDialog(Dialog parent, boolean existing, Skill guy) {
		super(parent, true);
		init(existing, guy, parent);
	}
	
	public EditSkillDialog(Frame parent, boolean existing, Skill guy) {
		super(parent, true);
		init(existing, guy, parent);
	}
	
	private void init(boolean existing, Skill guy, Component parent) {
		if (existing) {
			setTitle(Main.messages.getString(Constants.EDIT_SKILL_DIALOG_TITLE));
		} else {
			setTitle(Main.messages.getString(Constants.ADD_NEW_SKILL_DIALOG_TITLE));
		}
		this.brother = guy;
		buildGUI(existing);
		setResizable(false);
		pack();
		
		//position this dialog in the middle of its parent window
		Rectangle parentBounds = parent.getBounds();
		Dimension mySize = getSize();
		setLocation(parentBounds.x + parentBounds.width/2 - mySize.width/2,
				parentBounds.y + parentBounds.height/2 - mySize.height/2);

		
		//treat a window-closing event as if the user
		//had clicked the "cancel" button.
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent event) {
				handleActionEvent(Constants.CANCEL_BUTTON_LABEL);
			}
		});

		setVisible(true);

	}
	
	private void buildGUI(boolean editExisting) {
		setLayout(new BoxLayout(getContentPane(), BoxLayout.PAGE_AXIS));
		JPanel namePanel = new JPanel();
		JLabel nameLabel = new JLabel(Main.messages.getString(Constants.ENTER_SKILL_NAME_DIALOG_LABEL));
		nameTextField = new JTextField();
		if (!editExisting) {
			nameTextField.setText(Main.messages.getString(Constants.DEFAULT_SKILL_NAME));
			nameTextField.select(0, Main.messages.getString(Constants.DEFAULT_SKILL_NAME).length());
		} else {
			nameTextField.setText(brother.getName());
		}
		namePanel.add(nameLabel);
		namePanel.add(nameTextField);
				
		JPanel okCancelPanel = new JPanel();
		okCancelPanel.setLayout(new FlowLayout(FlowLayout.RIGHT));
		JButton okButton = new JButton(Main.messages.getString(Constants.OK_BUTTON_LABEL));
		getRootPane().setDefaultButton(okButton);
		JButton cancelButton = new JButton(Main.messages.getString(Constants.CANCEL_BUTTON_LABEL));
		okCancelPanel.add(okButton);
		okCancelPanel.add(cancelButton);
		
		okButton.setActionCommand(Constants.OK_BUTTON_LABEL);
		cancelButton.setActionCommand(Constants.CANCEL_BUTTON_LABEL);
		okButton.addActionListener(this);
		cancelButton.addActionListener(this);
		
		add(namePanel);
		add(okCancelPanel);
	}

	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		handleActionEvent(command);
	}
	
	private void handleActionEvent(String command) {
		if (command.equals(Constants.CANCEL_BUTTON_LABEL)) {
			brother.setChanged(false);
		}
		if (command.equals(Constants.OK_BUTTON_LABEL)) {
			//TODO check if this skill already exists in the organization
			brother.setName(nameTextField.getText());
			brother.setChanged(true);
		}
		setVisible(false);
	}
	
	public Skill getSkill() {
		return brother;
	}

}
