package projman;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;

import projman.Project.Priority;
import projman.Ward.WardListener;

public class Main extends JFrame implements ActionListener, MouseListener {
	private static Main instance = null;
	private int windowWidth, windowHeight;
	private Auxiliary currentAuxiliary;
	private static Ward ward;
	private JTabbedPane tabbedPane;
	private WhiteboardTab whiteboardTab;
	private DartboardTab dartboardTab;
	public static ResourceBundle messages;
	private static final long serialVersionUID = 42L;
	private boolean testing = false;

	public static Main instance() {
		if(instance == null) {
			instance = new Main();
		}
		return instance;
	}

	protected Main() {
		super(messages.getString(Constants.PROGRAM_TITLE));

		windowWidth = 900;//799;
		windowHeight = 875;//500;
		Dimension dim = new Dimension(windowWidth, windowHeight);
		setPreferredSize(dim);

		//enable smooth window resizing
		//TODO this may not be necessary in JDK1.6
		Toolkit.getDefaultToolkit().setDynamicLayout(true);

		if (!testing) {
			//attempt to load previous session
			try {
				FileInputStream in = new FileInputStream(Constants.DATA_DIR + "/" + Constants.MEMENTO_FILENAME);
				ObjectInputStream s = new ObjectInputStream(in);
				currentAuxiliary = (Auxiliary)s.readObject();
				ward = (Ward)s.readObject();
				whiteboardTab = new WhiteboardTab(ward, currentAuxiliary);
				whiteboardTab.restoreState(s);
			} catch (Exception e) {
				//couldn't load previous session. Start with
				//empty ward and default auxiliary
				currentAuxiliary = Config.DEFAULT_AUX;
				ward = new Ward();
				whiteboardTab = new WhiteboardTab(ward, currentAuxiliary);
			}
			whiteboardTab.setCurrentAuxiliary(currentAuxiliary);//make sure we show the right cards
		} else {
			currentAuxiliary = Config.DEFAULT_AUX;
			ward = new Ward();
			whiteboardTab = new WhiteboardTab(ward, currentAuxiliary);
			whiteboardTab.setCurrentAuxiliary(currentAuxiliary);//make sure we show the right cards
			movieSetup();
			//testing();
		}
		dartboardTab = new DartboardTab(ward);

		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		//create File menu
		JMenu fileMenu = new JMenu(messages.getString(Constants.FILE_MENU));
		JMenuItem menuItem;
		fileMenu.setMnemonic(KeyEvent.VK_F);
		menuItem = new JMenuItem("Export...");
		menuItem.setActionCommand("EXPORT");
		menuItem.addActionListener(this);
		fileMenu.add(menuItem);
		menuItem = new JMenuItem("Compare Two Charts...");
		menuItem.setActionCommand("COMPARE2");
		menuItem.addActionListener(this);
		fileMenu.add(menuItem);
		menuItem = new JMenuItem("Compare With Current...");
		menuItem.setActionCommand("COMPARE1");
		menuItem.addActionListener(this);
		fileMenu.add(menuItem);
		menuItem = new JMenuItem(messages.getString(Constants.EXIT_MENU_OPTION), KeyEvent.VK_X);
		menuItem.setActionCommand(Constants.EXIT_MENU_OPTION);
		menuItem.addActionListener(this);
		fileMenu.add(menuItem);

		//create Family menu
		JMenu familyMenu = new JMenu(messages.getString("FAMILY_MENU"));
		familyMenu.setMnemonic(KeyEvent.VK_E);
		menuItem = new JMenuItem(messages.getString(Constants.EDIT_RESOURCES_MENU_OPTION));
		menuItem.setActionCommand(Constants.EDIT_RESOURCES_MENU_OPTION);
		menuItem.addActionListener(this);
		familyMenu.add(menuItem);
		menuItem = new JMenuItem(messages.getString(Constants.EDIT_PROJECTS_MENU_OPTION));
		menuItem.setActionCommand(Constants.EDIT_PROJECTS_MENU_OPTION);
		menuItem.addActionListener(this);
		familyMenu.add(menuItem);
		menuItem = new JMenuItem(messages.getString(Constants.EDIT_SKILLS_MENU_OPTION));
		menuItem.setActionCommand(Constants.EDIT_SKILLS_MENU_OPTION);
		menuItem.addActionListener(this);
		familyMenu.add(menuItem);

		//create Help menu
		JMenu helpMenu = new JMenu(messages.getString(Constants.HELP_MENU));
		helpMenu.setMnemonic(KeyEvent.VK_H);
		menuItem = new JMenuItem(messages.getString(Constants.ABOUT_MENU_OPTION));
		menuItem.setActionCommand(Constants.ABOUT_MENU_OPTION);
		menuItem.addActionListener(this);
		helpMenu.add(menuItem);

		menuBar.add(fileMenu);
		menuBar.add(familyMenu);
		menuBar.add(helpMenu);

		//create tool bar;
		JToolBar toolBar = new JToolBar();
		//The following two buttons are for demo purposes only
		JToggleButton button = new JToggleButton("Zoom");
		button.setActionCommand("ZOOM");
		button.addActionListener(this);
		toolBar.add(button);
		button = new JToggleButton("PM");
		button.setActionCommand("FRILLS");
		button.addActionListener(this);
		toolBar.add(button);

		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent event) {
				handleAction(Constants.EXIT_MENU_OPTION);
			}
		});

		tabbedPane = new JTabbedPane();
		tabbedPane.addTab(messages.getString(Constants.WHITEBOARD_LABEL), whiteboardTab);
		tabbedPane.addTab(messages.getString(Constants.DARTBOARD_LABEL), dartboardTab);
		tabbedPane.setSelectedComponent(dartboardTab);//for testing

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		//mainPanel.add(toolBar, BorderLayout.NORTH);
		mainPanel.add(tabbedPane, BorderLayout.CENTER);
		setContentPane(mainPanel);
		setIconImage(new ImageIcon("images/icon.gif").getImage());
		
		pack();//Resizes the window to its natural size.
		setVisible(true);
	}

	/**
	 * Handles all the menu actions.
	 * In reality, this just defers to my homebrew
	 * "handleAction" method.
	 */
	public void actionPerformed(ActionEvent e) {
		String name = e.getActionCommand();
		handleAction(name);
	}

	private void handleAction(String name) {
		if (name.equals(Constants.EXIT_MENU_OPTION)) {
			//save state information before closing
			try {
				//ward.clearWardListeners();
				File dir = new File(Constants.DATA_DIR);
				dir.mkdir();
				saveState(new File(Constants.DATA_DIR + File.separator + Constants.MEMENTO_FILENAME));
			} catch (Exception e) {
				say("Error saving the state! " + e);
			}
			System.exit(0);
		}
		if (name.equals(Constants.ABOUT_MENU_OPTION)) {
			JOptionPane.showMessageDialog(this,
					"<html>Manager's Dartboard<br>" +
					"(c)2008 Geoffrey M. Draper<br><hr>" +
					"This program is a \"proof of concept\"<br> " +
					"research prototype, not a full product.<br> It is shared in the " +
					"hope that it will<br> be useful, but should " +
					"not be used<br>in mission-critical environments." +
					"</html>",
					"About " + messages.getString(Constants.PROGRAM_TITLE),
					JOptionPane.PLAIN_MESSAGE);
		}
		if (name.equals(Constants.EDIT_PROJECTS_MENU_OPTION)) {
			new ProjectSelectorDialog(this);
		}
		if (name.equals(Constants.EDIT_RESOURCES_MENU_OPTION)) {
			new ResourceSelectorDialog(this);
		}
		if (name.equals(Constants.EDIT_SKILLS_MENU_OPTION)) {
			new SkillSelectorDialog(this);
		}
		if (name.equals("EXPORT")) {
			JFileChooser fc = new JFileChooser();
			int returnVal = fc.showSaveDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				saveState(file);
			}
		}
		if (name.equals("COMPARE1")) {
//			if (testing) {
//				try {
//					FileInputStream in = new FileInputStream(new File("/home/draperg/aaa.foo"));
//					ObjectInputStream s = new ObjectInputStream(in);
//					Auxiliary otherAux = (Auxiliary)s.readObject();
//					Ward otherWard = (Ward)s.readObject();
//					compareWards(otherWard, ward);
//				} catch (Exception e) {
//					say("Error loading file: " + e);
//				}
//				return;
//			}
			JFileChooser fc = new JFileChooser();
			fc.setDialogTitle("Select file with which to compare current configuration");
			int returnVal = fc.showOpenDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				try {
					FileInputStream in = new FileInputStream(file);
					ObjectInputStream s = new ObjectInputStream(in);
					Auxiliary otherAux = (Auxiliary)s.readObject();
					Ward otherWard = (Ward)s.readObject();
					//WhiteboardTab otherWB = new WhiteboardTab(otherWard, otherAux);
					//otherWB.restoreState(s);
					compareWards(otherWard, ward);
				} catch (Exception e) {
					say("Error loading file: " + e);
				}
			}
		}
		//TODO deal with whiteboard comparison later, once I've worked
		//out the wrinkles with dartboard comparison.
		//TODO Decide whether to keep Main.getWard() or not. This will
		//likely determine your approach to whiteboard comparison.
		if (name.equals("COMPARE2")) {
			JFileChooser fc = new JFileChooser();
			Ward ward1=null, ward2=null;
			//WhiteboardTab wb1=null, wb2=null;
			fc.setDialogTitle("Select File #1");
			int returnVal = fc.showOpenDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				File file = fc.getSelectedFile();
				try {
					FileInputStream in = new FileInputStream(file);
					ObjectInputStream s = new ObjectInputStream(in);
					Auxiliary aux1 = (Auxiliary)s.readObject();
					ward1 = (Ward)s.readObject();
					//wb1 = new WhiteboardTab(ward1, aux1);
					//wb1.restoreState(s);
				} catch (Exception e) {
					say("Error loading file: " + e);
				}
				
				fc.setDialogTitle("Select File #2");
				returnVal = fc.showOpenDialog(this);
				if (returnVal == JFileChooser.APPROVE_OPTION) {
					file = fc.getSelectedFile();
					try {
						FileInputStream in = new FileInputStream(file);
						ObjectInputStream s = new ObjectInputStream(in);
						Auxiliary aux2 = (Auxiliary)s.readObject();
						ward2 = (Ward)s.readObject();
						//wb2 = new WhiteboardTab(ward2, aux2);
						//wb2.restoreState(s);
					} catch (Exception e) {
						say("Error loading file: " + e);
					}
				}

			}
			if ((ward1 != null) /*&& (wb1 != null)*/
					&& (ward2 != null) /*&& (wb2 != null)*/) {
				compareWards(ward1, ward2);
			} else {
				//TODO report an error
			}
		}
		if (name.equals("ZOOM")) {
			Config.db_zoom = !Config.db_zoom;
			ward.familyChanged();
		}
		if (name.equals("FRILLS")) {
			Config.db_frills = !Config.db_frills;
			ward.familyChanged();
		}

	}	

	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}	
	public void mousePressed(MouseEvent e) {}	
	public void mouseReleased(MouseEvent e) {}

	public static void pause(long m) {
		try {
			Thread.sleep(m);
		} catch (InterruptedException e) {say("pause(): exception caught");}
	}

	public static void say(Object s) {
		System.out.println(s.toString());
	}

	//This should only be used by GUI components
	public static Ward getWard() {
		return ward;
	}
	
	private void compareWards(Ward ward1, Ward ward2) {
		
		//create new "diff" tabs
		DiffWard diffWard = new DiffWard(ward1, ward2);
		DiffDartboardTab diffDartBoard = new DiffDartboardTab(diffWard);
		DiffWhiteboardTab diffWhiteBoard = new DiffWhiteboardTab(diffWard);
		ward1.addWardListener(diffDartBoard);//I don't think this is necessary.
		ward1.addWardListener(diffWhiteBoard);//I don't think this is necessary.
		ward2.addWardListener(diffDartBoard);
		ward2.addWardListener(diffWhiteBoard);
		
		//remove previous "diff" tabs, if any
		int diffWhiteBoardTabIndex = tabbedPane.indexOfTab(messages.getString(Constants.DIFF_WHITEBOARD_LABEL));
		if (diffWhiteBoardTabIndex != -1) {
			tabbedPane.remove(diffWhiteBoardTabIndex);
		}
		int diffDartBoardTabIndex = tabbedPane.indexOfTab(messages.getString(Constants.DIFF_DARTBOARD_LABEL));
		if (diffDartBoardTabIndex != -1) {
			tabbedPane.remove(diffDartBoardTabIndex);
		}
		
		//add new "diff" tabs to tabbed pane
		tabbedPane.add(messages.getString(Constants.DIFF_WHITEBOARD_LABEL), diffWhiteBoard);
		tabbedPane.setTabComponentAt(tabbedPane.indexOfTab(messages.getString(Constants.DIFF_WHITEBOARD_LABEL)),
				new ButtonTabComponent(tabbedPane));
		tabbedPane.add(messages.getString(Constants.DIFF_DARTBOARD_LABEL), diffDartBoard);
		tabbedPane.setTabComponentAt(tabbedPane.indexOfTab(messages.getString(Constants.DIFF_DARTBOARD_LABEL)),
				new ButtonTabComponent(tabbedPane));
		tabbedPane.setSelectedComponent(diffDartBoard);
				
	}

	public static void main(String[] args) {
		messages = ResourceBundle.getBundle(Constants.RESOURCE_BUNDLE_FILE);
		Config.init();

		//this makes the GUI adopt the look-n-feel of the windowing system (Windows/X/Mac)
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) { }

		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				Main.instance();
			}
		});
	}

	private void saveState(File f) {
		//we clear the ward listeners before saving,
		//to simplify the serialization process.
		List<WardListener> backup = ward.clearWardListeners();
		try {
			FileOutputStream out = new FileOutputStream(f);
			ObjectOutputStream s = new ObjectOutputStream(out);
			s.writeObject(currentAuxiliary);
			s.writeObject(ward);
			whiteboardTab.saveState(s);
			s.flush();
		} catch (Exception e) {
			say("Error saving the state! " + e);
		}
		//now, restore the listeners to the way they were.
		ward.restoreWardListeners(backup);

	}
	
	private void testing() {
		Skill programmer1 = new Skill("C++ Programmer", ward);
		Skill analyst = new Skill("Business Analyst", ward);
		Skill sysadmin = new Skill("Sys Admin", ward);
		Skill html = new Skill("HTML", ward);
		Skill writing = new Skill("Tech. Writing", ward);
		Resource bob = new Resource(ward);
		bob.setName("Dave");
		bob.addSkill(programmer1);
		//bob.addSkill(analyst);
		Resource ted = new Resource(ward);
		ted.setName("Ted");
		ted.addSkill(sysadmin);
		ted.setCapacity(0.75f);
		Resource carol = new Resource(ward);
		carol.setName("Carol");
		carol.addSkill(programmer1);
		Resource alice = new Resource(ward);
		alice.setName("Alice");
		alice.addSkill(programmer1);
		Resource jeff = new Resource(ward);
		jeff.setName("Jeff");
		Resource lewis = new Resource(ward);
		lewis.setName("Lewis");
		Resource betty = new Resource(ward);
		betty.setName("Betty");
		Resource grace = new Resource(ward);
		grace.setName("Grace");

		Calendar cal = Calendar.getInstance();
		cal.set(2008, 2, 15);

		Project dataWarehouse = new Project(ward);
		dataWarehouse.setName("Data Warehouse");
		dataWarehouse.addSkill(sysadmin);
		dataWarehouse.addSkill(sysadmin);
		dataWarehouse.addSkill(analyst);
		dataWarehouse.setPercentComplete(50);
		dataWarehouse.setDeadline(cal);

		Project gameEngine = new Project(ward);
		gameEngine.setName("Game Engine");
		gameEngine.addSkill(programmer1);
		gameEngine.setPercentComplete(20);
		cal.set(2008, 7, 18);
		gameEngine.setDeadline(cal);
		Project helpDesk = new Project(ward);
		helpDesk.setName("Help Desk");
		Project guiUpdates = new Project(ward);
		guiUpdates.setName("GUI Updates");
		guiUpdates.addSkill(writing);
		guiUpdates.setPercentComplete(66);
		guiUpdates.setPriority(Priority.High);
		cal.set(2008, 7, 24);
		guiUpdates.setDeadline(cal);
		Project webDeployment = new Project(ward);
		webDeployment.setPercentComplete(80);
		webDeployment.setName("Web Deployment");
		webDeployment.addSkill(html);
		cal.set(2008, 1, 11);
		webDeployment.setDeadline(cal);
		Project serverFarm = new Project(ward);
		serverFarm.setName("Server Farm");
		serverFarm.setPercentComplete(15);
		cal.set(2008, 5, 9);
		serverFarm.setDeadline(cal);
		Project optimize = new Project(ward);
		optimize.setName("Code Optimization");
		optimize.setPercentComplete(10);
		optimize.addSkill(programmer1);
		cal.set(2008, 11, 14);
		optimize.setDeadline(cal);
		Project tax = new Project(ward);
		tax.setName("Tax Revisions");
		tax.setPercentComplete(15);
		tax.addSkill(analyst);
		tax.addSkill(writing);
		cal.set(2009, 1, 14);
		tax.setDeadline(cal);
		Project ntdus = new Project(ward);
		ntdus.setName("NTDUS");
		ntdus.setPercentComplete(5);
		ntdus.addSkill(programmer1);
		ntdus.addSkill(html);
		cal.set(2009, 2, 14);
		ntdus.setDeadline(cal);

		Team team1 = new Team();
		team1.addProject(dataWarehouse);
		team1.addResource(grace);

		Team team2 = new Team();
		team2.addProject(gameEngine);
		team2.addResource(betty);
		team2.addResource(lewis);
		team2.addResource(grace);
		
		Team team3 = new Team();
		team3.addProject(helpDesk);
		team3.addResource(alice);
		team3.addResource(carol);
		team3.addResource(ted);

		Team team4 = new Team();
		team4.addProject(webDeployment);
		team4.addResource(bob);
		team4.addResource(carol);
		team4.addResource(jeff);

		Team team5 = new Team();
		team5.addProject(guiUpdates);
		team5.addResource(bob);
		team5.addResource(ted);
		team5.addResource(alice);
		team5.addResource(betty);

		Team team6 = new Team();
		team6.addProject(serverFarm);
		team6.addResource(ted);
		team6.addResource(carol);
		team6.addResource(jeff);
		
		Team team7 = new Team();
		team7.addProject(optimize);
		team7.addResource(alice);
		team7.addResource(grace);
		team7.addResource(bob);

		Team team8 = new Team();
		team8.addProject(tax);
		team8.addResource(alice);
		team8.addResource(lewis);
		team8.addResource(ted);

		Team team9 = new Team();
		team9.addProject(ntdus);
		team9.addResource(alice);
		team9.addResource(jeff);
		team9.addResource(bob);
		team9.addResource(carol);

		ward.addResource(bob);
		ward.addResource(ted);
		ward.addResource(carol);
		ward.addResource(alice);
		ward.addResource(jeff);
		ward.addResource(lewis);
		ward.addResource(betty);
		ward.addResource(grace);
		ward.addProject(dataWarehouse);
		ward.addProject(gameEngine);
		ward.addProject(helpDesk);
		ward.addProject(guiUpdates);
		ward.addProject(webDeployment);
		ward.addProject(serverFarm);
		ward.addProject(optimize);
		ward.addProject(tax);
		ward.addProject(ntdus);
		ward.addSkill(programmer1);
		ward.addSkill(analyst);
		ward.addSkill(sysadmin);
		ward.addSkill(html);
		ward.addSkill(writing);
		whiteboardTab.arrangeTeamsNicely();
	}

	private void movieSetup() {
		Skill programmer1 = new Skill("C++ Programmer", ward);
		Skill analyst = new Skill("Business Analyst", ward);
		Skill sysadmin = new Skill("Sys Admin", ward);
		//Skill html = new Skill("HTML", ward);
		Skill writing = new Skill("Tech. Writing", ward);
		Resource bob = new Resource(ward);
		bob.setName("Bob");
		bob.addSkill(programmer1);
		//bob.addSkill(analyst);
		Resource ted = new Resource(ward);
		ted.setName("Ted");
		ted.addSkill(sysadmin);
		ted.setCapacity(0.75f);
		Resource carol = new Resource(ward);
		carol.setName("Carol");
		carol.addSkill(programmer1);
		carol.addSkill(writing);
		Resource alice = new Resource(ward);
		alice.setName("Alice");
		alice.addSkill(programmer1);
		alice.addSkill(sysadmin);
		Resource jeff = new Resource(ward);
		jeff.setName("Jeff");
		jeff.addSkill(analyst);
		//Resource lewis = new Resource(ward);
		//lewis.setName("Lewis");
		//Resource betty = new Resource(ward);
		//betty.setName("Betty");
		//Resource grace = new Resource(ward);
		//grace.setName("Grace");

		Calendar cal = Calendar.getInstance();
		cal.set(2009, 2, 15);

		Project dataWarehouse = new Project(ward);
		dataWarehouse.setName("Data Warehouse");
		dataWarehouse.addSkill(sysadmin);
		dataWarehouse.addSkill(sysadmin);
		//dataWarehouse.addSkill(analyst);
		dataWarehouse.setPercentComplete(50);
		dataWarehouse.setDeadline(cal);

		Project gameEngine = new Project(ward);
		gameEngine.setName("Game Engine");
		//gameEngine.addSkill(programmer1);
		gameEngine.setPercentComplete(20);
		cal.set(2009, 7, 18);
		gameEngine.setDeadline(cal);
		//Project helpDesk = new Project(ward);
		//helpDesk.setName("Help Desk");
		Project guiUpdates = new Project(ward);
		guiUpdates.setName("GUI Updates");
		//guiUpdates.addSkill(writing);
		guiUpdates.setPercentComplete(66);
		guiUpdates.setPriority(Priority.High);
		cal.set(2009, 7, 24);
		guiUpdates.setDeadline(cal);
		Project webDeployment = new Project(ward);
		webDeployment.setPercentComplete(80);
		webDeployment.setName("Web Deployment");
		webDeployment.addSkill(sysadmin);
		//webDeployment.addSkill(programmer1);
		cal.set(2009, 1, 11);
		webDeployment.setDeadline(cal);
		Project serverFarm = new Project(ward);
		serverFarm.setName("Server Farm");
		serverFarm.setPercentComplete(15);
		cal.set(2009, 5, 9);
		serverFarm.setDeadline(cal);
		//Project optimize = new Project(ward);
		//optimize.setName("Code Optimization");
		//optimize.setPercentComplete(10);
		//optimize.addSkill(programmer1);
		//cal.set(2009, 11, 14);
		//optimize.setDeadline(cal);
		//Project tax = new Project(ward);
		//tax.setName("Tax Revisions");
		//tax.setPercentComplete(15);
		//tax.addSkill(analyst);
		//tax.addSkill(writing);
		//cal.set(2010, 1, 14);
		//tax.setDeadline(cal);
		Project ntdus = new Project(ward);
		ntdus.setName("New Project");
		ntdus.setPercentComplete(0);
		ntdus.addSkill(programmer1);
		ntdus.addSkill(analyst);
		cal.set(2010, 2, 14);
		ntdus.setDeadline(cal);

		Team team1 = new Team();
		team1.addProject(dataWarehouse);
		team1.addResource(ted);

		//Companionship team2 = new Companionship();
		//team2.addProject(gameEngine);
		//team2.addResource(betty);
		//team2.addResource(lewis);
		//team2.addResource(grace);
		
		//Companionship team3 = new Companionship();
		//team3.addProject(helpDesk);
		//team3.addResource(alice);
		//team3.addResource(carol);
		//team3.addResource(ted);

		Team team4 = new Team();
		team4.addProject(webDeployment);
		team4.addResource(bob);
		team4.addResource(carol);
		team4.addResource(alice);

		Team team5 = new Team();
		team5.addProject(guiUpdates);
		team5.addResource(bob);
		//team5.addResource(ted);
		team5.addResource(alice);
		//team5.addResource(betty);

		Team team6 = new Team();
		team6.addProject(serverFarm);
		team6.addResource(bob);
		//team6.addResource(carol);
		team6.addResource(alice);
		
		Team team7 = new Team();
		team7.addProject(gameEngine);
		team7.addResource(carol);

	//	Companionship team8 = new Companionship();
	//	team8.addProject(tax);
	//	team8.addResource(alice);
	//	team8.addResource(lewis);
	//	team8.addResource(ted);

	//	Companionship team9 = new Companionship();
	//	team9.addProject(ntdus);
		//team9.addResource(alice);
		//team9.addResource(jeff);
		//team9.addResource(bob);
		//team9.addResource(carol);

		ward.addResource(bob);
		ward.addResource(ted);
		ward.addResource(carol);
		ward.addResource(alice);
		ward.addResource(jeff);
		//ward.addResource(lewis);
		//ward.addResource(betty);
		//ward.addResource(grace);
		ward.addProject(dataWarehouse);
		ward.addProject(gameEngine);
		//ward.addProject(helpDesk);
		ward.addProject(guiUpdates);
		ward.addProject(webDeployment);
		ward.addProject(serverFarm);
		//ward.addProject(optimize);
		//ward.addProject(tax);
		ward.addProject(ntdus);
		ward.addSkill(programmer1);
		ward.addSkill(analyst);
		ward.addSkill(sysadmin);
		//ward.addSkill(html);
		ward.addSkill(writing);
		whiteboardTab.arrangeTeamsNicely();
	}


}
