package projman;

import java.io.Serializable;

/**
 * This class maintains a cache of vertices for use in drawing
 * the circle.  This saves some computation when rotating the
 * wedges of the circle, or adding and removing wedges because
 * no trigonometry needs to be recomputed.  The cache is only
 * refreshed when the window is resized.
 * Acknowledgement: This class was inspired by discussions with
 * Dr. Yarden Livnat (SCI Institute, University of Utah).
 * @author draperg
 *
 */
public class RadialCache implements Serializable {
	public static final int RESOLUTION = 1000; //MUST be > 0
	private java.awt.geom.Point2D.Float[][] vertices;
	private static final long serialVersionUID = 42L;
	private static final float dt = (float)(2*Math.PI / RESOLUTION);
	private static final int hack = RESOLUTION/2;

	
	public RadialCache() {
		vertices = new java.awt.geom.Point2D.Float[Config.db_totalNumberOfRadii][RESOLUTION];
	}
	
	//FIXME: this method is called twice at the beginning of the
	//program instead of just once.  Why?
	public void setRadii(final float radii[], final java.awt.geom.Point2D offset) {
		float theta, sine, cosine;
		float x,y;
		theta = 0;
		for (int i=0; i<RESOLUTION; ++i) {
			sine = (float)Math.sin(theta);
			cosine = (float)Math.cos(theta);
			for (int j=0; j<Config.db_totalNumberOfRadii; ++j) {
				x = (radii[j] * sine) + (float)offset.getX();
				y = (-1 * radii[j] * cosine) + (float)offset.getY();
				vertices[j][i] = new java.awt.geom.Point2D.Float(x, y);
				//BAD MOVE... TRYING TO OPTIMIZE PREMATURELY.
				//HOW DO YOU KNOW THAT SINE/COSINE IS EVEN A BOTTLENECK?
				//TODO try making this work if it becomes an issue.
//				vertices[j][RESOLUTION/2-i] = new Point(x, -y);
//				vertices[j][RESOLUTION-1-i] = new Point(-x, y);
//				vertices[j][i+RESOLUTION/2] = new Point(-x, -y);
//				vertices[j][RESOLUTION/4-i] = new Point(y, x);
//				vertices[j][i+RESOLUTION/4] = new Point(y, -x);
//				vertices[j][3*RESOLUTION/4+i] = new Point(-y, x);
//				vertices[j][3*RESOLUTION/4-i] = new Point(-y, -x);
			}
			theta += dt;
		}
//		for (int i=0; i<RESOLUTION; ++i) {
//			if (vertices[Config.db_totalNumberOfRadii-1][i] != null) {
//				Main.say("Point " + i + " = (" + vertices[Config.db_totalNumberOfRadii-1][i].x + ","
//						+ vertices[Config.db_totalNumberOfRadii-1][i].y + ")");
//			} else {
//				Main.say("Point " + i + " = NULL");
//			}
//		}
	}
	
	//This method does no error checking.
	//I can live with that; how about you?
	public java.awt.geom.Point2D.Float getVertex(final int radiusIndex, final int degree) {
		return vertices[radiusIndex][degree];
	}
	
	public static java.awt.geom.Point2D.Float getSpecialVertex(final float trueRadius,
			final int index, final java.awt.geom.Point2D.Float offset) {
		float theta = dt*(hack-index);
		float sine = (float)Math.sin(theta);
		float cosine = (float)Math.cos(theta);
		return new java.awt.geom.Point2D.Float(Math.round(trueRadius*sine)
				+ offset.x, Math.round(trueRadius*cosine) + offset.y);
	}
	
}
