package projman;


public class ResourceUtilizationPolygon extends HyrumPolygon
		implements Comparable<ResourceUtilizationPolygon> {
	
	private Resource resource;
	private Project project;
	private double percentDevotedToThisProject;
	private int baseIndex;
	private int length;
	
	public ResourceUtilizationPolygon() {
		super();
		resource = null;
		project = null;
		percentDevotedToThisProject = 1f;
	}

	public ResourceUtilizationPolygon(Resource res) {
		super();
		resource = res;
		project = null;
		percentDevotedToThisProject = 1f;
	}

	public double getPercentDevotedToThisProject() {
		return percentDevotedToThisProject;
	}

	public void setPercentDevotedToThisProject(double percentDevotedToThisProject) {
		this.percentDevotedToThisProject = percentDevotedToThisProject;
	}

	public Project getProject() {
		return project;
	}

	public void setProject(Project project) {
		this.project = project;
	}

	public Resource getResource() {
		return resource;
	}

	public void setResource(Resource resource) {
		this.resource = resource;
	}

	public int compareTo(ResourceUtilizationPolygon o) {
		return (new java.lang.Float(this.percentDevotedToThisProject)
			.compareTo(new java.lang.Float(o.percentDevotedToThisProject)));
	}
	
	@Override
	public boolean equals(Object o) {
		if (!(o instanceof ResourceUtilizationPolygon))
			return false;
		return (this.percentDevotedToThisProject == ((ResourceUtilizationPolygon)o).percentDevotedToThisProject);
	}

	public void setBaseIndex(int baseIndex) {
		this.baseIndex = baseIndex;
	}

	public void setLength(int length) {
		this.length = length;
	}
	
	public int getMiddleIndex() {
		return baseIndex + length/2;
	}
}
