package projman;

import java.util.ArrayList;
import java.util.List;

import javax.swing.ImageIcon;

public class Skill implements Entity {

	private String name;
	private boolean changed;
//	private DiffStatus diff;
	private Ward ward;

	
	public Skill(String name, Ward ward) {
		this.name = name;
		changed = false;
//		diff = DiffStatus.SAME;
		this.ward = ward;
	}
	
	public Skill(Ward ward) {
		this.name = Main.messages.getString(Constants.DEFAULT_SKILL_NAME);
		changed = false;
//		diff = DiffStatus.SAME;
		this.ward = ward;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
		setChanged(true);
	}

	public boolean isChanged() {
		return changed;
	}

	public void setChanged(boolean changed) {
		this.changed = changed;
	}

	public int compareTo(Entity o) {
		if (!(o instanceof Skill)) return 0;
		return (name.compareTo(o.getName()));
	}
	
	@Override
	public boolean equals(Object o) {
		if (!(o instanceof Skill)) return false;
		return (name.equals(((Skill)o).getName()));
	}
	
	public List<Project> getMatchingProjects() {
		List<Project> result = new ArrayList<Project>();
		for (Project p : ward.getAllProjects()) {
			if (p.requiresSkill(this)) {
				result.add(p);
			}
		}
		return result;
	}

	public List<Resource> getMatchingResources() {
		List<Resource> result = new ArrayList<Resource>();
		for (Resource p : ward.getAllResources()) {
			if (p.possessesSkill(this)) {
				result.add(p);
			}
		}
		return result;
	}

	//legacy baggage; ignore
	public Auxiliary getAuxiliaryAffiliation() { return Config.DEFAULT_AUX; }
	public void setAuxiliaryAffiliation(Auxiliary aux) {}
	public void setPhoto(String filename) {}
	public ImageIcon getPhoto() {return null;}

	public boolean attemptToAffiliate(Entity other) {
		if (other instanceof Skill) return false;
		if (other instanceof Project) {
			Project proj = (Project)other;
			//if (proj.requiresSkill(this)) return false;
			proj.addSkill(this);
			return true;
		}
		if (other instanceof Resource) {
			Resource res = (Resource)other;
			if (res.possessesSkill(this)) return false;
			res.addSkill(this);
			return true;
		}
		return false;
	}
	
	public boolean attemptToDisaffiliate(Entity other) {
		//nothing to do here;
		//skills never go "to" a project or resource
		//projects require skills (from project to skill)
		//resources possess skills (from resource to skill)
		return false;
	}
	
//	public DiffStatus getDiffStatus() {
//		return diff;
//	}
//
//	public void setDiffStatus(DiffStatus ds) {
//		diff = ds;		
//	}

	public Ward getWard() {
		return ward;
	}


}
