package projman;


import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import projman.AbstractWhiteboard.ChartStyle;



public class WhiteboardCard extends NameCard {

	private EntityStatus status;
	private WhiteboardTeam team;
	private static final long serialVersionUID = 42L;

	public WhiteboardCard(Entity entity, EntityStatus ts, Point loc, Graphics2D g) {
		super(entity, loc, g);
		status = ts;
	}

//	public WhiteboardCard(TeacherOrTeachee entity, TeachingStatus ts, Point loc) {
//		super(entity);
//		status = ts;
//		centerOfGravity.setLocation(loc);
//		prevPosition = new Point();
//	}

	public WhiteboardTeam getAffiliatedTeam() {
		return team;
	}

	/**
	 * NOT FOR USE WITH DRAG AND DROP.
	 * This method simply provides a "back door" for processing
	 * automatically-generated cards (for sync'ing dartboard
	 * and whiteboard)
	 * @param wt
	 */
	public void setAffiliatedTeam(WhiteboardTeam wt) {
		team = wt;
	}

	public void assignToTeam(WhiteboardTeam wt) {
		team = wt;
		//The Companionship object is only relevant in
		//non-diff mode.
		if (diffWard == null) {
			Team c = wt.getTeam();
			if (status == EntityStatus.PROJECT) {
				c.addTeacher((ResourceBase)getEntity());
				//Main.say(getEntity() + " is now a companion in team " + c);
			} else {
				c.addTeachee((ProjectBase)getEntity());
				//Main.say(getEntity() + " is now taught by " + c);
			}
		}
	}

	public void removeFromTeam(WhiteboardTeam wt) {
		team = null;
		//The Companionship object is only relevant in
		//non-diff mode.
		if (diffWard == null) {
			Team c = wt.getTeam();
			if (status == EntityStatus.PROJECT) {
				c.removeTeacher((ResourceBase)getEntity());
				//Main.say(getEntity() + " no longer a companion in team " + c);
			} else {
				c.removeTeachee((ProjectBase)getEntity());
				//Main.say(getEntity() + " no longer taught by " + c);
			}
		}
	}

	public EntityStatus getTeachingStatus() {
		return status;
	}

//	@Override
//	public void draw(Graphics2D g) {
//	super.draw(g);
//	}

	@Override
	public void drawPopupMenu(Component comp, Point pos) {
		JPopupMenu menu = new JPopupMenu();
		JMenuItem menuItem = new JMenuItem(Main.messages.getString(Constants.EDIT_BUTTON_LABEL));
		menuItem.setActionCommand(Constants.EDIT_BUTTON_LABEL);
		menuItem.addActionListener(this);
		menu.add(menuItem);
		menu.show(comp, pos.x, pos.y);
	}

//	@Override
//	protected void handleActionEvent(String command) {
//	super.handleActionEvent(command);
//	}


//	@Override
//	protected Color getCardColor() {
//	return Config.getColorForEntity(getEntity(), diffStatus);		
//	}

	public Point getTeacherConnectionPoint2(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x, geometry.y + geometry.height/2);
	}

	public Point getTeacherConnectionPoint1(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x+geometry.width, geometry.y + geometry.height/2);
	}

	public Point getTeacherToTeacheeConnectionPoint1(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x+geometry.width/2, geometry.y+geometry.height);
	}

	public Point getTeacherToTeacheeConnectionPoint2(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x+geometry.width/2, geometry.y+geometry.height+Config.wb_distanceBetweenCards/3);
	}

	public Point getTeacheeToTeacherConnectionPoint1(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x+geometry.width/2, geometry.y);
	}

	public Point getTeacheeToTeacherConnectionPoint2(ChartStyle style) {
		//TODO use the ChartStyle
		return new Point(geometry.x+geometry.width/2, geometry.y-Config.wb_distanceBetweenCards/3);
	}

	public Point getTeacheeToTeacheeConnectionPoint1(ChartStyle style) {
		return getTeacherToTeacheeConnectionPoint1(style);
	}

	public Point getTeacheeToTeacheeConnectionPoint2(ChartStyle style) {
		return getTeacheeToTeacherConnectionPoint1(style);
	}
}
